/*
 * Decompiled with CFR 0.152.
 */
package org.spaceroots.mantissa.algebra;

import java.util.ArrayList;
import org.spaceroots.mantissa.algebra.RationalNumber;

public abstract class CoefficientsGenerator {
    private ArrayList l = new ArrayList();
    private int maxDegree;
    private RationalNumber b2k;
    private RationalNumber b3k;
    private RationalNumber b4k;

    protected CoefficientsGenerator(RationalNumber a00, RationalNumber a01, RationalNumber a11) {
        this.l.add(a00);
        this.l.add(a01);
        this.l.add(a11);
        this.maxDegree = 1;
    }

    protected void setRecurrenceCoefficients(RationalNumber b2k, RationalNumber b3k, RationalNumber b4k) {
        this.b2k = b2k;
        this.b3k = b3k;
        this.b4k = b4k;
    }

    protected abstract void setRecurrenceCoefficients(int var1);

    private void computeUpToDegree(int degree) {
        int startK = (this.maxDegree - 1) * this.maxDegree / 2;
        for (int k = this.maxDegree; k < degree; ++k) {
            int startKm1 = startK;
            this.setRecurrenceCoefficients(k);
            RationalNumber ckPrev = null;
            RationalNumber ck = (RationalNumber)this.l.get(startK += k);
            RationalNumber ckm1 = (RationalNumber)this.l.get(startKm1);
            this.l.add(ck.multiply(this.b2k).subtract(ckm1.multiply(this.b4k)));
            for (int i = 1; i < k; ++i) {
                ckPrev = ck;
                ck = (RationalNumber)this.l.get(startK + i);
                ckm1 = (RationalNumber)this.l.get(startKm1 + i);
                this.l.add(ck.multiply(this.b2k).add(ckPrev.multiply(this.b3k)).subtract(ckm1.multiply(this.b4k)));
            }
            ckPrev = ck;
            ck = (RationalNumber)this.l.get(startK + k);
            this.l.add(ck.multiply(this.b2k).add(ckPrev.multiply(this.b3k)));
            this.l.add(ck.multiply(this.b3k));
        }
        this.maxDegree = degree;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RationalNumber[] getCoefficients(int degree) {
        CoefficientsGenerator coefficientsGenerator = this;
        synchronized (coefficientsGenerator) {
            if (degree > this.maxDegree) {
                this.computeUpToDegree(degree);
            }
        }
        int start = degree * (degree + 1) / 2;
        RationalNumber[] a = new RationalNumber[degree + 1];
        for (int i = 0; i <= degree; ++i) {
            a[i] = (RationalNumber)this.l.get(start + i);
        }
        return a;
    }
}

