/*
 * Decompiled with CFR 0.152.
 */
package org.spaceroots.mantissa.ode;

import org.spaceroots.mantissa.ode.DerivativeException;
import org.spaceroots.mantissa.ode.DummyStepHandler;
import org.spaceroots.mantissa.ode.FirstOrderDifferentialEquations;
import org.spaceroots.mantissa.ode.FirstOrderIntegrator;
import org.spaceroots.mantissa.ode.IntegratorException;
import org.spaceroots.mantissa.ode.StepHandler;
import org.spaceroots.mantissa.ode.SwitchingFunction;
import org.spaceroots.mantissa.ode.SwitchingFunctionsHandler;

public abstract class AdaptiveStepsizeIntegrator
implements FirstOrderIntegrator {
    private double minStep;
    private double maxStep;
    private double initialStep;
    protected double scalAbsoluteTolerance;
    protected double scalRelativeTolerance;
    protected double[] vecAbsoluteTolerance;
    protected double[] vecRelativeTolerance;
    protected StepHandler handler;
    protected SwitchingFunctionsHandler switchesHandler;
    protected double stepStart;
    protected double stepSize;

    public AdaptiveStepsizeIntegrator(double minStep, double maxStep, double scalAbsoluteTolerance, double scalRelativeTolerance) {
        this.minStep = minStep;
        this.maxStep = maxStep;
        this.initialStep = -1.0;
        this.scalAbsoluteTolerance = scalAbsoluteTolerance;
        this.scalRelativeTolerance = scalRelativeTolerance;
        this.vecAbsoluteTolerance = null;
        this.vecRelativeTolerance = null;
        this.handler = DummyStepHandler.getInstance();
        this.switchesHandler = new SwitchingFunctionsHandler();
        this.resetInternalState();
    }

    public AdaptiveStepsizeIntegrator(double minStep, double maxStep, double[] vecAbsoluteTolerance, double[] vecRelativeTolerance) {
        this.minStep = minStep;
        this.maxStep = maxStep;
        this.initialStep = -1.0;
        this.scalAbsoluteTolerance = 0.0;
        this.scalRelativeTolerance = 0.0;
        this.vecAbsoluteTolerance = vecAbsoluteTolerance;
        this.vecRelativeTolerance = vecRelativeTolerance;
        this.handler = DummyStepHandler.getInstance();
        this.switchesHandler = new SwitchingFunctionsHandler();
        this.resetInternalState();
    }

    public void setInitialStepSize(double initialStepSize) {
        this.initialStep = initialStepSize < this.minStep || initialStepSize > this.maxStep ? -1.0 : initialStepSize;
    }

    @Override
    public void setStepHandler(StepHandler handler) {
        this.handler = handler;
    }

    @Override
    public StepHandler getStepHandler() {
        return this.handler;
    }

    @Override
    public void addSwitchingFunction(SwitchingFunction function, double maxCheckInterval, double convergence) {
        this.switchesHandler.add(function, maxCheckInterval, convergence);
    }

    public double initializeStep(FirstOrderDifferentialEquations equations, boolean forward, int order, double[] scale, double t0, double[] y0, double[] yDot0, double[] y1, double[] yDot1) throws DerivativeException {
        double h;
        double ratio;
        if (this.initialStep > 0.0) {
            return forward ? this.initialStep : -this.initialStep;
        }
        double yOnScale2 = 0.0;
        double yDotOnScale2 = 0.0;
        for (int j = 0; j < y0.length; ++j) {
            ratio = y0[j] / scale[j];
            yOnScale2 += ratio * ratio;
            ratio = yDot0[j] / scale[j];
            yDotOnScale2 += ratio * ratio;
        }
        double d = h = yOnScale2 < 1.0E-10 || yDotOnScale2 < 1.0E-10 ? 1.0E-6 : 0.01 * Math.sqrt(yOnScale2 / yDotOnScale2);
        if (!forward) {
            h = -h;
        }
        for (int j = 0; j < y0.length; ++j) {
            y1[j] = y0[j] + h * yDot0[j];
        }
        equations.computeDerivatives(t0 + h, y1, yDot1);
        double yDDotOnScale = 0.0;
        for (int j = 0; j < y0.length; ++j) {
            ratio = (yDot1[j] - yDot0[j]) / scale[j];
            yDDotOnScale += ratio * ratio;
        }
        yDDotOnScale = Math.sqrt(yDDotOnScale) / h;
        double maxInv2 = Math.max(Math.sqrt(yDotOnScale2), yDDotOnScale);
        double h1 = maxInv2 < 1.0E-15 ? Math.max(1.0E-6, 0.001 * Math.abs(h)) : Math.pow(0.01 / maxInv2, 1.0 / (double)order);
        h = Math.min(100.0 * Math.abs(h), h1);
        if ((h = Math.max(h, 1.0E-12 * Math.abs(t0))) < this.getMinStep()) {
            h = this.getMinStep();
        }
        if (h > this.getMaxStep()) {
            h = this.getMaxStep();
        }
        if (!forward) {
            h = -h;
        }
        return h;
    }

    protected double filterStep(double h, boolean acceptSmall) throws IntegratorException {
        if (Math.abs(h) < this.minStep) {
            if (acceptSmall) {
                h = h < 0.0 ? -this.minStep : this.minStep;
            } else {
                throw new IntegratorException("minimal step size ({0}) reached, integration needs {1}", new String[]{Double.toString(this.minStep), Double.toString(Math.abs(h))});
            }
        }
        if (h > this.maxStep) {
            h = this.maxStep;
        } else if (h < -this.maxStep) {
            h = -this.maxStep;
        }
        return h;
    }

    @Override
    public abstract void integrate(FirstOrderDifferentialEquations var1, double var2, double[] var4, double var5, double[] var7) throws DerivativeException, IntegratorException;

    @Override
    public double getCurrentStepStart() {
        return this.stepStart;
    }

    @Override
    public double getCurrentStepsize() {
        return this.stepSize;
    }

    protected void resetInternalState() {
        this.stepStart = Double.NaN;
        this.stepSize = Math.sqrt(this.minStep * this.maxStep);
    }

    public double getMinStep() {
        return this.minStep;
    }

    public double getMaxStep() {
        return this.maxStep;
    }
}

