/*
 * Decompiled with CFR 0.152.
 */
package org.spaceroots.mantissa.ode;

import org.spaceroots.mantissa.ode.DerivativeException;
import org.spaceroots.mantissa.ode.RungeKuttaStepInterpolator;

class ClassicalRungeKuttaStepInterpolator
extends RungeKuttaStepInterpolator {
    private static final long serialVersionUID = -6576285612589783992L;

    public ClassicalRungeKuttaStepInterpolator() {
    }

    public ClassicalRungeKuttaStepInterpolator(ClassicalRungeKuttaStepInterpolator interpolator) {
        super(interpolator);
    }

    @Override
    public Object clone() {
        return new ClassicalRungeKuttaStepInterpolator(this);
    }

    @Override
    protected void computeInterpolatedState(double theta, double oneMinusThetaH) throws DerivativeException {
        double fourTheta = 4.0 * theta;
        double s = oneMinusThetaH / 6.0;
        double coeff1 = s * ((-fourTheta + 5.0) * theta - 1.0);
        double coeff23 = s * ((fourTheta - 2.0) * theta - 2.0);
        double coeff4 = s * ((-fourTheta - 1.0) * theta - 1.0);
        for (int i = 0; i < this.interpolatedState.length; ++i) {
            this.interpolatedState[i] = this.currentState[i] + coeff1 * this.yDotK[0][i] + coeff23 * (this.yDotK[1][i] + this.yDotK[2][i]) + coeff4 * this.yDotK[3][i];
        }
    }
}

