/*
 * Decompiled with CFR 0.152.
 */
package org.spaceroots.mantissa.ode;

import org.spaceroots.mantissa.ode.AbstractStepInterpolator;
import org.spaceroots.mantissa.ode.DerivativeException;
import org.spaceroots.mantissa.ode.DummyStepHandler;
import org.spaceroots.mantissa.ode.DummyStepInterpolator;
import org.spaceroots.mantissa.ode.FirstOrderDifferentialEquations;
import org.spaceroots.mantissa.ode.FirstOrderIntegrator;
import org.spaceroots.mantissa.ode.IntegratorException;
import org.spaceroots.mantissa.ode.RungeKuttaStepInterpolator;
import org.spaceroots.mantissa.ode.StepHandler;
import org.spaceroots.mantissa.ode.SwitchingFunction;
import org.spaceroots.mantissa.ode.SwitchingFunctionsHandler;

public abstract class RungeKuttaIntegrator
implements FirstOrderIntegrator {
    private boolean fsal;
    private double[] c;
    private double[][] a;
    private double[] b;
    private RungeKuttaStepInterpolator prototype;
    private double step;
    private StepHandler handler;
    protected SwitchingFunctionsHandler switchesHandler;
    private double stepStart;
    private double stepSize;

    protected RungeKuttaIntegrator(boolean fsal, double[] c, double[][] a, double[] b, RungeKuttaStepInterpolator prototype, double step) {
        this.fsal = fsal;
        this.c = c;
        this.a = a;
        this.b = b;
        this.prototype = prototype;
        this.step = step;
        this.handler = DummyStepHandler.getInstance();
        this.switchesHandler = new SwitchingFunctionsHandler();
        this.resetInternalState();
    }

    @Override
    public abstract String getName();

    @Override
    public void setStepHandler(StepHandler handler) {
        this.handler = handler;
    }

    @Override
    public StepHandler getStepHandler() {
        return this.handler;
    }

    @Override
    public void addSwitchingFunction(SwitchingFunction function, double maxCheckInterval, double convergence) {
        this.switchesHandler.add(function, maxCheckInterval, convergence);
    }

    @Override
    public void integrate(FirstOrderDifferentialEquations equations, double t0, double[] y0, double t, double[] y) throws DerivativeException, IntegratorException {
        AbstractStepInterpolator interpolator;
        if (equations.getDimension() != y0.length) {
            throw new IntegratorException("dimensions mismatch: ODE problem has dimension {0}, state vector has dimension {1}", new String[]{Integer.toString(equations.getDimension()), Integer.toString(y0.length)});
        }
        if (Math.abs(t - t0) <= 1.0E-12 * Math.max(Math.abs(t0), Math.abs(t))) {
            throw new IntegratorException("too small integration interval: length = {0}", new String[]{Double.toString(Math.abs(t - t0))});
        }
        boolean forward = t > t0;
        int stages = this.c.length + 1;
        if (y != y0) {
            System.arraycopy(y0, 0, y, 0, y0.length);
        }
        double[][] yDotK = new double[stages][];
        for (int i = 0; i < stages; ++i) {
            yDotK[i] = new double[y0.length];
        }
        double[] yTmp = new double[y0.length];
        if (this.handler.requiresDenseOutput() || !this.switchesHandler.isEmpty()) {
            RungeKuttaStepInterpolator rki = (RungeKuttaStepInterpolator)this.prototype.clone();
            rki.reinitialize(equations, yTmp, yDotK, forward);
            interpolator = rki;
        } else {
            interpolator = new DummyStepInterpolator(yTmp, forward);
        }
        interpolator.storeTime(t0);
        long nbStep = Math.max(1L, Math.abs(Math.round((t - t0) / this.step)));
        boolean firstTime = true;
        boolean lastStep = false;
        this.stepStart = t0;
        this.stepSize = (t - t0) / (double)nbStep;
        this.handler.reset();
        long i = 0L;
        while (!lastStep) {
            interpolator.shift();
            boolean needUpdate = false;
            boolean loop = true;
            while (loop) {
                if (firstTime || !this.fsal) {
                    equations.computeDerivatives(this.stepStart, y, yDotK[0]);
                    firstTime = false;
                }
                for (int k = 1; k < stages; ++k) {
                    for (int j = 0; j < y0.length; ++j) {
                        double sum = this.a[k - 1][0] * yDotK[0][j];
                        for (int l = 1; l < k; ++l) {
                            sum += this.a[k - 1][l] * yDotK[l][j];
                        }
                        yTmp[j] = y[j] + this.stepSize * sum;
                    }
                    equations.computeDerivatives(this.stepStart + this.c[k - 1] * this.stepSize, yTmp, yDotK[k]);
                }
                for (int j = 0; j < y0.length; ++j) {
                    double sum = this.b[0] * yDotK[0][j];
                    for (int l = 1; l < stages; ++l) {
                        sum += this.b[l] * yDotK[l][j];
                    }
                    yTmp[j] = y[j] + this.stepSize * sum;
                }
                interpolator.storeTime(this.stepStart + this.stepSize);
                if (this.switchesHandler.evaluateStep(interpolator)) {
                    needUpdate = true;
                    this.stepSize = this.switchesHandler.getEventTime() - this.stepStart;
                    continue;
                }
                loop = false;
            }
            this.stepStart += this.stepSize;
            System.arraycopy(yTmp, 0, y, 0, y0.length);
            this.switchesHandler.stepAccepted(this.stepStart, y);
            lastStep = this.switchesHandler.stop() ? true : i == nbStep - 1L;
            interpolator.storeTime(this.stepStart);
            this.handler.handleStep(interpolator, lastStep);
            if (this.fsal) {
                System.arraycopy(yDotK[stages - 1], 0, yDotK[0], 0, y0.length);
            }
            if (this.switchesHandler.reset(this.stepStart, y) && !lastStep) {
                equations.computeDerivatives(this.stepStart, y, yDotK[0]);
            }
            if (needUpdate) {
                nbStep = Math.max(1L, Math.abs(Math.round((t - this.stepStart) / this.step)));
                this.stepSize = (t - this.stepStart) / (double)nbStep;
                i = -1L;
            }
            ++i;
        }
        this.resetInternalState();
    }

    @Override
    public double getCurrentStepStart() {
        return this.stepStart;
    }

    @Override
    public double getCurrentStepsize() {
        return this.stepSize;
    }

    private void resetInternalState() {
        this.stepStart = Double.NaN;
        this.stepSize = Double.NaN;
    }
}

