/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.animal_sniffer;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.nio.CharBuffer;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import org.codehaus.mojo.animal_sniffer.ClassFileVisitor;
import org.codehaus.mojo.animal_sniffer.Clazz;
import org.codehaus.mojo.animal_sniffer.RegexUtils;
import org.codehaus.mojo.animal_sniffer.logging.Logger;
import org.codehaus.mojo.animal_sniffer.logging.PrintWriterLogger;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;

public class SignatureChecker
extends ClassFileVisitor {
    public static final String ANNOTATION_FQN = "org.codehaus.mojo.animal_sniffer.IgnoreJRERequirement";
    public static final String PREVIOUS_ANNOTATION_FQN = "org.jvnet.animal_sniffer.IgnoreJRERequirement";
    private final Map<String, Clazz> classes = new HashMap<String, Clazz>();
    private final Logger logger;
    private final List<MatchRule> ignoredPackageRules;
    private final Set<String> ignoredPackages;
    private final Set<String> ignoredOuterClassesOrMethods = new HashSet<String>();
    private boolean hadError = false;
    private List<File> sourcePath;
    private Collection<String> annotationDescriptors;

    public static void main(String[] stringArray) throws Exception {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("org.jvnet.animal_sniffer.*");
        hashSet.add("org.codehaus.mojo.animal_sniffer.*");
        hashSet.add("org.objectweb.*");
        new SignatureChecker(new FileInputStream("signature"), hashSet, new PrintWriterLogger(System.out)).process(new File("target/classes"));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SignatureChecker(InputStream inputStream, Set<String> set, Logger logger) throws IOException {
        this.ignoredPackages = new HashSet<String>();
        this.ignoredPackageRules = new LinkedList<MatchRule>();
        for (String object2 : set) {
            if (object2.indexOf(42) == -1 && object2.indexOf(63) == -1) {
                this.ignoredPackages.add(object2.replace('.', '/'));
                continue;
            }
            this.ignoredPackageRules.add(this.newMatchRule(object2.replace('.', '/')));
        }
        this.annotationDescriptors = new HashSet<String>();
        this.annotationDescriptors.add(SignatureChecker.toAnnotationDescriptor(ANNOTATION_FQN));
        this.annotationDescriptors.add(SignatureChecker.toAnnotationDescriptor(PREVIOUS_ANNOTATION_FQN));
        this.logger = logger;
        Object object = null;
        try {
            object = new ObjectInputStream(new GZIPInputStream(inputStream));
            while (true) {
                Clazz clazz;
                if ((clazz = (Clazz)((ObjectInputStream)object).readObject()) == null) {
                    return;
                }
                this.classes.put(clazz.getName(), clazz);
                continue;
                break;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        finally {
            if (object != null) {
                try {
                    ((ObjectInputStream)object).close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void setSourcePath(List<File> list) {
        this.sourcePath = list;
    }

    public void setAnnotationTypes(Collection<String> collection) {
        this.annotationDescriptors.clear();
        for (String string : collection) {
            this.annotationDescriptors.add(SignatureChecker.toAnnotationDescriptor(string));
        }
    }

    @Override
    protected void process(String string, InputStream inputStream) throws IOException {
        ClassReader classReader = new ClassReader(inputStream);
        try {
            classReader.accept((ClassVisitor)new CheckingVisitor(string), 0);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            this.logger.error("Bad class file " + string);
            IOException iOException = new IOException("Bad class file " + string);
            iOException.initCause(arrayIndexOutOfBoundsException);
            throw iOException;
        }
    }

    private MatchRule newMatchRule(String string) {
        int n = string.indexOf(42);
        if (n == -1) {
            return new ExactMatchRule(string);
        }
        if (n == string.length() - 1) {
            return new PrefixMatchRule(string.substring(0, n));
        }
        return new RegexMatchRule(RegexUtils.compileWildcard(string));
    }

    public boolean isSignatureBroken() {
        return this.hadError;
    }

    static String toSourceForm(String string, String string2) {
        int n;
        String string3 = SignatureChecker.toSourceType(string);
        if (string2 == null) {
            return string3;
        }
        int n2 = string2.indexOf(35);
        if (n2 != -1) {
            return SignatureChecker.toSourceType(CharBuffer.wrap(string2, n2 + 1, string2.length())) + " " + string3 + "." + string2.substring(0, n2);
        }
        int n3 = string2.indexOf(40);
        if (n3 != -1 && (n = string2.indexOf(41)) != -1) {
            StringBuilder stringBuilder = new StringBuilder();
            String string4 = string2.substring(n + 1);
            if (string4.equals("V")) {
                stringBuilder.append("void");
            } else {
                stringBuilder.append(SignatureChecker.toSourceType(CharBuffer.wrap(string4)));
            }
            stringBuilder.append(' ');
            stringBuilder.append(string3);
            stringBuilder.append('.');
            stringBuilder.append(string2.substring(0, n3));
            stringBuilder.append('(');
            boolean bl = true;
            CharBuffer charBuffer = CharBuffer.wrap(string2, n3 + 1, n);
            while (charBuffer.hasRemaining()) {
                if (bl) {
                    bl = false;
                } else {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(SignatureChecker.toSourceType(charBuffer));
            }
            stringBuilder.append(')');
            return stringBuilder.toString();
        }
        return "{" + string + ":" + string2 + "}";
    }

    static String toAnnotationDescriptor(String string) {
        return "L" + SignatureChecker.fromSourceType(string) + ";";
    }

    private static String toSourceType(CharBuffer charBuffer) {
        switch (charBuffer.get()) {
            case 'L': {
                for (int i = charBuffer.position(); i < charBuffer.limit(); ++i) {
                    if (charBuffer.get(i) != ';') continue;
                    String string = charBuffer.subSequence(0, i - charBuffer.position()).toString();
                    charBuffer.position(i + 1);
                    return SignatureChecker.toSourceType(string);
                }
                return "{" + charBuffer + "}";
            }
            case '[': {
                return SignatureChecker.toSourceType(charBuffer) + "[]";
            }
            case 'B': {
                return "byte";
            }
            case 'C': {
                return "char";
            }
            case 'D': {
                return "double";
            }
            case 'F': {
                return "float";
            }
            case 'I': {
                return "int";
            }
            case 'J': {
                return "long";
            }
            case 'S': {
                return "short";
            }
            case 'Z': {
                return "boolean";
            }
        }
        return "{" + charBuffer + "}";
    }

    private static String toSourceType(String string) {
        return string.replaceFirst("^java/lang/([^/]+)$", "$1").replace('/', '.').replace('$', '.');
    }

    private static String fromSourceType(String string) {
        return string.replace('.', '/').replace('.', '$');
    }

    private class CheckingVisitor
    extends ClassVisitor {
        private final Set<String> ignoredPackageCache;
        private String packagePrefix;
        private int line;
        private String name;
        private String internalName;
        private boolean ignoreClass;

        public CheckingVisitor(String string) {
            super(327680);
            this.ignoreClass = false;
            this.ignoredPackageCache = new HashSet<String>(50 * SignatureChecker.this.ignoredPackageRules.size());
            this.name = string;
        }

        public void visit(int n, int n2, String string, String string2, String string3, String[] stringArray) {
            this.internalName = string;
            this.packagePrefix = string.substring(0, string.lastIndexOf(47) + 1);
        }

        public void visitSource(String string, String string2) {
            for (File file : SignatureChecker.this.sourcePath) {
                File file2 = new File(file, this.packagePrefix + string);
                if (!file2.isFile()) continue;
                this.name = file2.getAbsolutePath();
            }
        }

        public void visitOuterClass(String string, String string2, String string3) {
            if (SignatureChecker.this.ignoredOuterClassesOrMethods.contains(string) || string2 != null && SignatureChecker.this.ignoredOuterClassesOrMethods.contains(string + "#" + string2 + string3)) {
                this.ignoreClass = true;
            }
        }

        public boolean isIgnoreAnnotation(String string) {
            for (String string2 : SignatureChecker.this.annotationDescriptors) {
                if (!string.equals(string2)) continue;
                return true;
            }
            return false;
        }

        public AnnotationVisitor visitAnnotation(String string, boolean bl) {
            if (this.isIgnoreAnnotation(string)) {
                this.ignoreClass = true;
                SignatureChecker.this.ignoredOuterClassesOrMethods.add(this.internalName);
            }
            return super.visitAnnotation(string, bl);
        }

        public MethodVisitor visitMethod(int n, final String string, final String string2, String string3, String[] stringArray) {
            return new MethodVisitor(327680){
                boolean ignoreError;
                {
                    super(n);
                    this.ignoreError = CheckingVisitor.this.ignoreClass;
                }

                public AnnotationVisitor visitAnnotation(String string3, boolean bl) {
                    if (CheckingVisitor.this.isIgnoreAnnotation(string3)) {
                        this.ignoreError = true;
                        SignatureChecker.this.ignoredOuterClassesOrMethods.add(CheckingVisitor.this.internalName + "#" + string + string2);
                    }
                    return super.visitAnnotation(string3, bl);
                }

                public void visitMethodInsn(int n, String string4, String string22, String string3, boolean bl) {
                    this.check(string4, string22 + string3);
                }

                public void visitTypeInsn(int n, String string3) {
                    if (this.shouldBeIgnored(string3)) {
                        return;
                    }
                    if (string3.charAt(0) == '[') {
                        return;
                    }
                    Clazz clazz = (Clazz)SignatureChecker.this.classes.get(string3);
                    if (clazz == null) {
                        CheckingVisitor.this.error(string3, null);
                    }
                }

                public void visitFieldInsn(int n, String string4, String string22, String string3) {
                    this.check(string4, string22 + '#' + string3);
                }

                public void visitLineNumber(int n, Label label) {
                    CheckingVisitor.this.line = n;
                }

                private void check(String string3, String string22) {
                    if (this.shouldBeIgnored(string3)) {
                        return;
                    }
                    if (CheckingVisitor.this.find((Clazz)SignatureChecker.this.classes.get(string3), string22, true)) {
                        return;
                    }
                    CheckingVisitor.this.error(string3, string22);
                }

                private boolean shouldBeIgnored(String string3) {
                    if (this.ignoreError) {
                        return true;
                    }
                    if (string3.charAt(0) == '[') {
                        return true;
                    }
                    if (SignatureChecker.this.ignoredPackages.contains(string3) || CheckingVisitor.this.ignoredPackageCache.contains(string3)) {
                        return true;
                    }
                    for (MatchRule matchRule : SignatureChecker.this.ignoredPackageRules) {
                        if (!matchRule.matches(string3)) continue;
                        CheckingVisitor.this.ignoredPackageCache.add(string3);
                        return true;
                    }
                    return false;
                }
            };
        }

        private boolean find(Clazz clazz, String string, boolean bl) {
            Pattern pattern;
            Matcher matcher;
            if (clazz == null) {
                return false;
            }
            if (clazz.getSignatures().contains(string)) {
                return true;
            }
            if (string.startsWith("<")) {
                return false;
            }
            if (this.find((Clazz)SignatureChecker.this.classes.get(clazz.getSuperClass()), string, false)) {
                return true;
            }
            if (clazz.getSuperInterfaces() != null) {
                for (int i = 0; i < clazz.getSuperInterfaces().length; ++i) {
                    if (!this.find((Clazz)SignatureChecker.this.classes.get(clazz.getSuperInterfaces()[i]), string, false)) continue;
                    return true;
                }
            }
            if (bl && (matcher = (pattern = Pattern.compile("(.+\\))L(.+);")).matcher(string)).matches()) {
                String string2;
                String string3 = matcher.group(1);
                String string4 = matcher.group(2);
                Clazz clazz2 = (Clazz)SignatureChecker.this.classes.get(string4);
                if (clazz2 != null && clazz2.getSuperClass() != null && this.find(clazz, string2 = string3 + 'L' + clazz2.getSuperClass() + ';', false)) {
                    SignatureChecker.this.logger.info(this.name + (this.line > 0 ? ":" + this.line : "") + ": Covariant return type change detected: " + SignatureChecker.toSourceForm(clazz.getName(), string2) + " has been changed to " + SignatureChecker.toSourceForm(clazz.getName(), string));
                    return true;
                }
            }
            return false;
        }

        private void error(String string, String string2) {
            SignatureChecker.this.hadError = true;
            SignatureChecker.this.logger.error(this.name + (this.line > 0 ? ":" + this.line : "") + ": Undefined reference: " + SignatureChecker.toSourceForm(string, string2));
        }
    }

    private static class RegexMatchRule
    implements MatchRule {
        private final Pattern regex;

        public RegexMatchRule(Pattern pattern) {
            this.regex = pattern;
        }

        @Override
        public boolean matches(String string) {
            return this.regex.matcher(string).matches();
        }
    }

    private static class ExactMatchRule
    implements MatchRule {
        private final String match;

        public ExactMatchRule(String string) {
            this.match = string;
        }

        @Override
        public boolean matches(String string) {
            return this.match.equals(string);
        }
    }

    private static class PrefixMatchRule
    implements MatchRule {
        private final String prefix;

        public PrefixMatchRule(String string) {
            this.prefix = string;
        }

        @Override
        public boolean matches(String string) {
            return string.startsWith(this.prefix);
        }
    }

    private static interface MatchRule {
        public boolean matches(String var1);
    }
}

