/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.framework.parameters;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.parameters.ParameterException;

public class Parameters
implements Serializable {
    public static final Parameters EMPTY_PARAMETERS = new Parameters();
    private Map m_parameters = new HashMap();
    private boolean m_readOnly;

    public String setParameter(String string, String string2) throws IllegalStateException {
        this.checkWriteable();
        if (null == string) {
            return null;
        }
        if (null == string2) {
            return (String)this.m_parameters.remove(string);
        }
        return this.m_parameters.put(string, string2);
    }

    public void removeParameter(String string) {
        this.setParameter(string, null);
    }

    public Iterator getParameterNames() {
        return this.m_parameters.keySet().iterator();
    }

    public String[] getNames() {
        return this.m_parameters.keySet().toArray(new String[0]);
    }

    public boolean isParameter(String string) {
        return this.m_parameters.containsKey(string);
    }

    public String getParameter(String string) throws ParameterException {
        if (null == string) {
            throw new ParameterException("You cannot lookup a null parameter");
        }
        String string2 = (String)this.m_parameters.get(string);
        if (null == string2) {
            throw new ParameterException("The parameter '" + string + "' does not contain a value");
        }
        return string2;
    }

    public String getParameter(String string, String string2) {
        if (string == null) {
            return string2;
        }
        String string3 = (String)this.m_parameters.get(string);
        if (string3 == null) {
            return string2;
        }
        return string3;
    }

    private int parseInt(String string) throws NumberFormatException {
        if (string.startsWith("0x")) {
            return Integer.parseInt(string.substring(2), 16);
        }
        if (string.startsWith("0o")) {
            return Integer.parseInt(string.substring(2), 8);
        }
        if (string.startsWith("0b")) {
            return Integer.parseInt(string.substring(2), 2);
        }
        return Integer.parseInt(string);
    }

    public int getParameterAsInteger(String string) throws ParameterException {
        try {
            return this.parseInt(this.getParameter(string));
        }
        catch (NumberFormatException numberFormatException) {
            throw new ParameterException("Could not return an integer value", numberFormatException);
        }
    }

    public int getParameterAsInteger(String string, int n) {
        try {
            String string2 = this.getParameter(string, null);
            if (string2 == null) {
                return n;
            }
            return this.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            return n;
        }
    }

    private long parseLong(String string) throws NumberFormatException {
        if (string.startsWith("0x")) {
            return Long.parseLong(string.substring(2), 16);
        }
        if (string.startsWith("0o")) {
            return Long.parseLong(string.substring(2), 8);
        }
        if (string.startsWith("0b")) {
            return Long.parseLong(string.substring(2), 2);
        }
        return Long.parseLong(string);
    }

    public long getParameterAsLong(String string) throws ParameterException {
        try {
            return this.parseLong(this.getParameter(string));
        }
        catch (NumberFormatException numberFormatException) {
            throw new ParameterException("Could not return a long value", numberFormatException);
        }
    }

    public long getParameterAsLong(String string, long l) {
        try {
            String string2 = this.getParameter(string, null);
            if (string2 == null) {
                return l;
            }
            return this.parseLong(string2);
        }
        catch (NumberFormatException numberFormatException) {
            return l;
        }
    }

    public float getParameterAsFloat(String string) throws ParameterException {
        try {
            return Float.parseFloat(this.getParameter(string));
        }
        catch (NumberFormatException numberFormatException) {
            throw new ParameterException("Could not return a float value", numberFormatException);
        }
    }

    public float getParameterAsFloat(String string, float f) {
        try {
            String string2 = this.getParameter(string, null);
            if (string2 == null) {
                return f;
            }
            return Float.parseFloat(string2);
        }
        catch (NumberFormatException numberFormatException) {
            return f;
        }
    }

    public boolean getParameterAsBoolean(String string) throws ParameterException {
        String string2 = this.getParameter(string);
        if (string2.equalsIgnoreCase("true")) {
            return true;
        }
        if (string2.equalsIgnoreCase("false")) {
            return false;
        }
        throw new ParameterException("Could not return a boolean value");
    }

    public boolean getParameterAsBoolean(String string, boolean bl) {
        String string2 = this.getParameter(string, null);
        if (string2 == null) {
            return bl;
        }
        if (string2.equalsIgnoreCase("true")) {
            return true;
        }
        if (string2.equalsIgnoreCase("false")) {
            return false;
        }
        return bl;
    }

    public Parameters merge(Parameters parameters) {
        this.checkWriteable();
        String[] stringArray = parameters.getNames();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            String string2 = null;
            try {
                string2 = parameters.getParameter(string);
            }
            catch (ParameterException parameterException) {
                string2 = null;
            }
            this.setParameter(string, string2);
        }
        return this;
    }

    public void makeReadOnly() {
        this.m_readOnly = true;
    }

    protected final void checkWriteable() throws IllegalStateException {
        if (this.m_readOnly) {
            throw new IllegalStateException("Context is read only and can not be modified");
        }
    }

    public static Parameters fromConfiguration(Configuration configuration) throws ConfigurationException {
        return Parameters.fromConfiguration(configuration, "parameter");
    }

    public static Parameters fromConfiguration(Configuration configuration, String string) throws ConfigurationException {
        if (null == configuration) {
            throw new ConfigurationException("You cannot convert to parameters with a null Configuration");
        }
        Configuration[] configurationArray = configuration.getChildren(string);
        Parameters parameters = new Parameters();
        for (int i = 0; i < configurationArray.length; ++i) {
            try {
                String string2 = configurationArray[i].getAttribute("name");
                String string3 = configurationArray[i].getAttribute("value");
                parameters.setParameter(string2, string3);
                continue;
            }
            catch (Exception exception) {
                throw new ConfigurationException("Cannot process Configurable", exception);
            }
        }
        return parameters;
    }

    public static Parameters fromProperties(Properties properties) {
        Parameters parameters = new Parameters();
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement().toString();
            String string2 = properties.getProperty(string);
            parameters.setParameter(string, string2);
        }
        return parameters;
    }

    public static Properties toProperties(Parameters parameters) {
        Properties properties = new Properties();
        String[] stringArray = parameters.getNames();
        for (int i = 0; i < stringArray.length; ++i) {
            properties.setProperty(stringArray[i], parameters.getParameter(stringArray[i], ""));
        }
        return properties;
    }

    static {
        EMPTY_PARAMETERS.makeReadOnly();
    }
}

