/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.exec.util;

public class DebugUtils {
    public static final String COMMONS_EXEC_LENIENT = "org.apache.commons.exec.lenient";
    public static final String COMMONS_EXEC_DEBUG = "org.apache.commons.exec.debug";

    public static void handleException(String string, Exception exception) {
        if (DebugUtils.isDebugEnabled()) {
            System.err.println(string);
            exception.printStackTrace();
        }
        if (!DebugUtils.isLenientEnabled()) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new RuntimeException(exception.getMessage());
        }
    }

    public static boolean isDebugEnabled() {
        String string = System.getProperty(COMMONS_EXEC_DEBUG, Boolean.FALSE.toString());
        return Boolean.TRUE.toString().equalsIgnoreCase(string);
    }

    public static boolean isLenientEnabled() {
        String string = System.getProperty(COMMONS_EXEC_LENIENT, Boolean.TRUE.toString());
        return Boolean.TRUE.toString().equalsIgnoreCase(string);
    }
}

