/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.net.imap;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.net.SocketClient;
import org.apache.commons.net.imap.IMAPCommand;
import org.apache.commons.net.imap.IMAPReply;
import org.apache.commons.net.io.CRLFLineReader;

public class IMAP
extends SocketClient {
    public static final int DEFAULT_PORT = 143;
    protected static final String __DEFAULT_ENCODING = "ISO-8859-1";
    private IMAPState __state;
    protected BufferedWriter __writer;
    protected BufferedReader _reader;
    private int _replyCode;
    private final List<String> _replyLines;
    public static final IMAPChunkListener TRUE_CHUNK_LISTENER = new IMAPChunkListener(){

        @Override
        public boolean chunkReceived(IMAP iMAP) {
            return true;
        }
    };
    private volatile IMAPChunkListener __chunkListener;
    private final char[] _initialID = new char[]{'A', 'A', 'A', 'A'};

    public IMAP() {
        this.setDefaultPort(143);
        this.__state = IMAPState.DISCONNECTED_STATE;
        this._reader = null;
        this.__writer = null;
        this._replyLines = new ArrayList<String>();
        this.createCommandSupport();
    }

    private void __getReply() throws IOException {
        this.__getReply(true);
    }

    private void __getReply(boolean bl) throws IOException {
        this._replyLines.clear();
        String string = this._reader.readLine();
        if (string == null) {
            throw new EOFException("Connection closed without indication.");
        }
        this._replyLines.add(string);
        if (bl) {
            while (IMAPReply.isUntagged(string)) {
                boolean bl2;
                IMAPChunkListener iMAPChunkListener;
                boolean bl3;
                int n = IMAPReply.literalCount(string);
                boolean bl4 = bl3 = n >= 0;
                while (n >= 0) {
                    string = this._reader.readLine();
                    if (string == null) {
                        throw new EOFException("Connection closed without indication.");
                    }
                    this._replyLines.add(string);
                    n -= string.length() + 2;
                }
                if (bl3 && (iMAPChunkListener = this.__chunkListener) != null && (bl2 = iMAPChunkListener.chunkReceived(this))) {
                    this.fireReplyReceived(3, this.getReplyString());
                    this._replyLines.clear();
                }
                if ((string = this._reader.readLine()) == null) {
                    throw new EOFException("Connection closed without indication.");
                }
                this._replyLines.add(string);
            }
            this._replyCode = IMAPReply.getReplyCode(string);
        } else {
            this._replyCode = IMAPReply.getUntaggedReplyCode(string);
        }
        this.fireReplyReceived(this._replyCode, this.getReplyString());
    }

    @Override
    protected void fireReplyReceived(int n, String string) {
        if (this.getCommandSupport().getListenerCount() > 0) {
            this.getCommandSupport().fireReplyReceived(n, this.getReplyString());
        }
    }

    @Override
    protected void _connectAction_() throws IOException {
        super._connectAction_();
        this._reader = new CRLFLineReader(new InputStreamReader(this._input_, __DEFAULT_ENCODING));
        this.__writer = new BufferedWriter(new OutputStreamWriter(this._output_, __DEFAULT_ENCODING));
        int n = this.getSoTimeout();
        if (n <= 0) {
            this.setSoTimeout(this.connectTimeout);
        }
        this.__getReply(false);
        if (n <= 0) {
            this.setSoTimeout(n);
        }
        this.setState(IMAPState.NOT_AUTH_STATE);
    }

    protected void setState(IMAPState iMAPState) {
        this.__state = iMAPState;
    }

    public IMAPState getState() {
        return this.__state;
    }

    @Override
    public void disconnect() throws IOException {
        super.disconnect();
        this._reader = null;
        this.__writer = null;
        this._replyLines.clear();
        this.setState(IMAPState.DISCONNECTED_STATE);
    }

    private int sendCommandWithID(String string, String string2, String string3) throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        if (string != null) {
            stringBuilder.append(string);
            stringBuilder.append(' ');
        }
        stringBuilder.append(string2);
        if (string3 != null) {
            stringBuilder.append(' ');
            stringBuilder.append(string3);
        }
        stringBuilder.append("\r\n");
        String string4 = stringBuilder.toString();
        this.__writer.write(string4);
        this.__writer.flush();
        this.fireCommandSent(string2, string4);
        this.__getReply();
        return this._replyCode;
    }

    public int sendCommand(String string, String string2) throws IOException {
        return this.sendCommandWithID(this.generateCommandID(), string, string2);
    }

    public int sendCommand(String string) throws IOException {
        return this.sendCommand(string, null);
    }

    public int sendCommand(IMAPCommand iMAPCommand, String string) throws IOException {
        return this.sendCommand(iMAPCommand.getIMAPCommand(), string);
    }

    public boolean doCommand(IMAPCommand iMAPCommand, String string) throws IOException {
        return IMAPReply.isSuccess(this.sendCommand(iMAPCommand, string));
    }

    public int sendCommand(IMAPCommand iMAPCommand) throws IOException {
        return this.sendCommand(iMAPCommand, null);
    }

    public boolean doCommand(IMAPCommand iMAPCommand) throws IOException {
        return IMAPReply.isSuccess(this.sendCommand(iMAPCommand));
    }

    public int sendData(String string) throws IOException {
        return this.sendCommandWithID(null, string, null);
    }

    public String[] getReplyStrings() {
        return this._replyLines.toArray(new String[this._replyLines.size()]);
    }

    public String getReplyString() {
        StringBuilder stringBuilder = new StringBuilder(256);
        for (String string : this._replyLines) {
            stringBuilder.append(string);
            stringBuilder.append("\r\n");
        }
        return stringBuilder.toString();
    }

    public void setChunkListener(IMAPChunkListener iMAPChunkListener) {
        this.__chunkListener = iMAPChunkListener;
    }

    protected String generateCommandID() {
        String string = new String(this._initialID);
        boolean bl = true;
        for (int i = this._initialID.length - 1; bl && i >= 0; --i) {
            if (this._initialID[i] == 'Z') {
                this._initialID[i] = 65;
                continue;
            }
            int n = i;
            this._initialID[n] = (char)(this._initialID[n] + '\u0001');
            bl = false;
        }
        return string;
    }

    public static interface IMAPChunkListener {
        public boolean chunkReceived(IMAP var1);
    }

    public static enum IMAPState {
        DISCONNECTED_STATE,
        NOT_AUTH_STATE,
        AUTH_STATE,
        LOGOUT_STATE;

    }
}

