/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.specs.jpa;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javax.persistence.spi.PersistenceProvider;
import javax.persistence.spi.PersistenceProviderResolver;
import javax.persistence.spi.PersistenceProviderResolverHolder;
import org.apache.geronimo.osgi.locator.Activator;
import org.apache.geronimo.specs.jpa.PersistenceTracker;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class PersistenceActivator
extends Activator
implements BundleActivator,
PersistenceProviderResolver {
    public static final String PERSISTENCE_PROVIDER = PersistenceProvider.class.getName();
    private Map<String, PersistenceProvider> providers = new WeakHashMap<String, PersistenceProvider>();
    private BundleContext ctx = null;
    private ServiceTracker tracker = null;

    public void start(BundleContext bundleContext) throws Exception {
        super.start(bundleContext);
        this.ctx = bundleContext;
        PersistenceTracker persistenceTracker = new PersistenceTracker(this);
        this.tracker = new ServiceTracker(this.ctx, PERSISTENCE_PROVIDER, (ServiceTrackerCustomizer)persistenceTracker);
        this.tracker.open();
        PersistenceProviderResolverHolder.setPersistenceProviderResolver(this);
    }

    public void stop(BundleContext bundleContext) throws Exception {
        this.tracker.close();
        this.tracker = null;
        PersistenceProviderResolverHolder.setPersistenceProviderResolver(null);
        this.providers.clear();
        this.ctx = null;
        super.stop(bundleContext);
    }

    @Override
    public void clearCachedProviders() {
    }

    @Override
    public List<PersistenceProvider> getPersistenceProviders() {
        return new ArrayList<PersistenceProvider>(this.providers.values());
    }

    protected PersistenceProvider addProvider(ServiceReference serviceReference) {
        PersistenceProvider persistenceProvider = (PersistenceProvider)this.ctx.getService(serviceReference);
        String string = (String)serviceReference.getProperty(PERSISTENCE_PROVIDER);
        this.providers.put(string, persistenceProvider);
        return persistenceProvider;
    }

    protected void removeProvider(ServiceReference serviceReference) {
        String string = (String)serviceReference.getProperty(PERSISTENCE_PROVIDER);
        this.providers.remove(string);
    }
}

