/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rsyntaxtextarea;

import javax.swing.Action;
import javax.swing.text.Segment;
import org.fife.ui.rsyntaxtextarea.DefaultOccurrenceMarker;
import org.fife.ui.rsyntaxtextarea.DefaultTokenFactory;
import org.fife.ui.rsyntaxtextarea.OccurrenceMarker;
import org.fife.ui.rsyntaxtextarea.Token;
import org.fife.ui.rsyntaxtextarea.TokenFactory;
import org.fife.ui.rsyntaxtextarea.TokenImpl;
import org.fife.ui.rsyntaxtextarea.TokenMaker;

public abstract class TokenMakerBase
implements TokenMaker {
    protected TokenImpl firstToken = null;
    protected TokenImpl currentToken = null;
    protected TokenImpl previousToken = null;
    private TokenFactory tokenFactory = new DefaultTokenFactory();
    private OccurrenceMarker occurrenceMarker;
    private int languageIndex;

    @Override
    public void addNullToken() {
        if (this.firstToken == null) {
            this.currentToken = this.firstToken = this.tokenFactory.createToken();
        } else {
            TokenImpl tokenImpl = this.tokenFactory.createToken();
            this.currentToken.setNextToken(tokenImpl);
            this.previousToken = this.currentToken;
            this.currentToken = tokenImpl;
        }
        this.currentToken.setLanguageIndex(this.languageIndex);
    }

    public void addToken(Segment segment, int n, int n2, int n3, int n4) {
        this.addToken(segment.array, n, n2, n3, n4);
    }

    @Override
    public void addToken(char[] cArray, int n, int n2, int n3, int n4) {
        this.addToken(cArray, n, n2, n3, n4, false);
    }

    public void addToken(char[] cArray, int n, int n2, int n3, int n4, boolean bl) {
        if (this.firstToken == null) {
            this.currentToken = this.firstToken = this.tokenFactory.createToken(cArray, n, n2, n4, n3);
        } else {
            TokenImpl tokenImpl = this.tokenFactory.createToken(cArray, n, n2, n4, n3);
            this.currentToken.setNextToken(tokenImpl);
            this.previousToken = this.currentToken;
            this.currentToken = tokenImpl;
        }
        this.currentToken.setLanguageIndex(this.languageIndex);
        this.currentToken.setHyperlink(bl);
    }

    protected OccurrenceMarker createOccurrenceMarker() {
        return new DefaultOccurrenceMarker();
    }

    @Override
    public int getClosestStandardTokenTypeForInternalType(int n) {
        return n;
    }

    @Override
    public boolean getCurlyBracesDenoteCodeBlocks(int n) {
        return false;
    }

    @Override
    public Action getInsertBreakAction() {
        return null;
    }

    protected int getLanguageIndex() {
        return this.languageIndex;
    }

    @Override
    public int getLastTokenTypeOnLine(Segment segment, int n) {
        Token token = this.getTokenList(segment, n, 0);
        while (token.getNextToken() != null) {
            token = token.getNextToken();
        }
        return token.getType();
    }

    @Override
    public String[] getLineCommentStartAndEnd(int n) {
        return null;
    }

    @Override
    public boolean getMarkOccurrencesOfTokenType(int n) {
        return n == 20;
    }

    @Override
    public OccurrenceMarker getOccurrenceMarker() {
        if (this.occurrenceMarker == null) {
            this.occurrenceMarker = this.createOccurrenceMarker();
        }
        return this.occurrenceMarker;
    }

    @Override
    public boolean getShouldIndentNextLineAfter(Token token) {
        return false;
    }

    @Override
    public boolean isIdentifierChar(int n, char c) {
        return Character.isLetterOrDigit(c) || c == '_' || c == '$';
    }

    @Override
    public boolean isMarkupLanguage() {
        return false;
    }

    protected void resetTokenList() {
        this.previousToken = null;
        this.currentToken = null;
        this.firstToken = null;
        this.tokenFactory.resetAllTokens();
    }

    protected void setLanguageIndex(int n) {
        this.languageIndex = Math.max(0, n);
    }
}

