/*
 * Decompiled with CFR 0.152.
 */
package com.github.zafarkhaja.semver.expr;

import com.github.zafarkhaja.semver.Version;
import com.github.zafarkhaja.semver.expr.And;
import com.github.zafarkhaja.semver.expr.Equal;
import com.github.zafarkhaja.semver.expr.Expression;
import com.github.zafarkhaja.semver.expr.Greater;
import com.github.zafarkhaja.semver.expr.GreaterOrEqual;
import com.github.zafarkhaja.semver.expr.Less;
import com.github.zafarkhaja.semver.expr.LessOrEqual;
import com.github.zafarkhaja.semver.expr.Not;
import com.github.zafarkhaja.semver.expr.NotEqual;
import com.github.zafarkhaja.semver.expr.Or;

public class CompositeExpression
implements Expression {
    private Expression exprTree;

    public CompositeExpression(Expression expression) {
        this.exprTree = expression;
    }

    public CompositeExpression and(Expression expression) {
        this.exprTree = new And(this.exprTree, expression);
        return this;
    }

    public CompositeExpression or(Expression expression) {
        this.exprTree = new Or(this.exprTree, expression);
        return this;
    }

    public boolean interpret(String string) {
        return this.interpret(Version.valueOf(string));
    }

    @Override
    public boolean interpret(Version version) {
        return this.exprTree.interpret(version);
    }

    public static class Helper {
        public static CompositeExpression not(Expression expression) {
            return new CompositeExpression(new Not(expression));
        }

        public static CompositeExpression eq(Version version) {
            return new CompositeExpression(new Equal(version));
        }

        public static CompositeExpression eq(String string) {
            return Helper.eq(Version.valueOf(string));
        }

        public static CompositeExpression neq(Version version) {
            return new CompositeExpression(new NotEqual(version));
        }

        public static CompositeExpression neq(String string) {
            return Helper.neq(Version.valueOf(string));
        }

        public static CompositeExpression gt(Version version) {
            return new CompositeExpression(new Greater(version));
        }

        public static CompositeExpression gt(String string) {
            return Helper.gt(Version.valueOf(string));
        }

        public static CompositeExpression gte(Version version) {
            return new CompositeExpression(new GreaterOrEqual(version));
        }

        public static CompositeExpression gte(String string) {
            return Helper.gte(Version.valueOf(string));
        }

        public static CompositeExpression lt(Version version) {
            return new CompositeExpression(new Less(version));
        }

        public static CompositeExpression lt(String string) {
            return Helper.lt(Version.valueOf(string));
        }

        public static CompositeExpression lte(Version version) {
            return new CompositeExpression(new LessOrEqual(version));
        }

        public static CompositeExpression lte(String string) {
            return Helper.lte(Version.valueOf(string));
        }
    }
}

