/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlgraphics.image.codec.tiff;

import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBufferByte;
import java.awt.image.IndexColorModel;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.zip.Deflater;
import org.apache.xmlgraphics.image.codec.tiff.CompressionValue;
import org.apache.xmlgraphics.image.codec.tiff.ImageInfo;
import org.apache.xmlgraphics.image.codec.tiff.ImageType;
import org.apache.xmlgraphics.image.codec.tiff.TIFFEncodeParam;
import org.apache.xmlgraphics.image.codec.tiff.TIFFField;
import org.apache.xmlgraphics.image.codec.util.ImageEncodeParam;
import org.apache.xmlgraphics.image.codec.util.ImageEncoderImpl;
import org.apache.xmlgraphics.image.codec.util.PropertyUtil;
import org.apache.xmlgraphics.image.codec.util.SeekableOutputStream;

public class TIFFImageEncoder
extends ImageEncoderImpl {
    private static final int TIFF_JPEG_TABLES = 347;
    private static final int TIFF_YCBCR_SUBSAMPLING = 530;
    private static final int TIFF_YCBCR_POSITIONING = 531;
    private static final int TIFF_REF_BLACK_WHITE = 532;
    private static final int[] SIZE_OF_TYPE = new int[]{0, 1, 1, 2, 4, 8, 1, 1, 2, 4, 8, 4, 8};

    public TIFFImageEncoder(OutputStream outputStream, ImageEncodeParam imageEncodeParam) {
        super(outputStream, imageEncodeParam);
        if (this.param == null) {
            this.param = new TIFFEncodeParam();
        }
    }

    @Override
    public void encode(RenderedImage renderedImage) throws IOException {
        this.writeFileHeader();
        TIFFEncodeParam tIFFEncodeParam = (TIFFEncodeParam)this.param;
        Iterator iterator = tIFFEncodeParam.getExtraImages();
        if (iterator != null) {
            boolean bl;
            int n = 8;
            RenderedImage renderedImage2 = renderedImage;
            TIFFEncodeParam tIFFEncodeParam2 = tIFFEncodeParam;
            do {
                n = this.encode(renderedImage2, tIFFEncodeParam2, n, !(bl = iterator.hasNext()));
                if (!bl) continue;
                Object e = iterator.next();
                if (e instanceof RenderedImage) {
                    renderedImage2 = (RenderedImage)e;
                    tIFFEncodeParam2 = tIFFEncodeParam;
                    continue;
                }
                if (!(e instanceof Object[])) continue;
                Object[] objectArray = (Object[])e;
                renderedImage2 = (RenderedImage)objectArray[0];
                tIFFEncodeParam2 = (TIFFEncodeParam)objectArray[1];
            } while (bl);
        } else {
            this.encode(renderedImage, tIFFEncodeParam, 8, true);
        }
    }

    public Object encodeMultiple(Object object, RenderedImage renderedImage) throws IOException {
        TIFFEncodeParam tIFFEncodeParam = (TIFFEncodeParam)this.param;
        if (tIFFEncodeParam.getExtraImages() != null) {
            throw new IllegalStateException(PropertyUtil.getString("TIFFImageEncoder11"));
        }
        Context context = (Context)object;
        if (context == null) {
            context = new Context();
            this.writeFileHeader();
        } else {
            context.ifdOffset = this.encode(context.nextImage, tIFFEncodeParam, context.ifdOffset, false);
        }
        context.nextImage = renderedImage;
        return context;
    }

    public void finishMultiple(Object object) throws IOException {
        if (object == null) {
            throw new NullPointerException();
        }
        Context context = (Context)object;
        TIFFEncodeParam tIFFEncodeParam = (TIFFEncodeParam)this.param;
        context.ifdOffset = this.encode(context.nextImage, tIFFEncodeParam, context.ifdOffset, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private int encode(RenderedImage renderedImage, TIFFEncodeParam tIFFEncodeParam, int n, boolean bl) throws IOException {
        int n2;
        int bl8;
        int byteArrayOutputStream;
        int n3;
        int nArray2;
        Object object;
        char c;
        int n7;
        CompressionValue compressionValue = tIFFEncodeParam.getCompression();
        if (compressionValue == CompressionValue.JPEG_TTN2) {
            throw new IllegalArgumentException(PropertyUtil.getString("TIFFImageEncoder12"));
        }
        boolean bl2 = tIFFEncodeParam.getWriteTiled();
        int n8 = renderedImage.getMinX();
        int n9 = renderedImage.getMinY();
        int n10 = renderedImage.getWidth();
        int n11 = renderedImage.getHeight();
        SampleModel sampleModel = renderedImage.getSampleModel();
        ColorModel colorModel = renderedImage.getColorModel();
        int[] nArray = sampleModel.getSampleSize();
        int n12 = nArray[0];
        int n13 = sampleModel.getNumBands();
        int n14 = sampleModel.getDataType();
        this.validateImage(n12, nArray, n13, n14, colorModel);
        boolean bl3 = n14 == 2 || n14 == 1;
        ImageInfo imageInfo = ImageInfo.newInstance(renderedImage, n12, n13, colorModel, tIFFEncodeParam);
        if (imageInfo.getType() == ImageType.UNSUPPORTED) {
            throw new RuntimeException(PropertyUtil.getString("TIFFImageEncoder8"));
        }
        int n15 = imageInfo.getNumTiles();
        long l = imageInfo.getBytesPerTile();
        long l2 = imageInfo.getBytesPerRow();
        int n16 = imageInfo.getTileHeight();
        int n17 = imageInfo.getTileWidth();
        long[] lArray = new long[n15];
        for (int i = 0; i < n15; ++i) {
            lArray[i] = l;
        }
        if (!bl2) {
            long l3 = n11 - n16 * (n15 - 1);
            lArray[n15 - 1] = l3 * l2;
        }
        long l4 = l * (long)(n15 - 1) + lArray[n15 - 1];
        long[] lArray2 = new long[n15];
        TreeSet<TIFFField> treeSet = new TreeSet<TIFFField>();
        treeSet.add(new TIFFField(256, 4, 1, new long[]{n10}));
        treeSet.add(new TIFFField(257, 4, 1, new long[]{n11}));
        char[] cArray = new char[n13];
        for (n7 = 0; n7 < n13; ++n7) {
            cArray[n7] = (char)n12;
        }
        treeSet.add(new TIFFField(258, 3, n13, cArray));
        treeSet.add(new TIFFField(259, 3, 1, new char[]{(char)compressionValue.getValue()}));
        treeSet.add(new TIFFField(262, 3, 1, new char[]{(char)imageInfo.getType().getPhotometricInterpretation()}));
        if (!bl2) {
            treeSet.add(new TIFFField(273, 4, n15, lArray2));
        }
        treeSet.add(new TIFFField(277, 3, 1, new char[]{(char)n13}));
        if (!bl2) {
            treeSet.add(new TIFFField(278, 4, 1, new long[]{n16}));
            treeSet.add(new TIFFField(279, 4, n15, lArray));
        }
        if (imageInfo.getColormap() != null) {
            treeSet.add(new TIFFField(320, 3, imageInfo.getColormapSize(), imageInfo.getColormap()));
        }
        if (bl2) {
            treeSet.add(new TIFFField(322, 4, 1, new long[]{n17}));
            treeSet.add(new TIFFField(323, 4, 1, new long[]{n16}));
            treeSet.add(new TIFFField(324, 4, n15, lArray2));
            treeSet.add(new TIFFField(325, 4, n15, lArray));
        }
        if (imageInfo.getNumberOfExtraSamples() > 0) {
            char[] cArray2 = new char[imageInfo.getNumberOfExtraSamples()];
            for (c = '\u0000'; c < imageInfo.getNumberOfExtraSamples(); ++c) {
                cArray2[c] = (char)imageInfo.getExtraSamplesType().getValue();
            }
            treeSet.add(new TIFFField(338, 3, imageInfo.getNumberOfExtraSamples(), cArray2));
        }
        if (n14 != 0) {
            char[] cArray3 = new char[n13];
            cArray3[0] = n14 == 4 ? 3 : (n14 == 1 ? 1 : 2);
            for (c = '\u0001'; c < n13; ++c) {
                cArray3[c] = cArray3[0];
            }
            treeSet.add(new TIFFField(339, 3, n13, cArray3));
        }
        if (imageInfo.getType() == ImageType.YCBCR) {
            n7 = 1;
            c = '\u0001';
            treeSet.add(new TIFFField(530, 3, 2, new char[]{n7, c}));
            treeSet.add(new TIFFField(531, 3, 1, new char[]{(char)(compressionValue == CompressionValue.JPEG_TTN2 ? 1 : 2)}));
            Object object3 = new long[][]{{15L, 1L}, {235L, 1L}, {128L, 1L}, {240L, 1L}, {128L, 1L}, {240L, 1L}};
            treeSet.add(new TIFFField(532, 5, 6, object3));
        }
        TIFFField[] tIFFFieldArray = tIFFEncodeParam.getExtraFields();
        ArrayList<Integer> arrayList = new ArrayList<Integer>(treeSet.size());
        for (TIFFField tIFFField : treeSet) {
            arrayList.add(tIFFField.getTag());
        }
        for (TIFFField object22 : tIFFFieldArray) {
            object = object22.getTag();
            if (arrayList.contains(object)) continue;
            treeSet.add(object22);
            arrayList.add((Integer)object);
        }
        int n18 = this.getDirectorySize(treeSet);
        lArray2[0] = n + n18;
        Object var37_42 = null;
        object = null;
        File file = null;
        int n4 = 0;
        boolean bl4 = false;
        Deflater deflater = null;
        boolean bl5 = false;
        if (compressionValue == CompressionValue.NONE) {
            int n5;
            nArray2 = 0;
            if (n12 == 16 && lArray2[0] % 2L != 0L) {
                nArray2 = 1;
                lArray2[0] = lArray2[0] + 1L;
            } else if (n12 == 32 && lArray2[0] % 4L != 0L) {
                nArray2 = (int)(4L - lArray2[0] % 4L);
                lArray2[0] = lArray2[0] + (long)nArray2;
            }
            for (n5 = 1; n5 < n15; ++n5) {
                lArray2[n5] = lArray2[n5 - 1] + lArray[n5 - 1];
            }
            if (!bl && ((n4 = (int)(lArray2[0] + l4)) & 1) != 0) {
                ++n4;
                bl4 = true;
            }
            this.writeDirectory(n, treeSet, n4);
            if (nArray2 != 0) {
                for (n5 = 0; n5 < nArray2; ++n5) {
                    this.output.write(0);
                }
            }
        } else {
            if (this.output instanceof SeekableOutputStream) {
                ((SeekableOutputStream)this.output).seek(lArray2[0]);
            } else {
                OutputStream outputStream = this.output;
                try {
                    file = File.createTempFile("jai-SOS-", ".tmp");
                    file.deleteOnExit();
                    RandomAccessFile randomAccessFile = new RandomAccessFile(file, "rw");
                    this.output = new SeekableOutputStream(randomAccessFile);
                }
                catch (IOException iOException) {
                    this.output = new ByteArrayOutputStream((int)l4);
                }
            }
            nArray2 = 0;
            switch (compressionValue) {
                case PACKBITS: {
                    nArray2 = (int)(l + (l2 + 127L) / 128L * (long)n16);
                    break;
                }
                case DEFLATE: {
                    nArray2 = (int)l;
                    deflater = new Deflater(tIFFEncodeParam.getDeflateLevel());
                    break;
                }
                default: {
                    nArray2 = 0;
                }
            }
            if (nArray2 != 0) {
                object = new byte[nArray2];
            }
        }
        int[] nArray3 = null;
        float[] fArray = null;
        boolean bl6 = n12 == 1 && sampleModel instanceof MultiPixelPackedSampleModel && n14 == 0 || n12 == 8 && sampleModel instanceof ComponentSampleModel;
        byte[] byArray = null;
        if (compressionValue != CompressionValue.JPEG_TTN2) {
            if (n14 == 0) {
                byArray = new byte[n16 * n17 * n13];
            } else if (bl3) {
                byArray = new byte[2 * n16 * n17 * n13];
            } else if (n14 == 3 || n14 == 4) {
                byArray = new byte[4 * n16 * n17 * n13];
            }
        }
        int n6 = n9 + n11;
        int n19 = n8 + n10;
        int n20 = 0;
        for (n3 = n9; n3 < n6; n3 += n16) {
            byteArrayOutputStream = bl2 ? n16 : Math.min(n16, n6 - n3);
            bl8 = byteArrayOutputStream * n17 * n13;
            block25: for (n2 = n8; n2 < n19; n2 += n17) {
                int n21;
                int n22;
                int n34;
                Raster raster = renderedImage.getData(new Rectangle(n2, n3, n17, byteArrayOutputStream));
                boolean bl7 = false;
                if (compressionValue != CompressionValue.JPEG_TTN2) {
                    if (bl6) {
                        if (n12 == 8) {
                            ComponentSampleModel n35 = (ComponentSampleModel)raster.getSampleModel();
                            int[] nArray4 = n35.getBankIndices();
                            int[] nArray5 = n35.getBandOffsets();
                            n34 = n35.getPixelStride();
                            n22 = n35.getScanlineStride();
                            if (n34 != n13 || (long)n22 != l2) {
                                bl7 = false;
                            } else {
                                bl7 = true;
                                for (n21 = 0; bl7 && n21 < n13; ++n21) {
                                    if (nArray4[n21] == 0 && nArray5[n21] == n21) continue;
                                    bl7 = false;
                                }
                            }
                        } else {
                            MultiPixelPackedSampleModel multiPixelPackedSampleModel = (MultiPixelPackedSampleModel)raster.getSampleModel();
                            if (multiPixelPackedSampleModel.getNumBands() == 1 && multiPixelPackedSampleModel.getDataBitOffset() == 0 && multiPixelPackedSampleModel.getPixelBitStride() == 1) {
                                bl7 = true;
                            }
                        }
                    }
                    if (!bl7) {
                        if (n14 == 4) {
                            fArray = raster.getPixels(n2, n3, n17, byteArrayOutputStream, fArray);
                        } else {
                            nArray3 = raster.getPixels(n2, n3, n17, byteArrayOutputStream, nArray3);
                        }
                    }
                }
                int n23 = 0;
                int n24 = 0;
                switch (n12) {
                    case 1: {
                        int n25;
                        int n26;
                        int n27;
                        if (bl7) {
                            byte[] byArray3 = ((DataBufferByte)raster.getDataBuffer()).getData();
                            MultiPixelPackedSampleModel multiPixelPackedSampleModel = (MultiPixelPackedSampleModel)raster.getSampleModel();
                            n21 = multiPixelPackedSampleModel.getScanlineStride();
                            n27 = multiPixelPackedSampleModel.getOffset(n2 - raster.getSampleModelTranslateX(), n3 - raster.getSampleModelTranslateY());
                            if ((long)n21 == l2) {
                                System.arraycopy(byArray3, n27, byArray, 0, (int)l2 * byteArrayOutputStream);
                            } else {
                                n26 = 0;
                                for (n25 = 0; n25 < byteArrayOutputStream; ++n25) {
                                    System.arraycopy(byArray3, n27, byArray, n26, (int)l2);
                                    n27 += n21;
                                    n26 = (int)((long)n26 + l2);
                                }
                            }
                        } else {
                            int n28 = 0;
                            for (n34 = 0; n34 < byteArrayOutputStream; ++n34) {
                                for (n22 = 0; n22 < n17 / 8; ++n22) {
                                    n23 = nArray3[n28++] << 7 | nArray3[n28++] << 6 | nArray3[n28++] << 5 | nArray3[n28++] << 4 | nArray3[n28++] << 3 | nArray3[n28++] << 2 | nArray3[n28++] << 1 | nArray3[n28++];
                                    byArray[n24++] = (byte)n23;
                                }
                                if (n17 % 8 <= 0) continue;
                                n23 = 0;
                                for (n22 = 0; n22 < n17 % 8; ++n22) {
                                    n23 |= nArray3[n28++] << 7 - n22;
                                }
                                byArray[n24++] = (byte)n23;
                            }
                        }
                        if (compressionValue == CompressionValue.NONE) {
                            this.output.write(byArray, 0, byteArrayOutputStream * ((n17 + 7) / 8));
                            continue block25;
                        }
                        if (compressionValue == CompressionValue.PACKBITS) {
                            int n29 = TIFFImageEncoder.compressPackBits(byArray, byteArrayOutputStream, l2, (byte[])object);
                            lArray[n20++] = n29;
                            this.output.write((byte[])object, 0, n29);
                            continue block25;
                        }
                        if (compressionValue != CompressionValue.DEFLATE) continue block25;
                        int n30 = TIFFImageEncoder.deflate(deflater, byArray, (byte[])object);
                        lArray[n20++] = n30;
                        this.output.write((byte[])object, 0, n30);
                        continue block25;
                    }
                    case 4: {
                        int n31 = 0;
                        for (n34 = 0; n34 < byteArrayOutputStream; ++n34) {
                            for (n22 = 0; n22 < n17 / 2; ++n22) {
                                n23 = nArray3[n31++] << 4 | nArray3[n31++];
                                byArray[n24++] = (byte)n23;
                            }
                            if ((n17 & 1) != 1) continue;
                            n23 = nArray3[n31++] << 4;
                            byArray[n24++] = (byte)n23;
                        }
                        if (compressionValue == CompressionValue.NONE) {
                            this.output.write(byArray, 0, byteArrayOutputStream * ((n17 + 1) / 2));
                            continue block25;
                        }
                        if (compressionValue == CompressionValue.PACKBITS) {
                            n34 = TIFFImageEncoder.compressPackBits(byArray, byteArrayOutputStream, l2, (byte[])object);
                            lArray[n20++] = n34;
                            this.output.write((byte[])object, 0, n34);
                            continue block25;
                        }
                        if (compressionValue != CompressionValue.DEFLATE) continue block25;
                        n34 = TIFFImageEncoder.deflate(deflater, byArray, (byte[])object);
                        lArray[n20++] = n34;
                        this.output.write((byte[])object, 0, n34);
                        continue block25;
                    }
                    case 8: {
                        int n25;
                        int n26;
                        int n27;
                        if (compressionValue != CompressionValue.JPEG_TTN2) {
                            if (bl7) {
                                byte[] byArray2 = ((DataBufferByte)raster.getDataBuffer()).getData();
                                ComponentSampleModel componentSampleModel = (ComponentSampleModel)raster.getSampleModel();
                                n21 = componentSampleModel.getOffset(n2 - raster.getSampleModelTranslateX(), n3 - raster.getSampleModelTranslateY());
                                n27 = componentSampleModel.getScanlineStride();
                                if ((long)n27 == l2) {
                                    System.arraycopy(byArray2, n21, byArray, 0, (int)l2 * byteArrayOutputStream);
                                } else {
                                    n26 = 0;
                                    for (n25 = 0; n25 < byteArrayOutputStream; ++n25) {
                                        System.arraycopy(byArray2, n21, byArray, n26, (int)l2);
                                        n21 += n27;
                                        n26 = (int)((long)n26 + l2);
                                    }
                                }
                            } else {
                                for (n34 = 0; n34 < bl8; ++n34) {
                                    byArray[n34] = (byte)nArray3[n34];
                                }
                            }
                        }
                        if (compressionValue == CompressionValue.NONE) {
                            this.output.write(byArray, 0, bl8);
                            continue block25;
                        }
                        if (compressionValue == CompressionValue.PACKBITS) {
                            n34 = TIFFImageEncoder.compressPackBits(byArray, byteArrayOutputStream, l2, (byte[])object);
                            lArray[n20++] = n34;
                            this.output.write((byte[])object, 0, n34);
                            continue block25;
                        }
                        if (compressionValue != CompressionValue.DEFLATE) continue block25;
                        n34 = TIFFImageEncoder.deflate(deflater, byArray, (byte[])object);
                        lArray[n20++] = n34;
                        this.output.write((byte[])object, 0, n34);
                        continue block25;
                    }
                    case 16: {
                        n34 = 0;
                        for (n22 = 0; n22 < bl8; ++n22) {
                            n21 = nArray3[n22];
                            byArray[n34++] = (byte)((n21 & 0xFF00) >> 8);
                            byArray[n34++] = (byte)(n21 & 0xFF);
                        }
                        if (compressionValue == CompressionValue.NONE) {
                            this.output.write(byArray, 0, bl8 * 2);
                            continue block25;
                        }
                        if (compressionValue == CompressionValue.PACKBITS) {
                            n22 = TIFFImageEncoder.compressPackBits(byArray, byteArrayOutputStream, l2, (byte[])object);
                            lArray[n20++] = n22;
                            this.output.write((byte[])object, 0, n22);
                            continue block25;
                        }
                        if (compressionValue != CompressionValue.DEFLATE) continue block25;
                        n22 = TIFFImageEncoder.deflate(deflater, byArray, (byte[])object);
                        lArray[n20++] = n22;
                        this.output.write((byte[])object, 0, n22);
                        continue block25;
                    }
                    case 32: {
                        int n27;
                        if (n14 == 3) {
                            n22 = 0;
                            for (n21 = 0; n21 < bl8; ++n21) {
                                n27 = nArray3[n21];
                                byArray[n22++] = (byte)((n27 & 0xFF000000) >>> 24);
                                byArray[n22++] = (byte)((n27 & 0xFF0000) >>> 16);
                                byArray[n22++] = (byte)((n27 & 0xFF00) >>> 8);
                                byArray[n22++] = (byte)(n27 & 0xFF);
                            }
                        } else {
                            n22 = 0;
                            for (n21 = 0; n21 < bl8; ++n21) {
                                n27 = Float.floatToIntBits(fArray[n21]);
                                byArray[n22++] = (byte)((n27 & 0xFF000000) >>> 24);
                                byArray[n22++] = (byte)((n27 & 0xFF0000) >>> 16);
                                byArray[n22++] = (byte)((n27 & 0xFF00) >>> 8);
                                byArray[n22++] = (byte)(n27 & 0xFF);
                            }
                        }
                        if (compressionValue == CompressionValue.NONE) {
                            this.output.write(byArray, 0, bl8 * 4);
                            continue block25;
                        }
                        if (compressionValue == CompressionValue.PACKBITS) {
                            n22 = TIFFImageEncoder.compressPackBits(byArray, byteArrayOutputStream, l2, (byte[])object);
                            lArray[n20++] = n22;
                            this.output.write((byte[])object, 0, n22);
                            continue block25;
                        }
                        if (compressionValue != CompressionValue.DEFLATE) continue block25;
                        n22 = TIFFImageEncoder.deflate(deflater, byArray, (byte[])object);
                        lArray[n20++] = n22;
                        this.output.write((byte[])object, 0, n22);
                        continue block25;
                    }
                }
            }
        }
        if (compressionValue == CompressionValue.NONE) {
            if (bl4) {
                this.output.write(0);
            }
        } else {
            void var37_44;
            n3 = 0;
            for (byteArrayOutputStream = 1; byteArrayOutputStream < n15; ++byteArrayOutputStream) {
                bl8 = (int)lArray[byteArrayOutputStream - 1];
                n3 += bl8;
                lArray2[byteArrayOutputStream] = lArray2[byteArrayOutputStream - 1] + (long)bl8;
            }
            int n32 = n4 = bl ? 0 : n + n18 + (n3 += (int)lArray[n15 - 1]);
            if ((n4 & 1) != 0) {
                ++n4;
                bl4 = true;
            }
            if (var37_44 == null) {
                if (bl4) {
                    this.output.write(0);
                }
                SeekableOutputStream seekableOutputStream = (SeekableOutputStream)this.output;
                long l3 = seekableOutputStream.getFilePointer();
                seekableOutputStream.seek(n);
                this.writeDirectory(n, treeSet, n4);
                seekableOutputStream.seek(l3);
            } else if (file != null) {
                try (FileInputStream fileInputStream = new FileInputStream(file);){
                    int n33;
                    this.output.close();
                    this.output = var37_44;
                    this.writeDirectory(n, treeSet, n4);
                    byte[] byArray3 = new byte[8192];
                    for (n2 = 0; n2 < n3; n2 += n33) {
                        n33 = fileInputStream.read(byArray3);
                        if (n33 == -1) {
                            break;
                        }
                        this.output.write(byArray3, 0, n33);
                    }
                }
                boolean bl9 = file.delete();
                assert (bl9);
                if (bl4) {
                    this.output.write(0);
                }
            } else if (this.output instanceof ByteArrayOutputStream) {
                ByteArrayOutputStream byteArrayOutputStream2 = (ByteArrayOutputStream)this.output;
                this.output = var37_44;
                this.writeDirectory(n, treeSet, n4);
                byteArrayOutputStream2.writeTo(this.output);
                if (bl4) {
                    this.output.write(0);
                }
            } else {
                throw new IllegalStateException(PropertyUtil.getString("TIFFImageEncoder13"));
            }
        }
        return n4;
    }

    private void validateImage(int n, int[] nArray, int n2, int n3, ColorModel colorModel) {
        for (int i = 1; i < nArray.length; ++i) {
            if (nArray[i] == n) continue;
            throw new RuntimeException(PropertyUtil.getString("TIFFImageEncoder0"));
        }
        if ((n == 1 || n == 4) && n2 != 1) {
            throw new RuntimeException(PropertyUtil.getString("TIFFImageEncoder1"));
        }
        switch (n3) {
            case 0: {
                if (n == 1 || n != 4 || n == 8) break;
                throw new RuntimeException(PropertyUtil.getString("TIFFImageEncoder2"));
            }
            case 1: 
            case 2: {
                if (n == 16) break;
                throw new RuntimeException(PropertyUtil.getString("TIFFImageEncoder3"));
            }
            case 3: 
            case 4: {
                if (n == 32) break;
                throw new RuntimeException(PropertyUtil.getString("TIFFImageEncoder4"));
            }
            default: {
                throw new RuntimeException(PropertyUtil.getString("TIFFImageEncoder5"));
            }
        }
        if (colorModel instanceof IndexColorModel && n3 != 0) {
            throw new RuntimeException(PropertyUtil.getString("TIFFImageEncoder6"));
        }
    }

    private int getDirectorySize(SortedSet sortedSet) {
        int n = sortedSet.size();
        int n2 = 2 + n * 12 + 4;
        for (TIFFField tIFFField : sortedSet) {
            int n3 = tIFFField.getCount() * SIZE_OF_TYPE[tIFFField.getType()];
            if (n3 <= 4) continue;
            n2 += n3;
        }
        return n2;
    }

    private void writeFileHeader() throws IOException {
        this.output.write(77);
        this.output.write(77);
        this.output.write(0);
        this.output.write(42);
        this.writeLong(8L);
    }

    private void writeDirectory(int n, SortedSet sortedSet, int n2) throws IOException {
        int n3 = sortedSet.size();
        long l = n + 12 * n3 + 4 + 2;
        ArrayList<TIFFField> arrayList = new ArrayList<TIFFField>();
        this.writeUnsignedShort(n3);
        for (TIFFField tIFFField : sortedSet) {
            int n4 = tIFFField.getTag();
            this.writeUnsignedShort(n4);
            int n5 = tIFFField.getType();
            this.writeUnsignedShort(n5);
            int n6 = tIFFField.getCount();
            int n7 = TIFFImageEncoder.getValueSize(tIFFField);
            this.writeLong(n5 == 2 ? (long)n7 : (long)n6);
            if (n7 > 4) {
                this.writeLong(l);
                l += (long)n7;
                arrayList.add(tIFFField);
                continue;
            }
            this.writeValuesAsFourBytes(tIFFField);
        }
        this.writeLong(n2);
        for (int i = 0; i < arrayList.size(); ++i) {
            this.writeValues((TIFFField)arrayList.get(i));
        }
    }

    private static int getValueSize(TIFFField tIFFField) throws UnsupportedEncodingException {
        int n = tIFFField.getType();
        int n2 = tIFFField.getCount();
        int n3 = 0;
        if (n == 2) {
            for (int i = 0; i < n2; ++i) {
                byte[] byArray = tIFFField.getAsString(i).getBytes("UTF-8");
                n3 += byArray.length;
                if (byArray[byArray.length - 1] == 0) continue;
                ++n3;
            }
        } else {
            n3 = n2 * SIZE_OF_TYPE[n];
        }
        return n3;
    }

    private void writeValuesAsFourBytes(TIFFField tIFFField) throws IOException {
        int n = tIFFField.getType();
        int n2 = tIFFField.getCount();
        switch (n) {
            case 1: {
                int n3;
                byte[] byArray = tIFFField.getAsBytes();
                if (n2 > 4) {
                    n2 = 4;
                }
                for (n3 = 0; n3 < n2; ++n3) {
                    this.output.write(byArray[n3]);
                }
                for (n3 = 0; n3 < 4 - n2; ++n3) {
                    this.output.write(0);
                }
                break;
            }
            case 3: {
                int n4;
                char[] cArray = tIFFField.getAsChars();
                if (n2 > 2) {
                    n2 = 2;
                }
                for (n4 = 0; n4 < n2; ++n4) {
                    this.writeUnsignedShort(cArray[n4]);
                }
                for (n4 = 0; n4 < 2 - n2; ++n4) {
                    this.writeUnsignedShort(0);
                }
                break;
            }
            case 4: {
                long[] lArray = tIFFField.getAsLongs();
                for (int i = 0; i < n2; ++i) {
                    this.writeLong(lArray[i]);
                }
                break;
            }
        }
    }

    private void writeValues(TIFFField tIFFField) throws IOException {
        int n = tIFFField.getType();
        int n2 = tIFFField.getCount();
        switch (n) {
            case 1: 
            case 6: 
            case 7: {
                byte[] byArray = tIFFField.getAsBytes();
                for (int i = 0; i < n2; ++i) {
                    this.output.write(byArray[i]);
                }
                break;
            }
            case 3: {
                char[] cArray = tIFFField.getAsChars();
                for (int i = 0; i < n2; ++i) {
                    this.writeUnsignedShort(cArray[i]);
                }
                break;
            }
            case 8: {
                short[] sArray = tIFFField.getAsShorts();
                for (int i = 0; i < n2; ++i) {
                    this.writeUnsignedShort(sArray[i]);
                }
                break;
            }
            case 4: 
            case 9: {
                long[] lArray = tIFFField.getAsLongs();
                for (int i = 0; i < n2; ++i) {
                    this.writeLong(lArray[i]);
                }
                break;
            }
            case 11: {
                float[] fArray = tIFFField.getAsFloats();
                for (int i = 0; i < n2; ++i) {
                    int n3 = Float.floatToIntBits(fArray[i]);
                    this.writeLong(n3);
                }
                break;
            }
            case 12: {
                double[] dArray = tIFFField.getAsDoubles();
                for (int i = 0; i < n2; ++i) {
                    long l = Double.doubleToLongBits(dArray[i]);
                    this.writeLong(l >>> 32);
                    this.writeLong(l & 0xFFFFFFFFL);
                }
                break;
            }
            case 5: 
            case 10: {
                long[][] lArray = tIFFField.getAsRationals();
                for (int i = 0; i < n2; ++i) {
                    this.writeLong(lArray[i][0]);
                    this.writeLong(lArray[i][1]);
                }
                break;
            }
            case 2: {
                for (int i = 0; i < n2; ++i) {
                    byte[] byArray = tIFFField.getAsString(i).getBytes("UTF-8");
                    this.output.write(byArray);
                    if (byArray[byArray.length - 1] == 0) continue;
                    this.output.write(0);
                }
                break;
            }
            default: {
                throw new RuntimeException(PropertyUtil.getString("TIFFImageEncoder10"));
            }
        }
    }

    private void writeUnsignedShort(int n) throws IOException {
        this.output.write((n & 0xFF00) >>> 8);
        this.output.write(n & 0xFF);
    }

    private void writeLong(long l) throws IOException {
        this.output.write((int)((l & 0xFFFFFFFFFF000000L) >>> 24));
        this.output.write((int)((l & 0xFF0000L) >>> 16));
        this.output.write((int)((l & 0xFF00L) >>> 8));
        this.output.write((int)(l & 0xFFL));
    }

    private static int compressPackBits(byte[] byArray, int n, long l, byte[] byArray2) {
        int n2 = 0;
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            n3 = TIFFImageEncoder.packBits(byArray, n2, (int)l, byArray2, n3);
            n2 = (int)((long)n2 + l);
        }
        return n3;
    }

    private static int packBits(byte[] byArray, int n, int n2, byte[] byArray2, int n3) {
        int n4 = n + n2 - 1;
        int n5 = n4 - 1;
        while (n <= n4) {
            int n6;
            byte by = byArray[n];
            for (n6 = 1; n6 < 127 && n < n4 && byArray[n] == byArray[n + 1]; ++n6, ++n) {
            }
            if (n6 > 1) {
                ++n;
                byArray2[n3++] = (byte)(-(n6 - 1));
                byArray2[n3++] = by;
            }
            int n7 = n3;
            for (n6 = 0; n6 < 128 && (n < n4 && byArray[n] != byArray[n + 1] || n < n5 && byArray[n] != byArray[n + 2]); ++n6) {
                byArray2[++n3] = byArray[n++];
            }
            if (n6 > 0) {
                byArray2[n7] = (byte)(n6 - 1);
                ++n3;
            }
            if (n != n4) continue;
            if (n6 > 0 && n6 < 128) {
                int n8 = n7;
                byArray2[n8] = (byte)(byArray2[n8] + 1);
                byArray2[n3++] = byArray[n++];
                continue;
            }
            byArray2[n3++] = 0;
            byArray2[n3++] = byArray[n++];
        }
        return n3;
    }

    private static int deflate(Deflater deflater, byte[] byArray, byte[] byArray2) {
        deflater.setInput(byArray);
        deflater.finish();
        int n = deflater.deflate(byArray2);
        deflater.reset();
        return n;
    }

    private static class Context {
        private RenderedImage nextImage;
        private int ifdOffset = 8;

        private Context() {
        }
    }
}

