/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlgraphics.image.loader.impl;

import java.io.IOException;
import java.nio.ByteOrder;
import javax.imageio.stream.ImageInputStream;
import javax.xml.transform.Source;
import org.apache.xmlgraphics.image.loader.ImageContext;
import org.apache.xmlgraphics.image.loader.ImageException;
import org.apache.xmlgraphics.image.loader.ImageInfo;
import org.apache.xmlgraphics.image.loader.ImageSize;
import org.apache.xmlgraphics.image.loader.impl.AbstractImagePreloader;
import org.apache.xmlgraphics.image.loader.util.ImageUtil;
import org.apache.xmlgraphics.util.UnitConv;

public class PreloaderBMP
extends AbstractImagePreloader {
    protected static final int BMP_SIG_LENGTH = 2;
    private static final int WIDTH_OFFSET = 18;

    @Override
    public ImageInfo preloadImage(String string, Source source, ImageContext imageContext) throws IOException, ImageException {
        boolean bl;
        if (!ImageUtil.hasImageInputStream(source)) {
            return null;
        }
        ImageInputStream imageInputStream = ImageUtil.needImageInputStream(source);
        byte[] byArray = this.getHeader(imageInputStream, 2);
        boolean bl2 = bl = byArray[0] == 66 && byArray[1] == 77;
        if (bl) {
            ImageInfo imageInfo = new ImageInfo(string, "image/bmp");
            imageInfo.setSize(this.determineSize(imageInputStream, imageContext));
            return imageInfo;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ImageSize determineSize(ImageInputStream imageInputStream, ImageContext imageContext) throws IOException, ImageException {
        imageInputStream.mark();
        ByteOrder byteOrder = imageInputStream.getByteOrder();
        try {
            int n;
            double d;
            ImageSize imageSize = new ImageSize();
            imageInputStream.setByteOrder(ByteOrder.LITTLE_ENDIAN);
            imageInputStream.skipBytes(18);
            int n2 = imageInputStream.readInt();
            int n3 = imageInputStream.readInt();
            imageSize.setSizeInPixels(n2, n3);
            imageInputStream.skipBytes(12);
            int n4 = imageInputStream.readInt();
            double d2 = UnitConv.in2mm((double)n4 / 1000.0);
            if (d2 == 0.0) {
                d2 = imageContext.getSourceResolution();
            }
            if ((d = UnitConv.in2mm((double)(n = imageInputStream.readInt()) / 1000.0)) == 0.0) {
                d = imageContext.getSourceResolution();
            }
            imageSize.setResolution(d2, d);
            imageSize.calcSizeFromPixels();
            ImageSize imageSize2 = imageSize;
            return imageSize2;
        }
        finally {
            imageInputStream.setByteOrder(byteOrder);
            imageInputStream.reset();
        }
    }
}

