/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlgraphics.image.loader.impl;

import java.io.IOException;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import javax.xml.transform.Source;
import org.apache.xmlgraphics.image.loader.ImageContext;
import org.apache.xmlgraphics.image.loader.ImageInfo;
import org.apache.xmlgraphics.image.loader.ImageSize;
import org.apache.xmlgraphics.image.loader.impl.AbstractImagePreloader;
import org.apache.xmlgraphics.image.loader.util.ImageUtil;

public class PreloaderGIF
extends AbstractImagePreloader {
    private static final int GIF_SIG_LENGTH = 10;

    @Override
    public ImageInfo preloadImage(String string, Source source, ImageContext imageContext) throws IOException {
        boolean bl;
        if (!ImageUtil.hasImageInputStream(source)) {
            return null;
        }
        ImageInputStream imageInputStream = ImageUtil.needImageInputStream(source);
        byte[] byArray = this.getHeader(imageInputStream, 10);
        boolean bl2 = bl = byArray[0] == 71 && byArray[1] == 73 && byArray[2] == 70 && byArray[3] == 56 && (byArray[4] == 55 || byArray[4] == 57) && byArray[5] == 97;
        if (bl) {
            ImageInfo imageInfo = new ImageInfo(string, "image/gif");
            imageInfo.setSize(this.determineSize(byArray, imageContext, imageInputStream));
            return imageInfo;
        }
        return null;
    }

    private ImageSize determineSize(byte[] byArray, ImageContext imageContext, ImageInputStream imageInputStream) throws IOException {
        int[] nArray = this.extractImageMetadata(imageInputStream);
        ImageSize imageSize = new ImageSize(nArray[0], nArray[1], imageContext.getSourceResolution());
        imageSize.calcSizeFromPixels();
        return imageSize;
    }

    private int[] extractImageMetadata(ImageInputStream imageInputStream) throws IOException {
        long l = imageInputStream.getStreamPosition();
        Iterator<ImageReader> iterator = ImageIO.getImageReadersByFormatName("gif");
        ImageReader imageReader = iterator.next();
        imageReader.setInput(imageInputStream, true);
        int n = imageReader.getWidth(0);
        int n2 = imageReader.getHeight(0);
        int[] nArray = new int[]{n, n2};
        imageInputStream.seek(l);
        return nArray;
    }
}

