/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlgraphics.java2d.ps;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.TexturePaint;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderableImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.xmlgraphics.java2d.AbstractGraphics2D;
import org.apache.xmlgraphics.java2d.GraphicContext;
import org.apache.xmlgraphics.java2d.GraphicsConfigurationWithoutTransparency;
import org.apache.xmlgraphics.java2d.StrokingTextHandler;
import org.apache.xmlgraphics.java2d.TextHandler;
import org.apache.xmlgraphics.java2d.ps.PSTilingPattern;
import org.apache.xmlgraphics.ps.PSGenerator;
import org.apache.xmlgraphics.ps.PSImageUtils;

public class PSGraphics2D
extends AbstractGraphics2D {
    private static final AffineTransform IDENTITY_TRANSFORM = new AffineTransform();
    private static final boolean DEBUG = false;
    protected List<Integer> pathHashCache = new ArrayList<Integer>();
    protected boolean startCache;
    protected PSGraphics2D rootG2D;
    protected PSGenerator gen;
    protected boolean clippingDisabled;
    protected TextHandler fallbackTextHandler = new StrokingTextHandler();
    protected TextHandler customTextHandler;
    protected Color currentColour = new Color(0, 0, 0);
    private Graphics2D fmg;

    public PSGraphics2D(boolean bl) {
        super(bl);
        BufferedImage bufferedImage = new BufferedImage(1, 1, 2);
        this.fmg = bufferedImage.createGraphics();
    }

    public PSGraphics2D(boolean bl, PSGenerator pSGenerator) {
        this(bl);
        this.setPSGenerator(pSGenerator);
    }

    public PSGraphics2D(PSGraphics2D pSGraphics2D) {
        super(pSGraphics2D);
        BufferedImage bufferedImage = new BufferedImage(1, 1, 2);
        this.fmg = bufferedImage.createGraphics();
        this.rootG2D = pSGraphics2D.rootG2D != null ? pSGraphics2D.rootG2D : pSGraphics2D;
        this.setPSGenerator(pSGraphics2D.gen);
        this.clippingDisabled = pSGraphics2D.clippingDisabled;
        this.customTextHandler = pSGraphics2D.customTextHandler;
        this.currentColour = pSGraphics2D.currentColour;
    }

    public void setPSGenerator(PSGenerator pSGenerator) {
        this.gen = pSGenerator;
    }

    public PSGenerator getPSGenerator() {
        return this.gen;
    }

    public void setGraphicContext(GraphicContext graphicContext) {
        this.gc = graphicContext;
    }

    public TextHandler getFallbackTextHandler() {
        return this.fallbackTextHandler;
    }

    public TextHandler getCustomTextHandler() {
        return this.customTextHandler;
    }

    public void setCustomTextHandler(TextHandler textHandler) {
        this.customTextHandler = textHandler;
    }

    public void disableClipping(boolean bl) {
        this.clippingDisabled = bl;
    }

    @Override
    public Graphics create() {
        this.preparePainting();
        return new PSGraphics2D(this);
    }

    public void handleIOException(IOException iOException) {
        iOException.printStackTrace();
    }

    public void preparePainting() {
        if (this.rootG2D != null) {
            this.rootG2D.preparePainting();
        }
    }

    @Override
    public boolean drawImage(Image image, int n, int n2, ImageObserver imageObserver) {
        this.preparePainting();
        int n3 = image.getWidth(imageObserver);
        int n4 = image.getHeight(imageObserver);
        if (n3 == -1 || n4 == -1) {
            return false;
        }
        Dimension dimension = new Dimension(n3, n4);
        BufferedImage bufferedImage = this.buildBufferedImage(dimension);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setComposite(AlphaComposite.SrcOver);
        graphics2D.setBackground(new Color(1, 1, 1, 0));
        graphics2D.fillRect(0, 0, n3, n4);
        graphics2D.clip(new Rectangle(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight()));
        if (!graphics2D.drawImage(image, 0, 0, imageObserver)) {
            return false;
        }
        graphics2D.dispose();
        try {
            AffineTransform affineTransform = this.getTransform();
            this.gen.saveGraphicsState();
            this.gen.concatMatrix(affineTransform);
            Shape shape = this.getClip();
            this.writeClip(shape);
            PSImageUtils.renderBitmapImage(bufferedImage, n, n2, n3, n4, this.gen);
            this.gen.restoreGraphicsState();
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
        }
        return true;
    }

    public BufferedImage buildBufferedImage(Dimension dimension) {
        return new BufferedImage(dimension.width, dimension.height, 2);
    }

    @Override
    public boolean drawImage(Image image, int n, int n2, int n3, int n4, ImageObserver imageObserver) {
        this.preparePainting();
        System.err.println("NYI: drawImage");
        return true;
    }

    @Override
    public void dispose() {
        this.gen = null;
        this.fallbackTextHandler = null;
        this.customTextHandler = null;
        this.currentColour = null;
    }

    public int processShape(Shape shape, boolean bl) throws IOException {
        if (shape instanceof Rectangle2D) {
            Rectangle2D rectangle2D = (Rectangle2D)shape;
            this.gen.defineRect(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
            return 1;
        }
        PathIterator pathIterator = shape.getPathIterator(IDENTITY_TRANSFORM);
        if (bl) {
            this.processPathIteratorCached(shape);
        } else {
            this.processPathIterator(pathIterator);
        }
        return pathIterator.getWindingRule();
    }

    protected String processPathIteratorToString(PathIterator pathIterator) throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        double[] dArray = new double[6];
        while (!pathIterator.isDone()) {
            int n = pathIterator.currentSegment(dArray);
            switch (n) {
                case 3: {
                    stringBuilder.append(this.gen.formatDouble(dArray[0])).append(" ").append(this.gen.formatDouble(dArray[1])).append(" ").append(this.gen.formatDouble(dArray[2])).append(" ").append(this.gen.formatDouble(dArray[3])).append(" ").append(this.gen.formatDouble(dArray[4])).append(" ").append(this.gen.formatDouble(dArray[5])).append(" ").append(this.gen.mapCommand("curveto")).append("\n");
                    break;
                }
                case 1: {
                    stringBuilder.append(this.gen.formatDouble(dArray[0])).append(" ").append(this.gen.formatDouble(dArray[1])).append(" ").append(this.gen.mapCommand("lineto")).append("\n");
                    break;
                }
                case 0: {
                    stringBuilder.append(this.gen.formatDouble(dArray[0])).append(" ").append(this.gen.formatDouble(dArray[1])).append(" ").append(this.gen.mapCommand("moveto")).append("\n");
                    break;
                }
                case 2: {
                    stringBuilder.append(this.gen.formatDouble(dArray[0])).append(" ").append(this.gen.formatDouble(dArray[1])).append(" ").append(this.gen.formatDouble(dArray[2])).append(" ").append(this.gen.formatDouble(dArray[3])).append(" QT").append("\n");
                    break;
                }
                case 4: {
                    stringBuilder.append(this.gen.mapCommand("closepath")).append("\n");
                    break;
                }
            }
            pathIterator.next();
        }
        return stringBuilder.toString().trim();
    }

    protected void processPathIteratorCached(Shape shape) throws IOException {
        String string = this.processPathIteratorToString(shape.getPathIterator(IDENTITY_TRANSFORM));
        int n = string.hashCode();
        if (!this.startCache) {
            if (this.pathHashCache.contains(n)) {
                this.startCache = true;
                this.pathHashCache.clear();
            } else {
                this.gen.writeln(string);
                this.pathHashCache.add(n);
            }
        }
        if (this.startCache) {
            if (!this.pathHashCache.contains(n)) {
                this.gen.writeln("/f" + n + "{" + string + "}def");
                this.pathHashCache.add(n);
            }
            this.gen.writeln("f" + n);
        }
    }

    public void processPathIterator(PathIterator pathIterator) throws IOException {
        this.gen.writeln(this.processPathIteratorToString(pathIterator));
    }

    @Override
    public void draw(Shape shape) {
        this.preparePainting();
        try {
            Shape shape2;
            boolean bl;
            this.gen.saveGraphicsState();
            AffineTransform affineTransform = this.getTransform();
            boolean bl2 = bl = !affineTransform.isIdentity();
            if (bl) {
                this.gen.concatMatrix(affineTransform);
            }
            if (this.shouldBeClipped(shape2 = this.getClip(), shape)) {
                this.writeClip(shape2);
            }
            this.establishColor(this.getColor());
            this.applyPaint(this.getPaint(), false);
            this.applyStroke(this.getStroke());
            this.gen.writeln(this.gen.mapCommand("newpath"));
            this.processShape(shape, false);
            this.doDrawing(false, true, false);
            this.gen.restoreGraphicsState();
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
        }
    }

    public boolean shouldBeClipped(Shape shape, Shape shape2) {
        if (shape == null || shape2 == null) {
            return false;
        }
        if (shape2 instanceof Line2D) {
            return true;
        }
        Area area = new Area(shape2);
        Area area2 = new Area(shape);
        area2.intersect(area);
        return !area2.equals(area);
    }

    public void writeClip(Shape shape) {
        if (shape == null) {
            return;
        }
        if (!this.clippingDisabled) {
            this.preparePainting();
            try {
                this.gen.writeln(this.gen.mapCommand("newpath"));
                this.processShape(shape, false);
                this.gen.writeln(this.gen.mapCommand("clip"));
            }
            catch (IOException iOException) {
                this.handleIOException(iOException);
            }
        }
    }

    protected void applyPaint(Paint paint, boolean bl) {
        this.preparePainting();
        if (paint instanceof GradientPaint) {
            System.err.println("NYI: Gradient paint");
        } else if (paint instanceof TexturePaint && bl) {
            try {
                PSTilingPattern pSTilingPattern = new PSTilingPattern("Pattern1", (TexturePaint)paint, 0.0, 0.0, 3, null);
                this.gen.write(pSTilingPattern.toString());
                this.gen.writeln("/Pattern " + this.gen.mapCommand("setcolorspace"));
                this.gen.writeln(pSTilingPattern.getName() + " " + this.gen.mapCommand("setcolor"));
            }
            catch (IOException iOException) {
                this.handleIOException(iOException);
            }
        }
    }

    protected void applyStroke(Stroke stroke) {
        this.preparePainting();
        try {
            PSGraphics2D.applyStroke(stroke, this.gen);
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
        }
    }

    public static void applyStroke(Stroke stroke, PSGenerator pSGenerator) throws IOException {
        if (stroke instanceof BasicStroke) {
            float f;
            BasicStroke basicStroke = (BasicStroke)stroke;
            float[] fArray = basicStroke.getDashArray();
            if (fArray != null) {
                StringBuffer stringBuffer = new StringBuffer("[");
                for (int i = 0; i < fArray.length; ++i) {
                    stringBuffer.append(pSGenerator.formatDouble(fArray[i]));
                    if (i >= fArray.length - 1) continue;
                    stringBuffer.append(" ");
                }
                stringBuffer.append("] ");
                float f2 = basicStroke.getDashPhase();
                stringBuffer.append(pSGenerator.formatDouble(f2));
                pSGenerator.useDash(stringBuffer.toString());
            } else {
                pSGenerator.useDash(null);
            }
            int n = basicStroke.getEndCap();
            switch (n) {
                case 0: {
                    pSGenerator.useLineCap(0);
                    break;
                }
                case 1: {
                    pSGenerator.useLineCap(1);
                    break;
                }
                case 2: {
                    pSGenerator.useLineCap(2);
                    break;
                }
                default: {
                    System.err.println("Unsupported line cap: " + n);
                }
            }
            int n2 = basicStroke.getLineJoin();
            switch (n2) {
                case 0: {
                    pSGenerator.useLineJoin(0);
                    f = basicStroke.getMiterLimit();
                    pSGenerator.useMiterLimit(f >= -1.0f ? f : 1.0f);
                    break;
                }
                case 1: {
                    pSGenerator.useLineJoin(1);
                    break;
                }
                case 2: {
                    pSGenerator.useLineJoin(2);
                    break;
                }
                default: {
                    System.err.println("Unsupported line join: " + n2);
                }
            }
            f = basicStroke.getLineWidth();
            pSGenerator.useLineWidth(f);
        } else {
            System.err.println("Stroke not supported: " + stroke.toString());
        }
    }

    @Override
    public void drawRenderedImage(RenderedImage renderedImage, AffineTransform affineTransform) {
        this.preparePainting();
        try {
            AffineTransform affineTransform2 = this.getTransform();
            this.gen.saveGraphicsState();
            this.gen.concatMatrix(affineTransform2);
            this.gen.concatMatrix(affineTransform);
            Shape shape = this.getClip();
            this.writeClip(shape);
            PSImageUtils.renderBitmapImage(renderedImage, 0.0f, 0.0f, renderedImage.getWidth(), renderedImage.getHeight(), this.gen);
            this.gen.restoreGraphicsState();
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
        }
    }

    @Override
    public void drawRenderableImage(RenderableImage renderableImage, AffineTransform affineTransform) {
        this.preparePainting();
        System.err.println("NYI: drawRenderableImage");
    }

    public void establishColor(Color color) throws IOException {
        this.gen.useColor(color);
    }

    @Override
    public void drawString(String string, float f, float f2) {
        try {
            if (this.customTextHandler != null && !this.textAsShapes) {
                this.customTextHandler.drawString(this, string, f, f2);
            } else {
                this.fallbackTextHandler.drawString(this, string, f, f2);
            }
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
        }
    }

    @Override
    public void fill(Shape shape) {
        this.preparePainting();
        try {
            Shape shape2;
            boolean bl;
            this.gen.saveGraphicsState();
            AffineTransform affineTransform = this.getTransform();
            boolean bl2 = bl = !affineTransform.isIdentity();
            if (bl) {
                this.gen.concatMatrix(affineTransform);
            }
            if (this.shouldBeClipped(shape2 = this.getClip(), shape)) {
                this.writeClip(shape2);
            }
            this.establishColor(this.getColor());
            this.applyPaint(this.getPaint(), true);
            this.gen.writeln(this.gen.mapCommand("newpath"));
            int n = this.processShape(shape, true);
            this.doDrawing(true, false, n == 0);
            this.gen.restoreGraphicsState();
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
        }
    }

    protected void doDrawing(boolean bl, boolean bl2, boolean bl3) throws IOException {
        this.preparePainting();
        if (bl) {
            if (bl2) {
                if (!bl3) {
                    this.gen.writeln(this.gen.mapCommand("gsave") + " " + this.gen.mapCommand("fill") + " " + this.gen.mapCommand("grestore") + " " + this.gen.mapCommand("stroke"));
                } else {
                    this.gen.writeln(this.gen.mapCommand("gsave") + " " + this.gen.mapCommand("eofill") + " " + this.gen.mapCommand("grestore") + " " + this.gen.mapCommand("stroke"));
                }
            } else if (!bl3) {
                this.gen.writeln(this.gen.mapCommand("fill"));
            } else {
                this.gen.writeln(this.gen.mapCommand("eofill"));
            }
        } else {
            this.gen.writeln(this.gen.mapCommand("stroke"));
        }
    }

    @Override
    public GraphicsConfiguration getDeviceConfiguration() {
        return new GraphicsConfigurationWithoutTransparency();
    }

    @Override
    public FontMetrics getFontMetrics(Font font) {
        return this.fmg.getFontMetrics(font);
    }

    @Override
    public void setXORMode(Color color) {
        System.err.println("NYI: setXORMode");
    }

    @Override
    public void copyArea(int n, int n2, int n3, int n4, int n5, int n6) {
        System.err.println("NYI: copyArea");
    }
}

