/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlgraphics.ps.dsc.events;

import java.io.IOException;
import org.apache.xmlgraphics.ps.DSCConstants;
import org.apache.xmlgraphics.ps.PSGenerator;
import org.apache.xmlgraphics.ps.dsc.events.AbstractDSCComment;

public class DSCCommentPages
extends AbstractDSCComment {
    private int pageCount = -1;

    public DSCCommentPages() {
    }

    public DSCCommentPages(int n) {
        this.pageCount = n;
    }

    public int getPageCount() {
        return this.pageCount;
    }

    public void setPageCount(int n) {
        this.pageCount = n;
    }

    @Override
    public String getName() {
        return "Pages";
    }

    @Override
    public boolean hasValues() {
        return true;
    }

    @Override
    public void parseValue(String string) {
        this.pageCount = Integer.parseInt(string);
    }

    @Override
    public void generate(PSGenerator pSGenerator) throws IOException {
        if (this.getPageCount() > 0) {
            pSGenerator.writeDSCComment(this.getName(), this.getPageCount());
        } else {
            pSGenerator.writeDSCComment(this.getName(), DSCConstants.ATEND);
        }
    }
}

