/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.server;

import java.io.IOException;
import org.hsqldb.lib.DataOutputStream;
import org.hsqldb.lib.HsqlByteArrayOutputStream;

class OdbcPacketOutputStream
extends DataOutputStream {
    private HsqlByteArrayOutputStream byteArrayOutputStream;
    private HsqlByteArrayOutputStream stringWriterOS = new HsqlByteArrayOutputStream();
    private DataOutputStream stringWriterDos = new DataOutputStream(this.stringWriterOS);
    private int packetStart = 0;

    public int getSize() {
        return this.count - this.packetStart;
    }

    synchronized void write(String string) throws IOException {
        this.write(string, true);
    }

    synchronized void write(String string, boolean bl) throws IOException {
        this.stringWriterDos.writeUTF(string);
        this.write(this.stringWriterOS.toByteArray(), 2, this.stringWriterOS.size() - 2);
        this.stringWriterOS.reset();
        if (bl) {
            this.writeByte(0);
        }
    }

    synchronized void writeSized(String string) throws IOException {
        this.stringWriterDos.writeUTF(string);
        byte[] byArray = this.stringWriterOS.toByteArray();
        this.stringWriterOS.reset();
        this.writeInt(byArray.length - 2);
        this.write(byArray, 2, byArray.length - 2);
    }

    synchronized void reset() throws IOException {
        this.byteArrayOutputStream.reset();
        this.packetStart = this.count;
        this.writeInt(-1);
    }

    static OdbcPacketOutputStream newOdbcPacketOutputStream() throws IOException {
        return new OdbcPacketOutputStream(new HsqlByteArrayOutputStream());
    }

    protected OdbcPacketOutputStream(HsqlByteArrayOutputStream hsqlByteArrayOutputStream) throws IOException {
        super(hsqlByteArrayOutputStream);
        this.byteArrayOutputStream = hsqlByteArrayOutputStream;
        this.reset();
    }

    synchronized int xmit(char c, DataOutputStream dataOutputStream) throws IOException {
        byte[] byArray = this.byteArrayOutputStream.toByteArray();
        byArray[0] = (byte)(byArray.length >> 24);
        byArray[1] = (byte)(byArray.length >> 16);
        byArray[2] = (byte)(byArray.length >> 8);
        byArray[3] = (byte)byArray.length;
        this.reset();
        dataOutputStream.writeByte(c);
        dataOutputStream.write(byArray);
        dataOutputStream.flush();
        return byArray.length;
    }

    @Override
    public synchronized void close() throws IOException {
        super.close();
        this.stringWriterDos.close();
    }

    public synchronized void writeByteChar(char c) throws IOException {
        this.writeByte(c);
    }
}

