/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.rvcmd.icon;

import java.io.IOException;
import java.io.OutputStream;
import net.kano.joscar.BinaryTools;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.LiveWritable;
import net.kano.joscar.rvcmd.AbstractRequestRvCmd;
import net.kano.joscar.snaccmd.CapabilityBlock;
import net.kano.joscar.snaccmd.icbm.OldIconHashInfo;
import net.kano.joscar.snaccmd.icbm.RecvRvIcbm;

public class SendBuddyIconRvCmd
extends AbstractRequestRvCmd {
    public static final String ICONIDSTRING_DEFAULT = "AVT1picture.id";
    private final OldIconHashInfo hash;
    private final ByteBlock iconData;
    private final LiveWritable iconWriter;
    private final String iconId;

    public SendBuddyIconRvCmd(RecvRvIcbm icbm) {
        super(icbm);
        this.iconWriter = null;
        ByteBlock serviceData = this.getServiceData();
        OldIconHashInfo hash = null;
        ByteBlock iconData = null;
        String iconId = null;
        if (serviceData != null && (hash = OldIconHashInfo.readIconHashFromRvData(serviceData)) != null) {
            int hashLen = hash.getRvDataFormatLength();
            int iconSize = (int)hash.getIconSize();
            if (serviceData.getLength() >= hashLen + iconSize) {
                iconData = serviceData.subBlock(hashLen, iconSize);
                ByteBlock iconIdBlock = serviceData.subBlock(hashLen + iconSize);
                if (iconIdBlock.getLength() > 0) {
                    iconId = BinaryTools.getAsciiString(iconIdBlock);
                }
            }
        }
        this.hash = hash;
        this.iconData = iconData;
        this.iconId = iconId;
    }

    public SendBuddyIconRvCmd(OldIconHashInfo hash, LiveWritable iconDataWriter) {
        this(hash, iconDataWriter, ICONIDSTRING_DEFAULT);
    }

    public SendBuddyIconRvCmd(OldIconHashInfo hash, LiveWritable iconDataWriter, String iconIdString) {
        super(CapabilityBlock.BLOCK_ICON);
        DefensiveTools.checkNull(hash, "hash");
        DefensiveTools.checkNull(iconDataWriter, "iconDataWriter");
        this.hash = hash;
        this.iconData = null;
        this.iconWriter = iconDataWriter;
        this.iconId = iconIdString;
    }

    public final OldIconHashInfo getIconHash() {
        return this.hash;
    }

    public final ByteBlock getIconData() {
        return this.iconData;
    }

    public final String getIconIdString() {
        return this.iconId;
    }

    protected void writeRvTlvs(OutputStream out) throws IOException {
    }

    protected void writeServiceData(OutputStream out) throws IOException {
        if (this.hash != null) {
            this.hash.writeToRvData(out);
            if (this.iconData != null || this.iconWriter != null) {
                if (this.iconWriter != null) {
                    this.iconWriter.write(out);
                } else {
                    this.iconData.write(out);
                }
                if (this.iconId != null) {
                    out.write(BinaryTools.getAsciiBytes(this.iconId));
                }
            }
        }
    }

    public String toString() {
        return "SendBuddyIconRvCmd: hash=" + this.hash + ", icon=" + (this.iconData == null ? -1 : this.iconData.getLength()) + " bytes (id=" + this.iconId + ")";
    }
}

