/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd.popup;

import java.io.IOException;
import java.io.OutputStream;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.flapcmd.SnacPacket;
import net.kano.joscar.snaccmd.popup.PopupCommand;
import net.kano.joscar.tlv.ImmutableTlvChain;
import net.kano.joscar.tlv.Tlv;
import net.kano.joscar.tlv.TlvTools;

public class PopupMsg
extends PopupCommand {
    private static final int TYPE_MSG = 1;
    private static final int TYPE_URL = 2;
    private static final int TYPE_WIDTH = 3;
    private static final int TYPE_HEIGHT = 4;
    private static final int TYPE_DELAY = 5;
    private final String message;
    private final String url;
    private final int width;
    private final int height;
    private final int delay;

    protected PopupMsg(SnacPacket packet) {
        super(2);
        DefensiveTools.checkNull(packet, "packet");
        ByteBlock snacData = packet.getData();
        ImmutableTlvChain chain = TlvTools.readChain(snacData);
        this.message = chain.getString(1);
        this.url = chain.getString(2);
        this.width = chain.getUShort(3);
        this.height = chain.getUShort(4);
        this.delay = chain.getUShort(5);
    }

    public PopupMsg(String message, String url, int width, int height, int delay) {
        super(2);
        this.message = message;
        this.url = url;
        this.width = width;
        this.height = height;
        this.delay = delay;
    }

    public final String getMessage() {
        return this.message;
    }

    public final String getUrl() {
        return this.url;
    }

    public final int getWidth() {
        return this.width;
    }

    public final int getHeight() {
        return this.height;
    }

    public final int getDelay() {
        return this.delay;
    }

    public void writeData(OutputStream out) throws IOException {
        if (this.message != null) {
            Tlv.getStringInstance(1, this.message).write(out);
        }
        if (this.url != null) {
            Tlv.getStringInstance(2, this.url).write(out);
        }
        if (this.width != -1) {
            Tlv.getUShortInstance(3, this.width).write(out);
        }
        if (this.height != -1) {
            Tlv.getUShortInstance(4, this.height).write(out);
        }
        if (this.delay != -1) {
            Tlv.getUShortInstance(5, this.delay).write(out);
        }
    }

    public String toString() {
        return "PopupMsg (" + this.width + " x " + this.height + ", delay=" + this.delay + "): " + this.message + " (" + this.url + ")";
    }
}

