/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joustsim.oscar;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.CopyOnWriteArrayList;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.snaccmd.CertificateInfo;
import net.kano.joustsim.oscar.AimConnection;
import net.kano.joustsim.oscar.CapabilityHandler;
import net.kano.joustsim.oscar.CapabilityListener;
import net.kano.joustsim.oscar.CapabilityManager;
import net.kano.joustsim.oscar.OpenedServiceListener;
import net.kano.joustsim.oscar.oscar.service.Service;
import net.kano.joustsim.oscar.oscar.service.info.InfoService;
import net.kano.joustsim.trust.PrivateKeys;
import net.kano.joustsim.trust.PrivateKeysPreferences;
import net.kano.joustsim.trust.TrustPreferences;

public class SecurityEnabledHandler
implements CapabilityHandler {
    private static final Logger logger = Logger.getLogger(SecurityEnabledHandler.class.getName());
    private final AimConnection conn;
    private boolean boundInfoService = false;
    private final PrivateKeysPreferences keysMgr;
    private CopyOnWriteArrayList<CapabilityListener> listeners = new CopyOnWriteArrayList();
    private boolean enabled = false;

    public SecurityEnabledHandler(AimConnection conn) {
        DefensiveTools.checkNull(conn, "conn");
        this.conn = conn;
        conn.addOpenedServiceListener(new OpenedServiceListener(){

            @Override
            public void openedServices(AimConnection conn, Collection<? extends Service> services) {
                SecurityEnabledHandler.this.bindToInfoService();
            }

            @Override
            public void closedServices(AimConnection conn, Collection<? extends Service> services) {
            }
        });
        TrustPreferences trustPrefs = conn.getAimSession().getTrustPreferences();
        if (trustPrefs == null) {
            logger.fine("Warning: Key manager for SecurityEnabledHandler will not be set because the AIM session's trust preferences are null");
            this.keysMgr = null;
        } else {
            this.keysMgr = trustPrefs.getPrivateKeysPreferences();
            this.keysMgr.addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent evt) {
                    String prop = evt.getPropertyName();
                    if (prop.equals("keysInfo")) {
                        SecurityEnabledHandler.this.updateCertInfo();
                    }
                }
            });
        }
        this.updateEnabledStatus();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void bindToInfoService() {
        SecurityEnabledHandler securityEnabledHandler = this;
        synchronized (securityEnabledHandler) {
            if (this.boundInfoService) {
                return;
            }
            this.boundInfoService = true;
        }
        this.updateCertInfo();
    }

    private void updateCertInfo() {
        InfoService infoService = this.conn.getInfoService();
        if (infoService != null) {
            infoService.setCertificateInfo(this.generateLocalCertificateInfo());
        }
        this.updateEnabledStatus();
    }

    private CertificateInfo generateLocalCertificateInfo() {
        byte[] encEncrypting;
        byte[] encSigning;
        CertificateInfo certInfo;
        PrivateKeys keys = this.keysMgr != null ? this.keysMgr.getKeysInfo() : null;
        if (keys == null) {
            logger.fine("User has no private keys");
            return null;
        }
        X509Certificate signing = keys.getSigningCertificate();
        X509Certificate encrypting = keys.getEncryptionCertificate();
        if (signing == null && encrypting == null) {
            logger.fine("User has no signing or encrypting key, but has some kind of private keys info stored");
            return null;
        }
        if (signing == null) {
            logger.fine("User has no signing key");
            return null;
        }
        if (encrypting == null) {
            logger.fine("User has no encrypting key");
            return null;
        }
        if (signing == encrypting) {
            try {
                byte[] encCert = signing.getEncoded();
                certInfo = new CertificateInfo(ByteBlock.wrap(encCert));
            }
            catch (CertificateEncodingException e) {
                logger.log(Level.WARNING, "Could not encode common certificate to upload to server", e);
                return null;
            }
        }
        try {
            encSigning = signing.getEncoded();
        }
        catch (CertificateEncodingException e1) {
            logger.log(Level.WARNING, "Could not encode signing certificate to upload to server", e1);
            return null;
        }
        try {
            encEncrypting = encrypting.getEncoded();
        }
        catch (CertificateEncodingException e1) {
            logger.log(Level.WARNING, "Could not encode encrypting certificate to upload to server", e1);
            return null;
        }
        certInfo = new CertificateInfo(ByteBlock.wrap(encEncrypting), ByteBlock.wrap(encSigning));
        return certInfo;
    }

    public void handleAdded(CapabilityManager manager) {
    }

    public void handleRemoved(CapabilityManager manager) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateEnabledStatus() {
        boolean newStatus;
        boolean old;
        SecurityEnabledHandler securityEnabledHandler = this;
        synchronized (securityEnabledHandler) {
            old = this.enabled;
            this.enabled = newStatus = this.computeEnabledStatus();
        }
        if (old != newStatus) {
            for (CapabilityListener listener : this.listeners) {
                listener.capabilityEnabled(this, newStatus);
            }
        }
    }

    public synchronized boolean isEnabled() {
        return this.enabled;
    }

    private synchronized boolean computeEnabledStatus() {
        if (this.keysMgr == null) {
            return false;
        }
        PrivateKeys keys = this.keysMgr.getKeysInfo();
        return keys != null && keys.getEncryptingKeys() != null && keys.getSigningKeys() != null;
    }

    public void addCapabilityListener(CapabilityListener listener) {
        this.listeners.addIfAbsent(listener);
    }

    public void removeCapabilityListener(CapabilityListener listener) {
        this.listeners.remove(listener);
    }
}

