/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.msofficecomm;

import net.java.sip.communicator.plugin.msofficecomm.Messenger;
import net.java.sip.communicator.util.Logger;

public class MessengerContact {
    private static final Logger logger = Logger.getLogger(MessengerContact.class);
    public final String signinName;

    public MessengerContact(String signinName) {
        this.signinName = signinName;
    }

    public String getPhoneNumber(int type) {
        try {
            return Messenger.getPhoneNumber(this, type);
        }
        catch (Throwable t) {
            if (t instanceof ThreadDeath) {
                throw (ThreadDeath)t;
            }
            if (t instanceof OutOfMemoryError) {
                throw (OutOfMemoryError)t;
            }
            logger.error((Object)("Failed to retrieve the phone number information of an IMessengerContact with sign-in name: " + this.signinName), t);
            throw new RuntimeException(t);
        }
    }

    public int getStatus() {
        try {
            return Messenger.getStatus(this);
        }
        catch (Throwable t) {
            if (t instanceof ThreadDeath) {
                throw (ThreadDeath)t;
            }
            if (t instanceof OutOfMemoryError) {
                throw (OutOfMemoryError)t;
            }
            logger.error((Object)("Failed to determine the status of an IMessengerContact with sign-in name: " + this.signinName), t);
            throw new RuntimeException(t);
        }
    }

    public boolean isSelf() {
        return Messenger.isSelf(this);
    }
}

