/*
 * Decompiled with CFR 0.152.
 */
package net.java.otr4j.session;

import java.net.ProtocolException;
import net.java.otr4j.session.InstanceTag;
import net.java.otr4j.session.UnknownInstanceException;

public final class OtrAssembler {
    private StringBuffer fragment;
    private int fragmentCur;
    private int fragmentMax;
    private final InstanceTag ownInstance;
    private static final String HEAD_FRAGMENT_V2 = "?OTR,";
    private static final String HEAD_FRAGMENT_V3 = "?OTR|";

    public OtrAssembler(InstanceTag ownInstance) {
        this.ownInstance = ownInstance;
        this.discard();
    }

    public String accumulate(String msgText) throws ProtocolException, UnknownInstanceException {
        int n;
        int k;
        if (msgText.startsWith(HEAD_FRAGMENT_V2)) {
            msgText = msgText.substring(HEAD_FRAGMENT_V2.length());
        } else if (msgText.startsWith(HEAD_FRAGMENT_V3)) {
            int receiverInstance;
            msgText = msgText.substring(HEAD_FRAGMENT_V3.length());
            String[] instancePart = msgText.split(",", 2);
            String[] instances = instancePart[0].split("\\|", 2);
            if (instancePart.length != 2 || instances.length != 2) {
                this.discard();
                throw new ProtocolException();
            }
            try {
                receiverInstance = Integer.parseInt(instances[1], 16);
            }
            catch (NumberFormatException e) {
                this.discard();
                throw new ProtocolException();
            }
            if (receiverInstance != 0 && receiverInstance != this.ownInstance.getValue()) {
                throw new UnknownInstanceException("Message for unknown instance tag " + String.valueOf(receiverInstance) + " received: " + msgText);
            }
            msgText = instancePart[1];
        } else {
            this.discard();
            return msgText;
        }
        String[] params = msgText.split(",", 4);
        try {
            k = Integer.parseInt(params[0]);
            n = Integer.parseInt(params[1]);
        }
        catch (NumberFormatException e) {
            this.discard();
            throw new ProtocolException();
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.discard();
            throw new ProtocolException();
        }
        if (k == 0 || n == 0 || k > n || params.length != 4 || params[3].length() != 0) {
            this.discard();
            throw new ProtocolException();
        }
        msgText = params[2];
        if (k == 1) {
            this.discard();
            this.fragmentCur = k;
            this.fragmentMax = n;
            this.fragment.append(msgText);
        } else if (n == this.fragmentMax && k == this.fragmentCur + 1) {
            ++this.fragmentCur;
            this.fragment.append(msgText);
        } else {
            this.discard();
            throw new ProtocolException();
        }
        if (n == k && n > 0) {
            String result = this.fragment.toString();
            this.discard();
            return result;
        }
        return null;
    }

    public void discard() {
        this.fragment = new StringBuffer();
        this.fragmentCur = 0;
        this.fragmentMax = 0;
    }
}

