/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.mock;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import net.java.sip.communicator.impl.protocol.mock.MockChatRoom;
import net.java.sip.communicator.impl.protocol.mock.MockProvider;
import net.java.sip.communicator.service.protocol.AbstractOperationSetMultiUserChat;
import net.java.sip.communicator.service.protocol.ChatRoom;
import net.java.sip.communicator.service.protocol.ChatRoomInvitation;
import net.java.sip.communicator.service.protocol.ChatRoomMember;
import net.java.sip.communicator.service.protocol.Contact;
import net.java.sip.communicator.service.protocol.OperationFailedException;
import net.java.sip.communicator.service.protocol.OperationNotSupportedException;

public class MockMultiUserChat
extends AbstractOperationSetMultiUserChat {
    private MockProvider provider = null;
    private final List<ChatRoom> existingChatRooms = new Vector<ChatRoom>();
    private final List<ChatRoom> joinedChatRooms = new Vector<ChatRoom>();

    public MockMultiUserChat(MockProvider provider) {
        this.provider = provider;
    }

    public List<String> getExistingChatRooms() throws OperationFailedException, OperationNotSupportedException {
        ArrayList<String> existingChatRoomNames = new ArrayList<String>(this.existingChatRooms.size());
        for (ChatRoom existingChatRoom : this.existingChatRooms) {
            existingChatRoomNames.add(existingChatRoom.getName());
        }
        return existingChatRoomNames;
    }

    public List<ChatRoom> getCurrentlyJoinedChatRooms() {
        return this.joinedChatRooms;
    }

    public List<String> getCurrentlyJoinedChatRooms(ChatRoomMember chatRoomMember) throws OperationFailedException, OperationNotSupportedException {
        Vector<String> result = new Vector<String>();
        for (ChatRoom elem : this.joinedChatRooms) {
            if (!elem.getMembers().contains(chatRoomMember)) continue;
            result.add(elem.getName());
        }
        return result;
    }

    public ChatRoom createChatRoom(String roomName, Map<String, Object> roomProperties) throws OperationFailedException, OperationNotSupportedException {
        MockChatRoom room = new MockChatRoom(this.provider, this, roomName);
        this.existingChatRooms.add((ChatRoom)room);
        return room;
    }

    public ChatRoom findRoom(String roomName) throws OperationFailedException, OperationNotSupportedException {
        for (ChatRoom elem : this.existingChatRooms) {
            if (!elem.getName().equals(roomName)) continue;
            return elem;
        }
        return null;
    }

    public void rejectInvitation(ChatRoomInvitation invitation, String reason) {
        this.fireInvitationRejectedEvent(invitation.getTargetChatRoom(), this.provider.getAccountID().getUserID(), invitation.getReason());
    }

    public boolean isMultiChatSupportedByContact(Contact contact) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean isPrivateMessagingContact(String contactAddress) {
        return false;
    }
}

