/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.gui.main.authorization;

import javax.swing.SwingUtilities;
import net.java.sip.communicator.impl.gui.GuiActivator;
import net.java.sip.communicator.impl.gui.main.MainFrame;
import net.java.sip.communicator.impl.gui.main.authorization.AuthorizationRequestedDialog;
import net.java.sip.communicator.impl.gui.main.authorization.AuthorizationResponseDialog;
import net.java.sip.communicator.impl.gui.main.authorization.RequestAuthorizationDialog;
import net.java.sip.communicator.impl.gui.main.contactlist.ContactListUtils;
import net.java.sip.communicator.service.contactlist.event.MetaContactEvent;
import net.java.sip.communicator.service.contactlist.event.MetaContactListAdapter;
import net.java.sip.communicator.service.contactlist.event.MetaContactListListener;
import net.java.sip.communicator.service.protocol.AuthorizationHandler;
import net.java.sip.communicator.service.protocol.AuthorizationRequest;
import net.java.sip.communicator.service.protocol.AuthorizationResponse;
import net.java.sip.communicator.service.protocol.Contact;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;

public class AuthorizationHandlerImpl
implements AuthorizationHandler {
    private MainFrame mainFrame;

    public AuthorizationHandlerImpl(MainFrame mainFrame) {
        this.mainFrame = mainFrame;
    }

    public AuthorizationResponse processAuthorisationRequest(AuthorizationRequest req, Contact sourceContact) {
        AuthorizationResponse response = null;
        AuthorizationRequestedDialog dialog = null;
        if (!SwingUtilities.isEventDispatchThread()) {
            ProcessAuthorizationRequestRunnable runnable;
            block11: {
                runnable = new ProcessAuthorizationRequestRunnable(sourceContact, req);
                try {
                    SwingUtilities.invokeAndWait(runnable);
                }
                catch (Throwable t) {
                    if (dialog != null) break block11;
                    runnable.run();
                }
            }
            dialog = runnable.getDialog();
        } else {
            dialog = this.createAndShowAuthorizationRequestDialog(sourceContact, req);
        }
        int result = dialog.getReturnCode();
        if (result == 0) {
            response = new AuthorizationResponse(AuthorizationResponse.ACCEPT, null);
            if (dialog.isAddContact()) {
                if (!sourceContact.getAddress().equals(sourceContact.getDisplayName())) {
                    this.addRenameListener(sourceContact.getProtocolProvider(), sourceContact.getAddress(), sourceContact.getDisplayName());
                }
                ContactListUtils.addContact(sourceContact.getProtocolProvider(), dialog.getSelectedMetaContactGroup(), sourceContact.getAddress());
            }
        } else if (result == 1) {
            response = new AuthorizationResponse(AuthorizationResponse.REJECT, null);
        } else if (result == 2) {
            response = new AuthorizationResponse(AuthorizationResponse.IGNORE, null);
        }
        return response;
    }

    private AuthorizationRequestedDialog createAndShowAuthorizationRequestDialog(Contact contact, AuthorizationRequest request) {
        AuthorizationRequestedDialog dialog = new AuthorizationRequestedDialog(this.mainFrame, contact, request);
        dialog.showDialog();
        return dialog;
    }

    public AuthorizationRequest createAuthorizationRequest(Contact contact) {
        AuthorizationRequest request = new AuthorizationRequest();
        RequestAuthorizationDialog dialog = null;
        if (!SwingUtilities.isEventDispatchThread()) {
            RequestAuthorizationRunnable runnable;
            block6: {
                runnable = new RequestAuthorizationRunnable(contact, request);
                try {
                    SwingUtilities.invokeAndWait(runnable);
                }
                catch (Throwable t) {
                    if (dialog != null) break block6;
                    runnable.run();
                }
            }
            dialog = runnable.getDialog();
        } else {
            dialog = this.createAndShowRequestAuthorizationDialog(contact, request);
        }
        int returnCode = dialog.getReturnCode();
        if (returnCode == 1) {
            request.setReason(dialog.getRequestReason());
        } else {
            request = null;
        }
        return request;
    }

    private RequestAuthorizationDialog createAndShowRequestAuthorizationDialog(Contact contact, AuthorizationRequest request) {
        RequestAuthorizationDialog dialog = new RequestAuthorizationDialog(this.mainFrame, contact, request);
        dialog.showDialog();
        return dialog;
    }

    public void processAuthorizationResponse(final AuthorizationResponse response, final Contact sourceContact) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    AuthorizationHandlerImpl.this.processAuthorizationResponse(response, sourceContact);
                }
            });
            return;
        }
        AuthorizationResponseDialog dialog = new AuthorizationResponseDialog(this.mainFrame, sourceContact, response);
        dialog.setVisible(true);
    }

    private void addRenameListener(final ProtocolProviderService protocolProvider, final String contactAddress, final String displayName) {
        GuiActivator.getContactListService().addMetaContactListListener((MetaContactListListener)new MetaContactListAdapter(){

            public void metaContactAdded(final MetaContactEvent evt) {
                if (evt.getSourceMetaContact().getContact(contactAddress, protocolProvider) != null && contactAddress.equals(evt.getSourceMetaContact().getDisplayName())) {
                    new Thread(){

                        @Override
                        public void run() {
                            GuiActivator.getContactListService().renameMetaContact(evt.getSourceMetaContact(), displayName);
                        }
                    }.start();
                }
            }
        });
    }

    private class ProcessAuthorizationRequestRunnable
    implements Runnable {
        private final Contact contact;
        private final AuthorizationRequest request;
        private AuthorizationRequestedDialog dialog;

        private ProcessAuthorizationRequestRunnable(Contact contact, AuthorizationRequest request) {
            this.contact = contact;
            this.request = request;
        }

        @Override
        public void run() {
            this.dialog = AuthorizationHandlerImpl.this.createAndShowAuthorizationRequestDialog(this.contact, this.request);
        }

        public AuthorizationRequestedDialog getDialog() {
            return this.dialog;
        }
    }

    private class RequestAuthorizationRunnable
    implements Runnable {
        private final Contact contact;
        private final AuthorizationRequest request;
        private RequestAuthorizationDialog dialog;

        private RequestAuthorizationRunnable(Contact contact, AuthorizationRequest request) {
            this.contact = contact;
            this.request = request;
        }

        @Override
        public void run() {
            this.dialog = AuthorizationHandlerImpl.this.createAndShowRequestAuthorizationDialog(this.contact, this.request);
        }

        public RequestAuthorizationDialog getDialog() {
            return this.dialog;
        }
    }
}

