/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.gui.main.call;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JToggleButton;
import net.java.sip.communicator.impl.gui.GuiActivator;
import net.java.sip.communicator.impl.gui.main.call.CallPanel;
import net.java.sip.communicator.impl.gui.main.call.LocalVideoButton;
import net.java.sip.communicator.impl.gui.utils.ImageLoader;
import net.java.sip.communicator.plugin.desktoputil.ImageUtils;
import net.java.sip.communicator.plugin.desktoputil.SIPCommToggleButton;
import net.java.sip.communicator.service.protocol.Call;
import net.java.sip.communicator.service.resources.ImageID;
import net.java.sip.communicator.util.skin.Skinnable;

public abstract class AbstractCallToggleButton
extends SIPCommToggleButton
implements Skinnable {
    protected ImageID bgImageID;
    protected ImageID bgRolloverImageID;
    protected final Call call;
    private CallPanel callPanel;
    private final PropertyChangeListener callPanelPropertyChangeListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent ev) {
            AbstractCallToggleButton.this.callPanelPropertyChange(ev);
        }
    };
    private boolean fullScreen = false;
    protected ImageID iconImageID;
    protected ImageID pressedIconImageID;
    protected ImageID pressedImageID;
    private final boolean settingsPanel;
    private boolean spawnActionInNewThread = true;

    protected AbstractCallToggleButton(Call call, boolean settingsPanel, boolean selected, ImageID iconImageID, ImageID pressedIconImageID, String toolTipTextKey) {
        this.call = call;
        this.iconImageID = iconImageID;
        this.pressedIconImageID = pressedIconImageID;
        this.settingsPanel = settingsPanel;
        if (settingsPanel) {
            this.bgRolloverImageID = ImageLoader.CALL_SETTING_BUTTON_BG;
            this.pressedImageID = ImageLoader.CALL_SETTING_BUTTON_PRESSED_BG;
        } else {
            this.bgImageID = ImageLoader.SOUND_SETTING_BUTTON_BG;
            this.bgRolloverImageID = ImageLoader.SOUND_SETTING_BUTTON_BG;
            this.pressedImageID = ImageLoader.SOUND_SETTING_BUTTON_PRESSED;
        }
        if (toolTipTextKey != null) {
            this.setToolTipText(GuiActivator.getResources().getI18NString(toolTipTextKey));
        }
        this.setModel(new CallToggleButtonModel(call));
        this.addHierarchyListener(new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent ev) {
                AbstractCallToggleButton.this.hierarchyChanged(ev);
            }
        });
        this.hierarchyChanged(null);
        this.setSelected(selected);
        this.loadSkin();
    }

    protected AbstractCallToggleButton(Call call, boolean selected, ImageID iconImageID, String toolTipTextKey) {
        this(call, true, selected, iconImageID, null, toolTipTextKey);
    }

    public abstract void buttonPressed();

    private void callPanelPropertyChange(PropertyChangeEvent ev) {
        if (ev == null || "fullScreen".equals(ev.getPropertyName())) {
            boolean fullScreen;
            boolean bl = fullScreen = this.callPanel == null ? false : this.callPanel.isFullScreen();
            if (this.fullScreen != fullScreen) {
                this.fullScreen = fullScreen;
                this.loadSkin();
            }
        }
    }

    private void hierarchyChanged(HierarchyEvent ev) {
        CallPanel callPanel = null;
        for (Container parent = this.getParent(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof CallPanel)) continue;
            callPanel = (CallPanel)((Object)parent);
            break;
        }
        if (this.callPanel != callPanel) {
            if (this.callPanel != null) {
                this.callPanel.removePropertyChangeListener("fullScreen", this.callPanelPropertyChangeListener);
            }
            this.callPanel = callPanel;
            if (this.callPanel != null) {
                this.callPanel.addPropertyChangeListener("fullScreen", this.callPanelPropertyChangeListener);
            }
            this.callPanelPropertyChange(null);
        }
    }

    protected boolean isFullScreen() {
        return this.fullScreen;
    }

    public void loadSkin() {
        Image iconImage;
        int width = 44;
        int height = 38;
        if (this.bgImageID != null) {
            BufferedImage bgImage = ImageLoader.getImage(this.bgImageID);
            this.setBgImage(bgImage);
            width = ((Image)bgImage).getWidth((ImageObserver)((Object)this));
            height = ((Image)bgImage).getHeight((ImageObserver)((Object)this));
        }
        this.setPreferredSize(new Dimension(width, height));
        this.setMaximumSize(new Dimension(width, height));
        this.setMinimumSize(new Dimension(width, height));
        this.setBgRolloverImage(ImageLoader.getImage(this.bgRolloverImageID));
        this.setPressedImage(ImageLoader.getImage(this.pressedImageID));
        boolean fullScreen = this.isFullScreen();
        if (this.iconImageID != null) {
            iconImage = ImageLoader.getImage(this.iconImageID);
            if (!fullScreen && !this.settingsPanel) {
                iconImage = ImageUtils.scaleImageWithinBounds((Image)iconImage, (int)18, (int)18);
            }
            this.setIconImage(iconImage);
        }
        if (this.pressedIconImageID != null) {
            iconImage = ImageLoader.getImage(this.pressedIconImageID);
            if (!fullScreen && !this.settingsPanel) {
                iconImage = ImageUtils.scaleImageWithinBounds((Image)iconImage, (int)18, (int)18);
            }
            this.setPressedIconImage(iconImage);
        }
    }

    public void setIconImageID(ImageID iconImageID) {
        this.iconImageID = iconImageID;
        Image iconImage = ImageLoader.getImage(iconImageID);
        if (!this.isFullScreen() && !this.settingsPanel) {
            iconImage = ImageUtils.scaleImageWithinBounds((Image)iconImage, (int)18, (int)18);
        }
        this.setIconImage(iconImage);
    }

    public void setSpawnActionInNewThread(boolean spawnActionInNewThread) {
        this.spawnActionInNewThread = spawnActionInNewThread;
    }

    private class CallToggleButtonModel
    extends JToggleButton.ToggleButtonModel
    implements ActionListener,
    Runnable {
        private Thread runner;

        public CallToggleButtonModel(Call call) {
            this.addActionListener(this);
        }

        @Override
        public synchronized void actionPerformed(ActionEvent event) {
            if (AbstractCallToggleButton.this.spawnActionInNewThread) {
                if (this.runner == null) {
                    this.runner = new Thread((Runnable)this, LocalVideoButton.class.getName());
                    this.runner.setDaemon(true);
                    this.setEnabled(false);
                    this.runner.start();
                }
            } else {
                AbstractCallToggleButton.this.buttonPressed();
            }
        }

        private void doRun() {
            AbstractCallToggleButton.this.buttonPressed();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                this.doRun();
            }
            finally {
                CallToggleButtonModel callToggleButtonModel = this;
                synchronized (callToggleButtonModel) {
                    if (Thread.currentThread().equals(this.runner)) {
                        this.runner = null;
                        this.setEnabled(true);
                    }
                }
            }
        }
    }
}

