/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.jabber;

import java.util.Hashtable;
import java.util.Timer;
import java.util.TimerTask;
import net.java.sip.communicator.impl.protocol.jabber.JabberActivator;
import net.java.sip.communicator.impl.protocol.jabber.ProtocolProviderServiceJabberImpl;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import net.java.sip.communicator.service.protocol.RegistrationState;
import net.java.sip.communicator.service.protocol.event.RegistrationStateChangeEvent;
import net.java.sip.communicator.service.protocol.event.RegistrationStateChangeListener;
import net.java.sip.communicator.util.Logger;
import net.java.sip.communicator.util.NetworkUtils;
import net.java.sip.communicator.util.SRVRecord;
import org.jivesoftware.smack.ConnectionConfiguration;
import org.jivesoftware.smack.XMPPConnection;

public class FailoverConnectionMonitor
implements RegistrationStateChangeListener {
    public static final String REVERSE_FAILOVER_ENABLED_PROP = "net.java.sip.communicator.impl.protocol.jabber.REVERSE_FAILOVER_ENABLED";
    public static final String FAILOVER_CHECK_INTERVAL_PROP = "net.java.sip.communicator.impl.protocol.jabber.FAILOVER_CHECK_INTERVAL";
    private static final Logger logger = Logger.getLogger(FailoverConnectionMonitor.class);
    private ProtocolProviderServiceJabberImpl parentProvider;
    private static Hashtable<ProtocolProviderServiceJabberImpl, FailoverConnectionMonitor> providerFilovers = new Hashtable();
    private Timer checkTimer;
    private CheckPrimaryTask task;
    private static int CHECK_FOR_PRIMARY_UP_INTERVAL = 60000;
    private String currentAddress;
    private String serviceName;

    private FailoverConnectionMonitor(ProtocolProviderServiceJabberImpl provider) {
        this.parentProvider = provider;
        this.parentProvider.addRegistrationStateChangeListener(this);
        CHECK_FOR_PRIMARY_UP_INTERVAL = JabberActivator.getConfigurationService().getInt(FAILOVER_CHECK_INTERVAL_PROP, CHECK_FOR_PRIMARY_UP_INTERVAL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FailoverConnectionMonitor getInstance(ProtocolProviderServiceJabberImpl provider) {
        FailoverConnectionMonitor fov;
        Hashtable<ProtocolProviderServiceJabberImpl, FailoverConnectionMonitor> hashtable = providerFilovers;
        synchronized (hashtable) {
            fov = providerFilovers.get((Object)provider);
            if (fov == null) {
                fov = new FailoverConnectionMonitor(provider);
                providerFilovers.put(provider, fov);
            }
        }
        return fov;
    }

    void setCurrent(String serviceName, String currentAddress) {
        this.currentAddress = currentAddress;
        this.serviceName = serviceName;
    }

    private boolean isConnectedToPrimary(SRVRecord[] recs) {
        String primaryAddress = this.getPrimaryServerRecord(recs).getTarget();
        return primaryAddress != null && primaryAddress.equals(this.currentAddress);
    }

    private SRVRecord getPrimaryServerRecord(SRVRecord[] recs) {
        if (recs.length >= 1) {
            SRVRecord primary = recs[0];
            for (SRVRecord srv : recs) {
                if (srv.getPriority() >= primary.getPriority()) continue;
                primary = srv;
            }
            return primary;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registrationStateChanged(RegistrationStateChangeEvent evt) {
        if (evt.getNewState() == RegistrationState.REGISTERED) {
            if (this.checkTimer == null) {
                this.checkTimer = new Timer(FailoverConnectionMonitor.class.getName(), true);
            }
            if (this.task == null) {
                this.task = new CheckPrimaryTask();
            }
            this.checkTimer.schedule((TimerTask)this.task, CHECK_FOR_PRIMARY_UP_INTERVAL, (long)CHECK_FOR_PRIMARY_UP_INTERVAL);
        } else if (evt.getNewState() == RegistrationState.UNREGISTERED || evt.getNewState() == RegistrationState.AUTHENTICATION_FAILED || evt.getNewState() == RegistrationState.CONNECTION_FAILED) {
            Hashtable<ProtocolProviderServiceJabberImpl, FailoverConnectionMonitor> hashtable = providerFilovers;
            synchronized (hashtable) {
                providerFilovers.remove((Object)this.parentProvider);
                this.parentProvider.removeRegistrationStateChangeListener(this);
            }
            if (this.checkTimer != null) {
                this.checkTimer.cancel();
                this.checkTimer = null;
            }
            if (this.task != null) {
                this.task.cancel();
                this.task = null;
            }
        }
    }

    private class CheckPrimaryTask
    extends TimerTask {
        private CheckPrimaryTask() {
        }

        @Override
        public void run() {
            try {
                SRVRecord[] currentRecords = NetworkUtils.getSRVRecords((String)"xmpp-client", (String)"tcp", (String)FailoverConnectionMonitor.this.serviceName, (boolean)false);
                if (FailoverConnectionMonitor.this.isConnectedToPrimary(currentRecords)) {
                    return;
                }
                NetworkUtils.clearDefaultDNSCache();
                SRVRecord srv = FailoverConnectionMonitor.this.getPrimaryServerRecord(currentRecords);
                ConnectionConfiguration confConn = new ConnectionConfiguration(srv.getTarget(), srv.getPort());
                confConn.setReconnectionAllowed(false);
                XMPPConnection connection = new XMPPConnection(confConn);
                connection.connect();
                connection.disconnect();
                try {
                    FailoverConnectionMonitor.this.parentProvider.unregister();
                }
                catch (Throwable t) {
                    logger.error((Object)"Error un-registering before connecting to primary", t);
                }
                FailoverConnectionMonitor.this.parentProvider.register(JabberActivator.getUIService().getDefaultSecurityAuthority((ProtocolProviderService)FailoverConnectionMonitor.this.parentProvider));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

