/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd.icq;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.kano.joscar.flapcmd.SnacCommand;
import net.kano.joscar.flapcmd.SnacPacket;
import net.kano.joscar.snac.CmdType;
import net.kano.joscar.snac.SnacCmdFactory;
import net.kano.joscar.snaccmd.icq.AbstractIcqCmd;
import net.kano.joscar.snaccmd.icq.IcqType;
import net.kano.joscar.snaccmd.icq.MetaFullInfoRequest;
import net.kano.joscar.snaccmd.icq.MetaShortInfoRequest;
import net.kano.joscar.snaccmd.icq.OfflineMsgIcqAckCmd;
import net.kano.joscar.snaccmd.icq.OfflineMsgIcqRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerIcqCmdFactory
implements SnacCmdFactory {
    private static final List<CmdType> SUPPORTED_TYPES = Collections.unmodifiableList(Arrays.asList(new CmdType(21, 2)));

    @Override
    public List<CmdType> getSupportedTypes() {
        return SUPPORTED_TYPES;
    }

    @Override
    public SnacCommand genSnacCommand(SnacPacket packet) {
        if (packet.getFamily() != 21) {
            return null;
        }
        int command = packet.getCommand();
        if (command == 2) {
            IcqType type = AbstractIcqCmd.readIcqType(packet);
            if (type.equals(AbstractIcqCmd.CMD_META_SHORT_INFO_REQ)) {
                return new MetaShortInfoRequest(packet);
            }
            if (type.equals(AbstractIcqCmd.CMD_META_FULL_INFO_REQ)) {
                return new MetaFullInfoRequest(packet);
            }
            if (type.equals(AbstractIcqCmd.CMD_OFFLINE_MSG_REQ)) {
                return new OfflineMsgIcqRequest(packet);
            }
            if (type.equals(AbstractIcqCmd.CMD_OFFLINE_MSG_ACK)) {
                return new OfflineMsgIcqAckCmd(packet);
            }
        }
        return null;
    }
}

