/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.ssiitem;

import net.kano.joscar.BinaryTools;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.snaccmd.ssi.SsiItem;
import net.kano.joscar.ssiitem.AbstractItemObj;
import net.kano.joscar.ssiitem.SsiItemObjectWithId;
import net.kano.joscar.tlv.ImmutableTlvChain;
import net.kano.joscar.tlv.MutableTlvChain;
import net.kano.joscar.tlv.Tlv;
import net.kano.joscar.tlv.TlvChain;
import net.kano.joscar.tlv.TlvTools;

public class BuddyItem
extends AbstractItemObj
implements SsiItemObjectWithId {
    public static final int MASK_ACTION_POPUP = 1;
    public static final int MASK_ACTION_PLAY_SOUND = 2;
    public static final int MASK_WHEN_ONLINE = 1;
    public static final int MASK_WHEN_UNIDLE = 2;
    public static final int MASK_WHEN_UNAWAY = 4;
    private static final int TYPE_ALIAS = 305;
    private static final int TYPE_COMMENT = 316;
    private static final int TYPE_ALERT_SOUND = 318;
    private static final int TYPE_ALERT_FLAGS = 317;
    private static final int TYPE_AWAITING_AUTH = 102;
    private final String sn;
    private int groupid;
    private int id;
    private String alias;
    private String comment;
    private int alertActionMask;
    private int alertWhenMask;
    private String alertSound;
    private boolean awaitingAuth;

    public BuddyItem(SsiItem item) {
        DefensiveTools.checkNull(item, "item");
        this.sn = item.getName();
        this.groupid = item.getParentId();
        this.id = item.getId();
        ImmutableTlvChain chain = TlvTools.readChain(item.getData());
        this.alias = chain.getUtf8String(305);
        this.comment = chain.getUtf8String(316);
        this.alertSound = chain.getString(318);
        Tlv alertTlv = chain.getLastTlv(317);
        if (alertTlv != null) {
            ByteBlock alertMaskData = alertTlv.getData();
            this.alertActionMask = BinaryTools.getUByte(alertMaskData, 0);
            this.alertWhenMask = BinaryTools.getUByte(alertMaskData, 1);
            if (this.alertActionMask == -1) {
                this.alertActionMask = 0;
            }
            if (this.alertWhenMask == -1) {
                this.alertWhenMask = 0;
            }
        } else {
            this.alertActionMask = 0;
            this.alertWhenMask = 0;
        }
        this.awaitingAuth = chain.hasTlv(102);
        MutableTlvChain extraTlvs = TlvTools.getMutableCopy(chain);
        this.addExtraTlvs(extraTlvs);
    }

    public BuddyItem(BuddyItem other) {
        this(other.sn, other.getGroupId(), other.getId(), other.getAlias(), other.getBuddyComment(), other.alertWhenMask, other.alertActionMask, other.alertSound, other.awaitingAuth, other.copyExtraTlvs());
    }

    public BuddyItem(String sn, int groupid, int id) {
        this(sn, groupid, id, null, null, 0, 0, null);
    }

    public BuddyItem(String sn, int groupid, int id, String alias, String comment, int alertWhenMask, int alertActionMask, String alertSound) {
        this(sn, groupid, id, alias, comment, alertWhenMask, alertActionMask, alertSound, false, null);
    }

    public BuddyItem(String sn, int groupid, int id, String alias, String comment, int alertWhenMask, int alertActionMask, String alertSound, boolean awaitingAuth, TlvChain extraTlvs) {
        super(extraTlvs);
        DefensiveTools.checkNull(sn, "sn");
        DefensiveTools.checkRange(groupid, "groupid", 0);
        DefensiveTools.checkRange(id, "id", 0);
        DefensiveTools.checkRange(alertWhenMask, "alertWhenMask", 0);
        DefensiveTools.checkRange(alertActionMask, "alertActionMask", 0);
        this.sn = sn;
        this.groupid = groupid;
        this.id = id;
        this.alias = alias;
        this.comment = comment;
        this.alertActionMask = alertActionMask;
        this.alertWhenMask = alertWhenMask;
        this.alertSound = alertSound;
        this.awaitingAuth = awaitingAuth;
    }

    public final String getScreenname() {
        return this.sn;
    }

    public final synchronized int getGroupId() {
        return this.groupid;
    }

    public final synchronized int getId() {
        return this.id;
    }

    public final synchronized String getAlias() {
        return this.alias;
    }

    public final synchronized String getBuddyComment() {
        return this.comment;
    }

    public final synchronized int getAlertActionMask() {
        return this.alertActionMask;
    }

    public final synchronized int getAlertWhenMask() {
        return this.alertWhenMask;
    }

    public final synchronized String getAlertSound() {
        return this.alertSound;
    }

    public synchronized boolean isAwaitingAuth() {
        return this.awaitingAuth;
    }

    public synchronized void setGroupid(int groupid) {
        this.groupid = groupid;
    }

    public synchronized void setId(int id) {
        this.id = id;
    }

    public final synchronized void setAlias(String alias) {
        this.alias = alias;
    }

    public final synchronized void setComment(String comment) {
        this.comment = comment;
    }

    public final synchronized void setAlertActionMask(int alertActionMask) {
        this.alertActionMask = alertActionMask;
    }

    public final synchronized void setAlertWhenMask(int alertWhenMask) {
        this.alertWhenMask = alertWhenMask;
    }

    public final synchronized void setAlertSound(String alertSound) {
        this.alertSound = alertSound;
    }

    public synchronized void setAwaitingAuth(boolean awaitingAuth) {
        this.awaitingAuth = awaitingAuth;
    }

    public synchronized SsiItem toSsiItem() {
        MutableTlvChain chain = (MutableTlvChain)this.copyExtraTlvs();
        if (this.alias != null) {
            chain.replaceTlv(Tlv.getUtf8Instance(305, this.alias));
        } else {
            chain.removeTlvs(305);
        }
        if (this.comment != null) {
            chain.replaceTlv(Tlv.getUtf8Instance(316, this.comment));
        } else {
            chain.removeTlvs(316);
        }
        if (this.alertActionMask != 0 || this.alertWhenMask != 0) {
            ByteBlock block = ByteBlock.wrap(new byte[]{BinaryTools.getUByte(this.alertActionMask)[0], BinaryTools.getUByte(this.alertWhenMask)[0]});
            chain.replaceTlv(new Tlv(317, block));
        } else {
            chain.removeTlvs(317);
        }
        if (this.alertSound != null) {
            chain.replaceTlv(Tlv.getStringInstance(318, this.alertSound));
        } else {
            chain.removeTlvs(318);
        }
        if (this.awaitingAuth) {
            chain.replaceTlv(new Tlv(102));
        } else {
            chain.removeTlvs(102);
        }
        return new SsiItem(this.sn, this.groupid, this.id, 0, ByteBlock.createByteBlock(chain));
    }

    public synchronized String toString() {
        boolean popupAlert = (this.alertActionMask & 1) != 0;
        boolean playSound = (this.alertActionMask & 2) != 0;
        boolean alertOnSignon = (this.alertWhenMask & 1) != 0;
        boolean alertOnUnidle = (this.alertWhenMask & 2) != 0;
        boolean alertOnBack = (this.alertWhenMask & 4) != 0;
        return "BuddyItem for " + this.sn + " (buddy 0x" + Integer.toHexString(this.id) + " in group 0x" + Integer.toHexString(this.groupid) + "): " + (this.awaitingAuth ? "awaiting auth - " : "") + "alias=" + this.alias + ", comment=\"" + this.comment + "\", alerts: " + (popupAlert ? "[popup alert] " : "") + (playSound ? "[play " + this.alertSound + "] " : "") + (alertOnSignon ? "[on signon] " : "") + (alertOnUnidle ? "[on unidle] " : "") + (alertOnBack ? "[on unaway] " : "");
    }
}

