/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joustsim.oscar.oscar.service.icbm;

import java.util.Collection;
import net.kano.joscar.BinaryTools;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.snaccmd.ExtraInfoBlock;
import net.kano.joscar.snaccmd.icbm.InstantMessage;
import net.kano.joscar.snaccmd.icbm.RecvImIcbm;
import net.kano.joustsim.oscar.oscar.service.icbm.SimpleMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicInstantMessage
extends SimpleMessage {
    private final String aimexp;

    static BasicInstantMessage getInstance(RecvImIcbm icbm) {
        InstantMessage message = icbm.getMessage();
        if (message == null) {
            return null;
        }
        String msg = message.getMessage();
        if (msg == null) {
            return null;
        }
        boolean ar = icbm.isAutoResponse();
        String aimexp = BasicInstantMessage.extractAimExpressionName(icbm.getAimExpressionInfo());
        return new BasicInstantMessage(msg, ar, aimexp);
    }

    private static String extractAimExpressionName(Collection<? extends ExtraInfoBlock> aimexpInfo) {
        if (aimexpInfo == null) {
            return null;
        }
        String aimexp = null;
        for (ExtraInfoBlock extraInfoBlock : aimexpInfo) {
            ByteBlock data;
            int blockType = extraInfoBlock.getType();
            if (blockType != 128 && blockType != 130 || (data = extraInfoBlock.getExtraData().getData()).getLength() <= 1) continue;
            aimexp = BinaryTools.getAsciiString(data.subBlock(1));
            break;
        }
        return aimexp;
    }

    public BasicInstantMessage(String messageBody) {
        this(messageBody, false);
    }

    public BasicInstantMessage(String messageBody, boolean autoResponse) {
        this(messageBody, autoResponse, null);
    }

    public BasicInstantMessage(String msg, boolean ar, String aimexp) {
        super(msg, ar);
        this.aimexp = aimexp;
    }

    public final String getAimexp() {
        return this.aimexp;
    }
}

