/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.skinmanager;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.zip.ZipFile;
import net.java.sip.communicator.plugin.desktoputil.GenericFileDialog;
import net.java.sip.communicator.plugin.desktoputil.SipCommFileChooser;
import net.java.sip.communicator.plugin.desktoputil.SipCommFileFilter;
import net.java.sip.communicator.plugin.skinmanager.Resources;
import net.java.sip.communicator.plugin.skinmanager.SkinManagerActivator;
import net.java.sip.communicator.plugin.skinmanager.SkinSelector;
import net.java.sip.communicator.util.Logger;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;

public class SkinSelectionListener
implements ActionListener {
    private Logger logger = Logger.getLogger(SkinSelectionListener.class);
    private Object current = null;
    private boolean suppressed = false;

    @Override
    public void actionPerformed(ActionEvent e) {
        SkinSelector selector;
        block25: {
            selector = (SkinSelector)e.getSource();
            if (this.current != null && this.current.equals(selector.getSelectedItem())) {
                return;
            }
            if (this.suppressed) {
                this.current = selector.getSelectedItem();
                return;
            }
            if (selector.getSelectedItem() instanceof String) {
                String selectedItem = (String)selector.getSelectedItem();
                if (selectedItem.equals(SkinSelector.ADD_TEXT)) {
                    selector.hidePopup();
                    SipCommFileChooser chooser = this.createFileChooser();
                    File newBundleFile = chooser.getFileFromDialog();
                    if (newBundleFile != null) {
                        try {
                            File jar = null;
                            try {
                                jar = Resources.getResources().prepareSkinBundleFromZip(newBundleFile);
                            }
                            catch (Exception ex) {
                                this.logger.info((Object)"Failed to load skin from zip.", (Throwable)ex);
                                SkinManagerActivator.getUIService().getPopupDialog().showMessagePopupDialog((Object)(ex.getClass() + ": " + ex.getMessage()), "Error", 0);
                            }
                            if (jar == null) break block25;
                            try {
                                Bundle newBundle = SkinManagerActivator.bundleContext.installBundle(jar.toURI().toURL().toString());
                                selector.selectNoSkin();
                                newBundle.start();
                            }
                            catch (MalformedURLException ex) {
                                this.logger.info((Object)"Failed to load skin from zip.", (Throwable)ex);
                            }
                        }
                        catch (BundleException ex) {
                            this.logger.info((Object)"Failed to install bundle.", (Throwable)ex);
                            SkinManagerActivator.getUIService().getPopupDialog().showMessagePopupDialog((Object)ex.getMessage(), "Error", 0);
                        }
                        catch (Throwable ex) {
                            this.logger.info((Object)"Failed to install bundle.", ex);
                        }
                    } else if (this.current != null) {
                        selector.setSelectedItem(this.current);
                    } else {
                        selector.setSelectedIndex(0);
                    }
                } else if (selectedItem.equals(SkinSelector.DEFAULT_TEXT)) {
                    selector.selectNoSkin();
                } else if (selectedItem.equals("separator")) {
                    if (this.current != null) {
                        selector.setSelectedItem(this.current);
                    } else {
                        selector.setSelectedIndex(0);
                    }
                }
            } else if (selector.getSelectedItem() instanceof Bundle) {
                Bundle select = (Bundle)selector.getSelectedItem();
                selector.selectNoSkin();
                try {
                    select.start();
                }
                catch (BundleException bundleException) {
                    // empty catch block
                }
            }
        }
        this.current = selector.getSelectedItem();
    }

    public void suppressAction(boolean supp) {
        this.suppressed = supp;
    }

    private SipCommFileChooser createFileChooser() {
        SipCommFileChooser chooser = GenericFileDialog.create(null, (String)"New bundle...", (int)0);
        chooser.addFilter(new SipCommFileFilter(){

            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                boolean good = true;
                try {
                    new ZipFile(f);
                }
                catch (IOException ex) {
                    good = false;
                }
                if (!f.getName().toLowerCase().endsWith(".zip")) {
                    good = false;
                }
                return good;
            }

            public String getDescription() {
                return "Zip files (*.zip)";
            }
        });
        return chooser;
    }
}

