/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.rtp;

import java.awt.Component;
import javax.media.Buffer;
import javax.media.control.JitterBufferControl;
import javax.media.protocol.PushBufferStream;
import net.sf.fmj.media.Log;
import net.sf.fmj.media.protocol.rtp.DataSource;
import net.sf.fmj.media.rtp.RTPSessionMgr;
import net.sf.fmj.media.rtp.RTPSourceStream;
import net.sf.fmj.media.rtp.RTPStats;
import net.sf.fmj.media.rtp.SSRCInfo;

class JitterBufferStats
implements JitterBufferControl {
    private int discardedFull;
    private int discardedLate;
    private int discardedReset;
    private int discardedShrink;
    private int discardedVeryLate;
    private int maxSizeReached;
    private int nbAdd;
    private int nbGrow;
    private int nbReset;
    private int sizePerPacket;
    private final RTPSourceStream stream;

    JitterBufferStats(RTPSourceStream stream) {
        this.stream = stream;
    }

    @Override
    public int getAbsoluteMaximumDelay() {
        return this.stream.getBehaviour().getAbsoluteMaximumDelay();
    }

    @Override
    public Component getControlComponent() {
        return null;
    }

    @Override
    public int getCurrentDelayMs() {
        return this.getCurrentDelayPackets() * 20;
    }

    @Override
    public int getCurrentDelayPackets() {
        return this.getCurrentSizePackets() / 2;
    }

    @Override
    public int getCurrentPacketCount() {
        return this.stream.q.getFillCount();
    }

    @Override
    public int getCurrentSizePackets() {
        return this.stream.q.getCapacity();
    }

    @Override
    public int getDiscarded() {
        return this.getDiscardedFull() + this.getDiscardedLate() + this.getDiscardedReset() + this.getDiscardedShrink() + this.getDiscardedVeryLate();
    }

    @Override
    public int getDiscardedFull() {
        return this.discardedFull;
    }

    @Override
    public int getDiscardedLate() {
        return this.discardedLate;
    }

    @Override
    public int getDiscardedReset() {
        return this.discardedReset;
    }

    @Override
    public int getDiscardedShrink() {
        return this.discardedShrink;
    }

    public int getDiscardedVeryLate() {
        return this.discardedVeryLate;
    }

    @Override
    public int getMaximumDelay() {
        return this.stream.getBehaviour().getMaximumDelay();
    }

    @Override
    public int getMaxSizeReached() {
        return this.maxSizeReached;
    }

    int getNbAdd() {
        return this.nbAdd;
    }

    @Override
    public int getNominalDelay() {
        return this.stream.getBehaviour().getNominalDelay();
    }

    int getSizePerPacket() {
        return this.sizePerPacket;
    }

    void incrementDiscardedFull() {
        ++this.discardedFull;
        this.incrementRTPStatsPDUDrop();
    }

    void incrementDiscardedLate() {
        ++this.discardedLate;
        this.incrementRTPStatsPDUDrop();
    }

    void incrementDiscardedReset() {
        ++this.discardedReset;
        this.incrementRTPStatsPDUDrop();
    }

    void incrementDiscardedShrink() {
        ++this.discardedShrink;
        this.incrementRTPStatsPDUDrop();
    }

    void incrementDiscardedVeryLate() {
        ++this.discardedVeryLate;
        this.incrementRTPStatsPDUDrop();
    }

    void incrementNbAdd() {
        ++this.nbAdd;
    }

    void incrementNbGrow() {
        ++this.nbGrow;
    }

    void incrementNbReset() {
        ++this.nbReset;
    }

    private void incrementRTPStatsPDUDrop() {
        PushBufferStream[] datasourceStreams;
        DataSource datasource = this.stream.datasource;
        if (datasource != null && (datasourceStreams = datasource.getStreams()) != null) {
            for (PushBufferStream datasourceStream : datasourceStreams) {
                RTPStats rtpstats;
                SSRCInfo ssrcinfo;
                if (datasourceStream != this.stream) continue;
                RTPSessionMgr mgr = datasource.getMgr();
                if (mgr == null || (ssrcinfo = mgr.getSSRCInfo(datasource.getSSRC())) == null || ssrcinfo.dsource != datasource || ssrcinfo.dstream != this.stream || (rtpstats = ssrcinfo.stats) == null) break;
                rtpstats.update(8);
                break;
            }
        }
    }

    @Override
    public boolean isAdaptiveBufferEnabled() {
        return this.stream.getBehaviour().isAdaptive();
    }

    void printStats() {
        String cn = RTPSourceStream.class.getName() + " ";
        Log.info(cn + "Total packets added: " + this.getNbAdd());
        Log.info(cn + "Times reset() called: " + this.nbReset);
        Log.info(cn + "Times grow() called: " + this.nbGrow);
        Log.info(cn + "Packets dropped because full: " + this.getDiscardedFull());
        Log.info(cn + "Packets dropped while shrinking: " + this.getDiscardedShrink());
        Log.info(cn + "Packets dropped because they were late: " + this.getDiscardedLate());
        Log.info(cn + "Packets dropped because they were late by more than MAX_SIZE: " + this.getDiscardedVeryLate());
        Log.info(cn + "Packets dropped in reset(): " + this.getDiscardedReset());
        Log.info(cn + "Max size reached: " + this.getMaxSizeReached());
        Log.info(cn + "Adaptive jitter buffer mode was " + (this.isAdaptiveBufferEnabled() ? "enabled" : "disabled"));
    }

    void updateMaxSizeReached() {
        int size = this.getCurrentSizePackets();
        if (this.maxSizeReached < size) {
            this.maxSizeReached = size;
        }
    }

    void updateSizePerPacket(Buffer buffer) {
        int bufferLength = buffer.getLength();
        this.sizePerPacket = this.sizePerPacket == 0 ? bufferLength : (this.sizePerPacket + bufferLength) / 2;
    }
}

