/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.workgroup.agent;

import java.util.Collection;
import org.jivesoftware.smack.Connection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smackx.workgroup.packet.AgentInfo;
import org.jivesoftware.smackx.workgroup.packet.AgentWorkgroups;

public class Agent {
    private Connection connection;
    private String workgroupJID;

    public static Collection<String> getWorkgroups(String serviceJID, String agentJID, Connection connection) throws XMPPException {
        AgentWorkgroups request = new AgentWorkgroups(agentJID);
        request.setTo(serviceJID);
        AgentWorkgroups response = (AgentWorkgroups)connection.createPacketCollectorAndSend(request).nextResultOrThrow();
        return response.getWorkgroups();
    }

    Agent(Connection connection, String workgroupJID) {
        this.connection = connection;
        this.workgroupJID = workgroupJID;
    }

    public String getUser() {
        return this.connection.getUser();
    }

    public String getName() throws XMPPException {
        AgentInfo agentInfo = new AgentInfo();
        agentInfo.setType(IQ.Type.GET);
        agentInfo.setTo(this.workgroupJID);
        agentInfo.setFrom(this.getUser());
        AgentInfo response = (AgentInfo)this.connection.createPacketCollectorAndSend(agentInfo).nextResultOrThrow();
        return response.getName();
    }

    public void setName(String newName) throws XMPPException {
        AgentInfo agentInfo = new AgentInfo();
        agentInfo.setType(IQ.Type.SET);
        agentInfo.setTo(this.workgroupJID);
        agentInfo.setFrom(this.getUser());
        agentInfo.setName(newName);
        this.connection.createPacketCollectorAndSend(agentInfo).nextResultOrThrow();
    }
}

