/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.sip;

import gov.nist.javax.sip.message.SIPMessage;
import java.util.HashMap;
import java.util.Map;
import javax.sip.Dialog;
import javax.sip.Transaction;
import net.java.sip.communicator.util.Logger;

public class SipApplicationData {
    public static final String KEY_SERVICE = "service";
    public static final String KEY_SUBSCRIPTIONS = "subscriptions";
    public static final String KEY_USER_REQUEST = "userRequest";
    private static final Logger logger = Logger.getLogger(SipApplicationData.class);
    private final Map<String, Object> storage_ = new HashMap<String, Object>();

    public static void setApplicationData(Object container, String key, Object value) {
        if (container == null) {
            logger.warn((Object)"container is null");
            return;
        }
        if (key == null) {
            logger.warn((Object)"key is null");
            return;
        }
        SipApplicationData appData = SipApplicationData.getSipApplicationData(container);
        if (appData == null) {
            appData = new SipApplicationData();
            if (container instanceof SIPMessage) {
                ((SIPMessage)container).setApplicationData((Object)appData);
            } else if (container instanceof Transaction) {
                ((Transaction)container).setApplicationData((Object)appData);
            } else if (container instanceof Dialog) {
                ((Dialog)container).setApplicationData((Object)appData);
            } else {
                logger.error((Object)"container should be of type SIPMessage, Transaction or Dialog");
            }
        }
        appData.put(key, value);
    }

    public static Object getApplicationData(Object container, String key) {
        if (container == null) {
            logger.debug((Object)"container is null");
            return null;
        }
        if (key == null) {
            logger.warn((Object)"key is null");
            return null;
        }
        SipApplicationData appData = SipApplicationData.getSipApplicationData(container);
        if (appData == null) {
            return null;
        }
        return appData.get(key);
    }

    private void put(String key, Object value) {
        this.storage_.put(key, value);
    }

    private Object get(String key) {
        return this.storage_.get(key);
    }

    private static SipApplicationData getSipApplicationData(Object container) {
        Object appData;
        if (container instanceof SIPMessage) {
            appData = ((SIPMessage)container).getApplicationData();
        } else if (container instanceof Transaction) {
            appData = ((Transaction)container).getApplicationData();
        } else if (container instanceof Dialog) {
            appData = ((Dialog)container).getApplicationData();
        } else {
            logger.error((Object)"container should be of type SIPMessage, Transaction or Dialog");
            appData = null;
        }
        if (appData == null) {
            return null;
        }
        if (appData instanceof SipApplicationData) {
            return (SipApplicationData)appData;
        }
        logger.error((Object)"application data should be of type SipApplicationData");
        return null;
    }
}

