/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.util;

import com.google.gdata.client.authn.oauthproxy.OAuthProxyResponse;
import com.google.gdata.util.ContentType;
import com.google.gdata.util.ErrorContent;
import com.google.gdata.util.ErrorElement;
import com.google.gdata.util.ParseException;
import com.google.gdata.util.ServiceExceptionInitializer;
import com.google.gdata.util.common.base.CharEscapers;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ServiceException
extends Exception {
    int httpErrorCodeOverride = -1;
    Map<String, List<String>> httpHeaders;
    ContentType responseContentType;
    String responseBody;
    ErrorElement errorElement = new ErrorElement();
    List<ServiceException> siblings = new ArrayList<ServiceException>(1);

    public ServiceException(String message) {
        super(ServiceException.nullsafe(message));
        this.siblings.add(this);
        this.httpHeaders = new HashMap<String, List<String>>();
    }

    public ServiceException(String message, Throwable cause) {
        this(message);
        this.initCause(cause);
    }

    public ServiceException(Throwable cause) {
        this(cause.getMessage());
        this.initCause(cause);
    }

    public ServiceException(HttpURLConnection httpConn) throws IOException {
        super(ServiceException.nullsafe(httpConn.getResponseMessage()));
        this.siblings.add(this);
        ServiceExceptionInitializer initializer = new ServiceExceptionInitializer(this);
        try {
            initializer.parse(httpConn);
        }
        catch (ParseException pe) {
            this.errorElement = new ErrorElement();
            this.siblings.clear();
            this.siblings.add(this);
            this.responseContentType = ContentType.TEXT_PLAIN;
        }
    }

    public ServiceException(ErrorContent errorCode) {
        this(errorCode.getInternalReason());
        this.errorElement = new ErrorElement(errorCode);
    }

    public ServiceException(ErrorContent errorCode, Throwable cause) {
        this(errorCode);
        this.initCause(cause);
    }

    @Override
    public Throwable initCause(Throwable cause) {
        super.initCause(cause);
        if (cause instanceof ServiceException) {
            this.addSibling((ServiceException)cause);
        }
        return this;
    }

    private static String nullsafe(String src) {
        return src != null ? src : "Exception message unavailable";
    }

    public int getHttpErrorCodeOverride() {
        return this.httpErrorCodeOverride;
    }

    public void setHttpErrorCodeOverride(int v) {
        this.httpErrorCodeOverride = v;
    }

    public ContentType getResponseContentType() {
        return this.responseContentType;
    }

    public void setResponseContentType(ContentType v) {
        if (v == null) {
            throw new NullPointerException("Null content type");
        }
        this.responseContentType = v;
    }

    public String getResponseBody() {
        return this.responseBody;
    }

    public void setResponseBody(String body) {
        if (body == null) {
            throw new NullPointerException("Null response body");
        }
        this.responseBody = body;
        ServiceExceptionInitializer initializer = new ServiceExceptionInitializer(this);
        try {
            initializer.parse(this.responseContentType, this.responseBody);
        }
        catch (ParseException pe) {
            throw new RuntimeException(pe.getMessage(), pe);
        }
    }

    public void setResponse(ContentType contentType, String body) {
        if (contentType == null) {
            throw new NullPointerException("Null content type");
        }
        if (body == null) {
            throw new NullPointerException("Null response body");
        }
        this.responseContentType = contentType;
        this.setResponseBody(body);
    }

    public String toXmlErrorMessage() {
        return this.toXmlErrorMessage(false);
    }

    public String toXmlErrorMessage(boolean includeDebugInfo) {
        StringBuilder sb = new StringBuilder();
        sb.append("<errors xmlns='http://schemas.google.com/g/2005'>\n");
        for (ServiceException sibling : this.siblings) {
            this.addXmlError(sibling, sb, includeDebugInfo);
        }
        sb.append("</errors>\n");
        return sb.toString();
    }

    private String escape(String src) {
        return CharEscapers.xmlEscaper().escape(src);
    }

    private void addXmlError(ServiceException se, StringBuilder sb, boolean includeDebugInfo) {
        String debugInfo;
        String sendReport;
        String extendedHelp;
        String internalReason;
        sb.append("<error>\n");
        String domainName = se.getDomainName();
        sb.append("<domain>");
        sb.append(this.escape(domainName));
        sb.append("</domain>\n");
        String codeName = se.getCodeName();
        sb.append("<code>");
        sb.append(this.escape(codeName));
        sb.append("</code>\n");
        String location = se.getLocation();
        ErrorContent.LocationType locationType = se.getLocationTypeWithDefault();
        if (location != null) {
            sb.append("<location type='");
            sb.append(this.escape(locationType.toString()));
            sb.append("'>");
            sb.append(this.escape(location));
            sb.append("</location>\n");
        }
        if ((internalReason = se.getInternalReason()) != null) {
            sb.append("<internalReason>");
            sb.append(this.escape(internalReason));
            sb.append("</internalReason>\n");
        }
        if ((extendedHelp = se.getExtendedHelp()) != null) {
            sb.append("<extendedHelp>");
            sb.append(this.escape(extendedHelp));
            sb.append("</extendedHelp>\n");
        }
        if ((sendReport = se.getSendReport()) != null) {
            sb.append("<sendReport>");
            sb.append(this.escape(sendReport));
            sb.append("</sendReport>\n");
        }
        if (includeDebugInfo && (debugInfo = se.getDebugInfo()) != null) {
            sb.append("<debugInfo>");
            sb.append(this.escape(debugInfo));
            sb.append("</debugInfo>\n");
        }
        sb.append("</error>\n");
    }

    public Map<String, List<String>> getHttpHeaders() {
        return this.httpHeaders;
    }

    public List<String> getHttpHeader(String header) {
        if (header == null) {
            return this.httpHeaders.get(header);
        }
        for (String key : this.httpHeaders.keySet()) {
            if (key == null || !key.toLowerCase().equals(header.toLowerCase())) continue;
            return this.httpHeaders.get(key);
        }
        return null;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString());
        if (this.responseBody != null) {
            sb.append('\n');
            sb.append(this.responseBody);
        }
        return sb.toString();
    }

    public String getDomainName() {
        String domainName = this.errorElement.getDomainName();
        return domainName != null ? domainName : "GData";
    }

    public void setDomain(String domain) {
        this.errorElement.setDomain(domain);
    }

    public String getCodeName() {
        String codeName = this.errorElement.getCodeName();
        return codeName != null ? codeName : this.getClass().getSimpleName();
    }

    public void setCode(String code) {
        this.errorElement.setCode(code);
    }

    public String getLocation() {
        return this.errorElement.getLocation();
    }

    public ErrorContent.LocationType getLocationType() {
        return this.errorElement.getLocationType();
    }

    private ErrorContent.LocationType getLocationTypeWithDefault() {
        ErrorContent.LocationType type = this.getLocationType();
        return type != null ? type : ErrorContent.LocationType.OTHER;
    }

    public void setXpathLocation(String location) {
        this.errorElement.setXpathLocation(location);
    }

    public void setHeaderLocation(String location) {
        this.errorElement.setHeaderLocation(location);
    }

    public void setLocation(String location) {
        this.errorElement.setLocation(location);
    }

    public String getInternalReason() {
        String internalReason = this.errorElement.getInternalReason();
        return internalReason != null ? internalReason : super.getMessage();
    }

    @Override
    public String getMessage() {
        return this.getInternalReason();
    }

    public void setInternalReason(String internalReason) {
        this.errorElement.setInternalReason(internalReason);
    }

    public String getExtendedHelp() {
        return this.errorElement.getExtendedHelp();
    }

    public void setExtendedHelp(String extendedHelp) {
        this.errorElement.setExtendedHelp(extendedHelp);
    }

    public String getSendReport() {
        return this.errorElement.getSendReport();
    }

    public void setSendReport(String sendReport) {
        this.errorElement.setSendReport(sendReport);
    }

    public String getDebugInfo() {
        return this.errorElement.getDebugInfo();
    }

    public void setDebugInfo(String debugInfo) {
        this.errorElement.setDebugInfo(debugInfo);
    }

    public List<ServiceException> getSiblings() {
        return Collections.unmodifiableList(new ArrayList<ServiceException>(this.siblings));
    }

    public ServiceException addSibling(ServiceException newbie) {
        if (newbie == null) {
            throw new NullPointerException("Null exception being added");
        }
        for (ServiceException newbieSibling : newbie.siblings) {
            if (!this.siblings.contains(newbieSibling)) {
                this.siblings.add(newbieSibling);
            }
            newbieSibling.siblings = this.siblings;
        }
        return this;
    }

    public boolean matches(ErrorContent code) {
        return this.getDomainName().equals(code.getDomainName()) && this.getCodeName().equals(code.getCodeName());
    }

    public boolean matchesAny(ErrorContent errorCode) {
        for (ServiceException se : this.siblings) {
            if (!se.matches(errorCode)) continue;
            return true;
        }
        return false;
    }

    public boolean hasOAuthProxyResponse() {
        return this.httpHeaders.containsKey("x_oauth_approval_url") || this.httpHeaders.containsKey("x_oauth_state") || this.httpHeaders.containsKey("x_oauth_error") || this.httpHeaders.containsKey("x_oauth_error");
    }

    public OAuthProxyResponse getOAuthProxyResponse() {
        return new OAuthProxyResponse(this.httpHeaders);
    }
}

