/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.thunderbird;

import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.java.sip.communicator.plugin.thunderbird.ThunderbirdConfigForm;
import net.java.sip.communicator.plugin.thunderbird.ThunderbirdContactSourceService;
import net.java.sip.communicator.service.contactsource.ContactSourceService;
import net.java.sip.communicator.service.gui.ConfigurationForm;
import net.java.sip.communicator.service.gui.LazyConfigurationForm;
import net.java.sip.communicator.service.protocol.PhoneNumberI18nService;
import net.java.sip.communicator.util.ServiceUtils;
import org.jitsi.service.configuration.ConfigurationService;
import org.jitsi.service.resources.ResourceManagementService;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

public class ThunderbirdActivator
implements BundleActivator {
    private static BundleContext bundleContext;
    private static Map<ThunderbirdContactSourceService, ServiceRegistration> registrations;
    private static PhoneNumberI18nService phoneNumberI18nService;

    static ConfigurationService getConfigService() {
        return (ConfigurationService)ServiceUtils.getService((BundleContext)bundleContext, ConfigurationService.class);
    }

    static ResourceManagementService getResources() {
        return (ResourceManagementService)ServiceUtils.getService((BundleContext)bundleContext, ResourceManagementService.class);
    }

    static List<ThunderbirdContactSourceService> getActiveServices() {
        return new LinkedList<ThunderbirdContactSourceService>(registrations.keySet());
    }

    static void add(String config) {
        ThunderbirdContactSourceService service = new ThunderbirdContactSourceService(config);
        registrations.put(service, bundleContext.registerService(ContactSourceService.class.getName(), (Object)service, null));
    }

    static void remove(ThunderbirdContactSourceService service) {
        registrations.get(service).unregister();
        registrations.remove(service);
        ConfigurationService config = ThunderbirdActivator.getConfigService();
        config.removeProperty(service.getBaseConfigProperty());
        for (String prop : config.getPropertyNamesByPrefix(service.getBaseConfigProperty(), false)) {
            config.removeProperty(prop);
        }
    }

    public void start(BundleContext bundleContext) throws Exception {
        ThunderbirdActivator.bundleContext = bundleContext;
        ConfigurationService config = ThunderbirdActivator.getConfigService();
        List configs = config.getPropertyNamesByPrefix("net.java.sip.communicator.plugin.thunderbird.source", false);
        registrations = new HashMap<ThunderbirdContactSourceService, ServiceRegistration>();
        for (String cfg : configs) {
            String value = config.getString(cfg);
            if (value == null || !cfg.endsWith(value)) continue;
            ThunderbirdActivator.add(cfg);
        }
        Hashtable<String, String> properties = new Hashtable<String, String>();
        ((Dictionary)properties).put("FORM_TYPE", "CONTACT_SOURCE_TYPE");
        bundleContext.registerService(ConfigurationForm.class.getName(), (Object)new LazyConfigurationForm(ThunderbirdConfigForm.class.getName(), this.getClass().getClassLoader(), null, "plugin.thunderbird.CONFIG_FORM_TITLE"), properties);
    }

    public void stop(BundleContext bundleContext) throws Exception {
        for (ServiceRegistration sr : registrations.values()) {
            sr.unregister();
        }
        registrations = null;
    }

    public static PhoneNumberI18nService getPhoneNumberI18nService() {
        if (phoneNumberI18nService == null) {
            phoneNumberI18nService = (PhoneNumberI18nService)ServiceUtils.getService((BundleContext)bundleContext, PhoneNumberI18nService.class);
        }
        return phoneNumberI18nService;
    }
}

