/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.codec.audio.g729;

import org.jitsi.impl.neomedia.codec.audio.g729.TabLd8k;

class Lpc {
    Lpc() {
    }

    static void autocorr(float[] x, int x_offset, int m, float[] r) {
        int i;
        int L_WINDOW = 240;
        float[] hamwindow = TabLd8k.hamwindow;
        float[] y = new float[L_WINDOW];
        for (i = 0; i < L_WINDOW; ++i) {
            y[i] = x[x_offset + i] * hamwindow[i];
        }
        for (i = 0; i <= m; ++i) {
            float sum = 0.0f;
            for (int j = 0; j < L_WINDOW - i; ++j) {
                sum += y[j] * y[j + i];
            }
            r[i] = sum;
        }
        if (r[0] < 1.0f) {
            r[0] = 1.0f;
        }
    }

    static void lag_window(int m, float[] r) {
        float[] lwindow = TabLd8k.lwindow;
        for (int i = 1; i <= m; ++i) {
            int n = i;
            r[n] = r[n] * lwindow[i - 1];
        }
    }

    static float levinson(float[] r, float[] a, int a_offset, float[] rc) {
        int M = 10;
        rc[0] = -r[1] / r[0];
        a[a_offset + 0] = 1.0f;
        a[a_offset + 1] = rc[0];
        float err = r[0] + r[1] * rc[0];
        for (int i = 2; i <= M; ++i) {
            int j;
            float s = 0.0f;
            for (j = 0; j < i; ++j) {
                s += r[i - j] * a[a_offset + j];
            }
            rc[i - 1] = -s / err;
            for (j = 1; j <= i / 2; ++j) {
                int l = i - j;
                float at = a[a_offset + j] + rc[i - 1] * a[a_offset + l];
                int n = a_offset + l;
                a[n] = a[n] + rc[i - 1] * a[a_offset + j];
                a[a_offset + j] = at;
            }
            a[a_offset + i] = rc[i - 1];
            if (!((err += rc[i - 1] * s) <= 0.0f)) continue;
            err = 0.001f;
        }
        return err;
    }

    static void az_lsp(float[] a, int a_offset, float[] lsp, float[] old_lsp) {
        int GRID_POINTS = 60;
        int M = 10;
        int NC = 5;
        float[] grid = TabLd8k.grid;
        float[] f1 = new float[NC + 1];
        float[] f2 = new float[NC + 1];
        f1[0] = 1.0f;
        f2[0] = 1.0f;
        int i = 1;
        int j = a_offset + M;
        while (i <= NC) {
            float ai = a[a_offset + i];
            float aj = a[j];
            f1[i] = ai + aj - f1[i - 1];
            f2[i] = ai - aj + f2[i - 1];
            ++i;
            --j;
        }
        int nf = 0;
        int ip = 0;
        float[] coef = f1;
        float xlow = grid[0];
        float ylow = Lpc.chebyshev(xlow, coef, NC);
        j = 0;
        while (nf < M && j < GRID_POINTS) {
            float xint;
            ++j;
            float xhigh = xlow;
            float yhigh = ylow;
            xlow = grid[j];
            ylow = Lpc.chebyshev(xlow, coef, NC);
            if (!(ylow * yhigh <= 0.0f)) continue;
            --j;
            for (i = 0; i < 4; ++i) {
                float xmid = 0.5f * (xlow + xhigh);
                float ymid = Lpc.chebyshev(xmid, coef, NC);
                if (ylow * ymid <= 0.0f) {
                    yhigh = ymid;
                    xhigh = xmid;
                    continue;
                }
                ylow = ymid;
                xlow = xmid;
            }
            lsp[nf] = xint = xlow - ylow * (xhigh - xlow) / (yhigh - ylow);
            ++nf;
            coef = (ip = 1 - ip) != 0 ? f2 : f1;
            xlow = xint;
            ylow = Lpc.chebyshev(xlow, coef, NC);
        }
        if (nf < M) {
            for (i = 0; i < M; ++i) {
                lsp[i] = old_lsp[i];
            }
        }
    }

    private static float chebyshev(float x, float[] f, int n) {
        float x2 = 2.0f * x;
        float b2 = 1.0f;
        float b1 = x2 + f[1];
        for (int i = 2; i < n; ++i) {
            float b0 = x2 * b1 - b2 + f[i];
            b2 = b1;
            b1 = b0;
        }
        return x * b1 - b2 + 0.5f * f[n];
    }
}

