/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.device;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import javax.media.CaptureDeviceInfo;
import javax.media.Format;
import javax.media.Renderer;
import javax.media.control.BufferControl;
import javax.media.control.FormatControl;
import javax.media.format.AudioFormat;
import javax.media.protocol.CaptureDevice;
import javax.media.protocol.DataSource;
import org.jitsi.impl.neomedia.MediaUtils;
import org.jitsi.impl.neomedia.conference.AudioMixer;
import org.jitsi.impl.neomedia.conference.AudioMixingPushBufferDataSource;
import org.jitsi.impl.neomedia.device.AudioSystem;
import org.jitsi.impl.neomedia.device.MediaDeviceImpl;
import org.jitsi.service.neomedia.MediaDirection;
import org.jitsi.service.neomedia.MediaType;
import org.jitsi.service.neomedia.RTPExtension;
import org.jitsi.util.Logger;
import org.jitsi.util.OSUtils;

public class AudioMediaDeviceImpl
extends MediaDeviceImpl {
    private static final Logger logger = Logger.getLogger(AudioMediaDeviceImpl.class);
    private AudioMixer captureDeviceSharing;
    private List<RTPExtension> rtpExtensions = null;

    public AudioMediaDeviceImpl() {
        super(MediaType.AUDIO);
    }

    public AudioMediaDeviceImpl(CaptureDeviceInfo captureDeviceInfo) {
        super(captureDeviceInfo, MediaType.AUDIO);
    }

    @Override
    public void connect(DataSource captureDevice) throws IOException {
        BufferControl bufferControl;
        super.connect(captureDevice);
        if (!OSUtils.IS_LINUX && (bufferControl = (BufferControl)captureDevice.getControl(BufferControl.class.getName())) != null) {
            bufferControl.setBufferLength(60L);
        }
    }

    @Override
    protected synchronized CaptureDevice createCaptureDevice() {
        AudioMixingPushBufferDataSource captureDevice = null;
        if (this.getDirection().allowsSending()) {
            if (this.captureDeviceSharing == null) {
                String protocol = this.getCaptureDeviceInfoLocatorProtocol();
                boolean createCaptureDeviceIfNull = true;
                if ("javasound".equalsIgnoreCase(protocol) || "portaudio".equalsIgnoreCase(protocol)) {
                    captureDevice = this.superCreateCaptureDevice();
                    createCaptureDeviceIfNull = false;
                    if (captureDevice != null) {
                        this.captureDeviceSharing = this.createCaptureDeviceSharing(captureDevice);
                        captureDevice = this.captureDeviceSharing.createOutDataSource();
                    }
                }
                if (captureDevice == null && createCaptureDeviceIfNull) {
                    captureDevice = this.superCreateCaptureDevice();
                }
            } else {
                captureDevice = this.captureDeviceSharing.createOutDataSource();
            }
        }
        return captureDevice;
    }

    private AudioMixer createCaptureDeviceSharing(CaptureDevice captureDevice) {
        return new AudioMixer(captureDevice){

            @Override
            protected void connect(DataSource dataSource, DataSource inputDataSource) throws IOException {
                if (inputDataSource == this.captureDevice) {
                    AudioMediaDeviceImpl.this.connect(dataSource);
                } else {
                    super.connect(dataSource, inputDataSource);
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Renderer createRenderer() {
        Renderer renderer = null;
        try {
            AudioSystem audioSystem;
            String locatorProtocol = this.getCaptureDeviceInfoLocatorProtocol();
            if (locatorProtocol != null && (audioSystem = AudioSystem.getAudioSystem(locatorProtocol)) != null) {
                renderer = audioSystem.createRenderer(true);
            }
        }
        finally {
            if (renderer == null) {
                renderer = super.createRenderer();
            }
        }
        return renderer;
    }

    @Override
    public List<RTPExtension> getSupportedExtensions() {
        if (this.rtpExtensions == null) {
            URI csrcAudioLevelURN;
            this.rtpExtensions = new ArrayList<RTPExtension>(1);
            try {
                csrcAudioLevelURN = new URI("urn:ietf:params:rtp-hdrext:csrc-audio-level");
            }
            catch (URISyntaxException e) {
                if (logger.isInfoEnabled()) {
                    logger.info("Aha! Someone messed with the source!", e);
                }
                csrcAudioLevelURN = null;
            }
            if (csrcAudioLevelURN != null) {
                this.rtpExtensions.add(new RTPExtension(csrcAudioLevelURN, MediaDirection.RECVONLY));
            }
        }
        return this.rtpExtensions;
    }

    private boolean isLessThanOrEqualToMaxAudioFormat(Format format) {
        int sampleSizeInBits;
        double sampleRate;
        AudioFormat audioFormat;
        int channels;
        return !(!(format instanceof AudioFormat) || (channels = (audioFormat = (AudioFormat)format).getChannels()) != -1 && MediaUtils.MAX_AUDIO_CHANNELS != -1 && channels > MediaUtils.MAX_AUDIO_CHANNELS || (sampleRate = audioFormat.getSampleRate()) != -1.0 && MediaUtils.MAX_AUDIO_SAMPLE_RATE != -1.0 && !(sampleRate <= MediaUtils.MAX_AUDIO_SAMPLE_RATE) || (sampleSizeInBits = audioFormat.getSampleSizeInBits()) != -1 && MediaUtils.MAX_AUDIO_SAMPLE_SIZE_IN_BITS != -1 && sampleSizeInBits > MediaUtils.MAX_AUDIO_SAMPLE_SIZE_IN_BITS);
    }

    protected CaptureDevice superCreateCaptureDevice() {
        CaptureDevice captureDevice;
        block10: {
            captureDevice = super.createCaptureDevice();
            if (captureDevice != null) {
                try {
                    FormatControl[] formatControls = captureDevice.getFormatControls();
                    if (formatControls != null && formatControls.length != 0) {
                        for (FormatControl formatControl : formatControls) {
                            AudioFormat formatToSet;
                            Format format = formatControl.getFormat();
                            if (format != null && this.isLessThanOrEqualToMaxAudioFormat(format)) continue;
                            Format[] supportedFormats = formatControl.getSupportedFormats();
                            AudioFormat supportedFormatToSet = null;
                            if (supportedFormats != null && supportedFormats.length != 0) {
                                for (Format supportedFormat : supportedFormats) {
                                    if (!this.isLessThanOrEqualToMaxAudioFormat(supportedFormat)) continue;
                                    supportedFormatToSet = (AudioFormat)supportedFormat;
                                    break;
                                }
                            }
                            if (supportedFormatToSet.matches(format)) continue;
                            int channels = supportedFormatToSet.getChannels();
                            double sampleRate = supportedFormatToSet.getSampleRate();
                            int sampleSizeInBits = supportedFormatToSet.getSampleSizeInBits();
                            if (channels == -1) {
                                channels = MediaUtils.MAX_AUDIO_CHANNELS;
                            }
                            if (sampleRate == -1.0) {
                                sampleRate = MediaUtils.MAX_AUDIO_SAMPLE_RATE;
                            }
                            if (sampleSizeInBits == -1 && (sampleSizeInBits = MediaUtils.MAX_AUDIO_SAMPLE_SIZE_IN_BITS) == -1) {
                                sampleSizeInBits = 16;
                            }
                            if (channels == -1 || sampleRate == -1.0 || sampleSizeInBits == -1 || !supportedFormatToSet.matches((Format)(formatToSet = new AudioFormat(supportedFormatToSet.getEncoding(), sampleRate, sampleSizeInBits, channels)))) continue;
                            formatControl.setFormat(supportedFormatToSet.intersects((Format)formatToSet));
                        }
                    }
                }
                catch (Throwable t) {
                    if (!(t instanceof ThreadDeath)) break block10;
                    throw (ThreadDeath)t;
                }
            }
        }
        return captureDevice;
    }
}

