/*
 * Decompiled with CFR 0.152.
 */
package com.explodingpixels.macwidgets.plaf;

import com.explodingpixels.macwidgets.plaf.ArtworkUtils;
import com.explodingpixels.widgets.ImageButton;
import com.explodingpixels.widgets.ImageUtils;
import com.explodingpixels.widgets.plaf.ScrollThumbImagePainter;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class IAppScrollBarArtworkUtils {
    private static final String V_SCROLLER_CAP = "/com/explodingpixels/macwidgets/images/v_scroller_top_cap.png";
    private static final String V_TRACK = "/com/explodingpixels/macwidgets/images/v_scroller_track.png";
    private static final String V_SCROLLER_TOGETHER_DECREMENT_BUTTONS = "/com/explodingpixels/macwidgets/images/v_scroller_together_decrement_button.png";
    private static final String V_SCROLLER_TOGETHER_INCREMENT_BUTTONS = "/com/explodingpixels/macwidgets/images/v_scroller_together_increment_button.png";
    private static final String V_SCROLLERS = "/com/explodingpixels/macwidgets/images/v_scroller.png";
    private static final String V_BOTTOM_BUTTON_MASK = "/com/explodingpixels/macwidgets/images/v_scroller_mask_bottom.png";
    private static final String H_SCROLLER_CAP = "/com/explodingpixels/macwidgets/images/h_scroller_left_cap.png";
    private static final String H_TRACK = "/com/explodingpixels/macwidgets/images/h_scroller_track.png";
    private static final String H_SCROLLER_TOGETHER_DECREMENT_BUTTONS = "/com/explodingpixels/macwidgets/images/h_scroller_together_decrement_button.png";
    private static final String H_SCROLLER_TOGETHER_INCREMENT_BUTTONS = "/com/explodingpixels/macwidgets/images/h_scroller_together_increment_button.png";
    private static final String H_SCROLLERS = "/com/explodingpixels/macwidgets/images/h_scroller.png";
    private static final String H_RIGHT_BUTTON_MASK = "/com/explodingpixels/macwidgets/images/h_scroller_mask_right.png";

    private IAppScrollBarArtworkUtils() {
    }

    public static AbstractButton createVerticalTogetherDecrementButton() {
        ArtworkUtils.ImageSet images = ArtworkUtils.getImageSet(IAppScrollBarArtworkUtils.class.getResource(V_SCROLLER_TOGETHER_DECREMENT_BUTTONS));
        return IAppScrollBarArtworkUtils.createButton(images, IAppScrollBarArtworkUtils.getBottomButtonMask());
    }

    public static AbstractButton createVerticalTogetherIncrementButton() {
        ArtworkUtils.ImageSet images = ArtworkUtils.getImageSet(IAppScrollBarArtworkUtils.class.getResource(V_SCROLLER_TOGETHER_INCREMENT_BUTTONS));
        return IAppScrollBarArtworkUtils.createButton(images);
    }

    public static ScrollThumbImagePainter createVerticalScrollerThumb() {
        ArtworkUtils.ImageSet images = ArtworkUtils.getImageSet(IAppScrollBarArtworkUtils.class.getResource(V_SCROLLERS));
        BufferedImage disabledLowerBound = ImageUtils.getSubImage(images.getInactiveImage().getImage(), 0, 0, 13, 8);
        BufferedImage disabledMiddle = ImageUtils.getSubImage(images.getInactiveImage().getImage(), 0, 8, 13, 8);
        BufferedImage disabledUpperBound = ImageUtils.getSubImage(images.getInactiveImage().getImage(), 0, 16, 13, 8);
        BufferedImage inactiveLowerBound = ImageUtils.getSubImage(images.getActiveImage().getImage(), 0, 0, 13, 8);
        BufferedImage inactiveMiddle = ImageUtils.getSubImage(images.getActiveImage().getImage(), 0, 8, 13, 8);
        BufferedImage inactiveUpperBound = ImageUtils.getSubImage(images.getActiveImage().getImage(), 0, 16, 13, 8);
        BufferedImage activeLowerBound = ImageUtils.getSubImage(images.getPressedImage().getImage(), 0, 0, 13, 8);
        BufferedImage activeMiddle = ImageUtils.getSubImage(images.getPressedImage().getImage(), 0, 8, 13, 8);
        BufferedImage activeUpperBound = ImageUtils.getSubImage(images.getPressedImage().getImage(), 0, 16, 13, 8);
        return ScrollThumbImagePainter.createVerticalScrollThumbImagePainter(disabledLowerBound, disabledMiddle, disabledUpperBound, inactiveLowerBound, inactiveMiddle, inactiveUpperBound, activeLowerBound, activeMiddle, activeUpperBound);
    }

    public static int getVerticalScrollBarMiniumumHeight() {
        ImageIcon scrollers = new ImageIcon(IAppScrollBarArtworkUtils.class.getResource(V_SCROLLERS));
        return scrollers.getIconHeight();
    }

    public static Dimension getVerticalScrollBarMinimumSize() {
        return new Dimension(IAppScrollBarArtworkUtils.getVerticalTrack().getIconWidth(), IAppScrollBarArtworkUtils.getVerticalScrollBarMiniumumHeight());
    }

    private static ImageIcon getBottomButtonMask() {
        return new ImageIcon(IAppScrollBarArtworkUtils.class.getResource(V_BOTTOM_BUTTON_MASK));
    }

    public static ImageIcon getScrollBarTopCap() {
        ArtworkUtils.ImageSet images = ArtworkUtils.getImageSet(IAppScrollBarArtworkUtils.class.getResource(V_SCROLLER_CAP));
        return images.getActiveImage();
    }

    public static ImageIcon getVerticalTrack() {
        return new ImageIcon(IAppScrollBarArtworkUtils.class.getResource(V_TRACK));
    }

    public static AbstractButton createHorizontalTogetherDecrementButton() {
        ArtworkUtils.ImageSet images = ArtworkUtils.getImageSet(IAppScrollBarArtworkUtils.class.getResource(H_SCROLLER_TOGETHER_DECREMENT_BUTTONS));
        return IAppScrollBarArtworkUtils.createButton(images, IAppScrollBarArtworkUtils.getRightButtonMask());
    }

    public static AbstractButton createHorizontalTogetherIncrementButton() {
        ArtworkUtils.ImageSet images = ArtworkUtils.getImageSet(IAppScrollBarArtworkUtils.class.getResource(H_SCROLLER_TOGETHER_INCREMENT_BUTTONS));
        return IAppScrollBarArtworkUtils.createButton(images);
    }

    public static ScrollThumbImagePainter createHorizontalScrollerThumb() {
        ArtworkUtils.ImageSet images = ArtworkUtils.getImageSet(IAppScrollBarArtworkUtils.class.getResource(H_SCROLLERS));
        BufferedImage disabledLowerBound = ImageUtils.getSubImage(images.getInactiveImage().getImage(), 0, 0, 8, 13);
        BufferedImage disabledMiddle = ImageUtils.getSubImage(images.getInactiveImage().getImage(), 8, 0, 8, 13);
        BufferedImage disabledUpperBound = ImageUtils.getSubImage(images.getInactiveImage().getImage(), 16, 0, 8, 13);
        BufferedImage inactiveLowerBound = ImageUtils.getSubImage(images.getActiveImage().getImage(), 0, 0, 8, 13);
        BufferedImage inactiveMiddle = ImageUtils.getSubImage(images.getActiveImage().getImage(), 8, 0, 8, 13);
        BufferedImage inactiveUpperBound = ImageUtils.getSubImage(images.getActiveImage().getImage(), 16, 0, 8, 13);
        BufferedImage activeLowerBound = ImageUtils.getSubImage(images.getPressedImage().getImage(), 0, 0, 8, 13);
        BufferedImage activeMiddle = ImageUtils.getSubImage(images.getPressedImage().getImage(), 8, 0, 8, 13);
        BufferedImage activeUpperBound = ImageUtils.getSubImage(images.getPressedImage().getImage(), 16, 0, 8, 13);
        return ScrollThumbImagePainter.createHorizontalScrollThumbImagePainter(disabledLowerBound, disabledMiddle, disabledUpperBound, inactiveLowerBound, inactiveMiddle, inactiveUpperBound, activeLowerBound, activeMiddle, activeUpperBound);
    }

    public static int getHorizontalScrollBarMiniumumWidth() {
        ImageIcon scrollers = new ImageIcon(IAppScrollBarArtworkUtils.class.getResource(H_SCROLLERS));
        return scrollers.getIconWidth() / 3;
    }

    public static Dimension getHorizontalScrollBarMinimumSize() {
        return new Dimension(IAppScrollBarArtworkUtils.getHorizontalScrollBarMiniumumWidth(), IAppScrollBarArtworkUtils.getHorizontalTrack().getIconHeight());
    }

    private static ImageIcon getRightButtonMask() {
        return new ImageIcon(IAppScrollBarArtworkUtils.class.getResource(H_RIGHT_BUTTON_MASK));
    }

    public static ImageIcon getScrollBarLeftCap() {
        ArtworkUtils.ImageSet images = ArtworkUtils.getImageSet(IAppScrollBarArtworkUtils.class.getResource(H_SCROLLER_CAP));
        return images.getActiveImage();
    }

    public static ImageIcon getHorizontalTrack() {
        return new ImageIcon(IAppScrollBarArtworkUtils.class.getResource(H_TRACK));
    }

    private static AbstractButton createButton(ArtworkUtils.ImageSet images, ImageIcon buttonMask) {
        ImageButton retVal = new ImageButton(images.getActiveImage(), (Icon)buttonMask);
        retVal.setPressedIcon(images.getPressedImage());
        retVal.setDisabledIcon(images.getInactiveImage());
        retVal.setInactiveIcon(images.getInactiveImage());
        return retVal;
    }

    private static AbstractButton createButton(ArtworkUtils.ImageSet images) {
        ImageButton retVal = new ImageButton(images.getActiveImage());
        retVal.setPressedIcon(images.getPressedImage());
        retVal.setDisabledIcon(images.getInactiveImage());
        retVal.setInactiveIcon(images.getInactiveImage());
        return retVal;
    }

    public static int getScrollBarTopCapRecess() {
        return 12;
    }

    public static int getDecrementButtonRecess() {
        return 11;
    }
}

