/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.gui.main.chat.conference;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JRadioButton;
import net.java.sip.communicator.impl.gui.GuiActivator;
import net.java.sip.communicator.plugin.desktoputil.SIPCommDialog;
import net.java.sip.communicator.plugin.desktoputil.TransparentPanel;
import net.java.sip.communicator.service.msghistory.MessageHistoryService;
import net.java.sip.communicator.service.muc.MUCService;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;

public class ChatRoomAutoOpenConfigDialog
extends SIPCommDialog
implements ActionListener {
    private static final long serialVersionUID = -7741709128413173168L;
    private String value = null;
    private ProtocolProviderService pps;
    private String chatRoomId;
    private final JRadioButton openOnActivity = new JRadioButton(GuiActivator.getResources().getI18NString("service.gui.OPEN_ON_ACTIVITY"));
    private final JRadioButton openOnMessage = new JRadioButton(GuiActivator.getResources().getI18NString("service.gui.OPEN_ON_MESSAGE"));
    private final JRadioButton openOnImportantMessage = new JRadioButton(GuiActivator.getResources().getI18NString("service.gui.OPEN_ON_IMPORTANT_MESSAGE"));
    private JButton okButton = new JButton(GuiActivator.getResources().getI18NString("service.gui.OK"));
    private JButton cancelButton = new JButton(GuiActivator.getResources().getI18NString("service.gui.CANCEL"));
    private PropertyChangeListener propertyListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            ChatRoomAutoOpenConfigDialog.this.updateView();
        }
    };
    private static ChatRoomAutoOpenConfigDialog dialog = null;

    public static void showChatRoomAutoOpenConfigDialog(ProtocolProviderService pps, String chatRoomId) {
        if (dialog == null) {
            dialog = new ChatRoomAutoOpenConfigDialog(pps, chatRoomId);
        } else {
            dialog.clearListeners();
            dialog.setProvider(pps);
            dialog.setChatRoomId(chatRoomId);
            dialog.refreshValue();
            if (dialog.isVisible()) {
                dialog.toFront();
            } else {
                dialog.setVisible(true);
            }
            dialog.pack();
        }
    }

    private ChatRoomAutoOpenConfigDialog(ProtocolProviderService pps, String chatRoomId) {
        this.pps = pps;
        this.chatRoomId = chatRoomId;
        this.setDefaultCloseOperation(2);
        this.refreshValue();
        TransparentPanel choicePanel = new TransparentPanel();
        choicePanel.setLayout(new BoxLayout((Container)choicePanel, 1));
        choicePanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.openOnActivity.addActionListener(this);
        this.openOnMessage.addActionListener(this);
        this.openOnImportantMessage.addActionListener(this);
        this.setTitle(GuiActivator.getResources().getI18NString("service.gui.OPEN_AUTOMATICALLY"));
        this.openOnActivity.setOpaque(false);
        this.openOnMessage.setOpaque(false);
        this.openOnImportantMessage.setOpaque(false);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.openOnActivity);
        buttonGroup.add(this.openOnMessage);
        buttonGroup.add(this.openOnImportantMessage);
        choicePanel.add(this.openOnActivity);
        choicePanel.add(this.openOnMessage);
        choicePanel.add(this.openOnImportantMessage);
        TransparentPanel buttonPanel = new TransparentPanel((LayoutManager)new FlowLayout(2));
        this.updateView();
        this.okButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        buttonPanel.add(this.okButton);
        buttonPanel.add(this.cancelButton);
        this.add((Component)choicePanel, "Center");
        this.add((Component)buttonPanel, "South");
        this.setVisible(true);
        this.setPreferredSize(new Dimension(320, 150));
        this.pack();
    }

    private void setProvider(ProtocolProviderService pps) {
        this.pps = pps;
    }

    private void setChatRoomId(String chatRoomId) {
        this.chatRoomId = chatRoomId;
    }

    private void refreshValue() {
        this.value = MUCService.getChatRoomAutoOpenOption((ProtocolProviderService)this.pps, (String)this.chatRoomId);
        GuiActivator.getConfigurationService().addPropertyChangeListener("net.java.sip.communicator.service.msghistory.IS_MESSAGE_HISTORY_ENABLED", this.propertyListener);
        GuiActivator.getConfigurationService().addPropertyChangeListener("net.java.sip.communicator.service.msghistory.contact." + this.chatRoomId, this.propertyListener);
        if (this.value == null) {
            this.value = MUCService.DEFAULT_AUTO_OPEN_BEHAVIOUR;
        }
        if (this.value.equals(MUCService.OPEN_ON_ACTIVITY)) {
            this.openOnActivity.setSelected(true);
        } else if (this.value.equals(MUCService.OPEN_ON_IMPORTANT_MESSAGE)) {
            this.openOnImportantMessage.setSelected(true);
        } else {
            this.openOnMessage.setSelected(true);
        }
    }

    private void updateView() {
        MessageHistoryService mhs = GuiActivator.getMessageHistoryService();
        if (!mhs.isHistoryLoggingEnabled() || !mhs.isHistoryLoggingEnabled(this.chatRoomId)) {
            this.openOnImportantMessage.setEnabled(false);
            this.openOnMessage.setEnabled(false);
            this.openOnActivity.setSelected(true);
        } else {
            this.openOnImportantMessage.setEnabled(true);
            this.openOnMessage.setEnabled(true);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source instanceof JButton) {
            if (source.equals(this.okButton)) {
                MUCService.setChatRoomAutoOpenOption((ProtocolProviderService)this.pps, (String)this.chatRoomId, (String)this.value);
            }
            this.dispose();
        } else if (source instanceof JRadioButton) {
            this.value = source.equals(this.openOnActivity) ? MUCService.OPEN_ON_ACTIVITY : (source.equals(this.openOnMessage) ? MUCService.OPEN_ON_MESSAGE : MUCService.OPEN_ON_IMPORTANT_MESSAGE);
        }
    }

    private void clearListeners() {
        GuiActivator.getConfigurationService().removePropertyChangeListener("net.java.sip.communicator.service.msghistory.IS_MESSAGE_HISTORY_ENABLED", this.propertyListener);
        GuiActivator.getConfigurationService().removePropertyChangeListener("net.java.sip.communicator.service.msghistory.contact." + this.chatRoomId, this.propertyListener);
    }

    public void dispose() {
        this.clearListeners();
        super.dispose();
    }

    protected void close(boolean escaped) {
        super.close(escaped);
        this.dispose();
    }
}

