/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.gui.main.contactlist.contactsource;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.java.sip.communicator.impl.gui.GuiActivator;
import net.java.sip.communicator.service.contactsource.AbstractContactQuery;
import net.java.sip.communicator.service.contactsource.ContactDetail;
import net.java.sip.communicator.service.contactsource.ContactQuery;
import net.java.sip.communicator.service.contactsource.ContactSourceService;
import net.java.sip.communicator.service.contactsource.GenericSourceContact;
import net.java.sip.communicator.service.contactsource.SourceContact;
import net.java.sip.communicator.service.protocol.OperationSet;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;

public class StringContactSourceServiceImpl
implements ContactSourceService {
    private final ProtocolProviderService protocolProvider;
    private final Class<? extends OperationSet> opSetClass;
    private boolean disableDisplayDetails = true;

    public StringContactSourceServiceImpl(ProtocolProviderService protocolProvider, Class<? extends OperationSet> opSet) {
        this.protocolProvider = protocolProvider;
        this.opSetClass = opSet;
    }

    public int getType() {
        return 1;
    }

    public String getDisplayName() {
        return GuiActivator.getResources().getI18NString("service.gui.SEARCH_STRING_CONTACT_SOURCE");
    }

    public ContactQuery createContactQuery(String queryString) {
        return this.createContactQuery(queryString, -1);
    }

    public ContactQuery createContactQuery(String queryString, int contactCount) {
        return new StringQuery(queryString);
    }

    public void setDisableDisplayDetails(boolean disableDisplayDetails) {
        this.disableDisplayDetails = disableDisplayDetails;
    }

    public SourceContact createSourceContact(String queryString) {
        ArrayList<ContactDetail> contactDetails = new ArrayList<ContactDetail>();
        ContactDetail contactDetail = new ContactDetail(queryString);
        ArrayList<Class<? extends OperationSet>> supportedOpSets = new ArrayList<Class<? extends OperationSet>>();
        supportedOpSets.add(this.opSetClass);
        contactDetail.setSupportedOpSets(supportedOpSets);
        HashMap<Class<? extends OperationSet>, ProtocolProviderService> providers = new HashMap<Class<? extends OperationSet>, ProtocolProviderService>();
        providers.put(this.opSetClass, this.protocolProvider);
        contactDetail.setPreferredProviders(providers);
        contactDetails.add(contactDetail);
        GenericSourceContact sourceContact = new GenericSourceContact((ContactSourceService)this, queryString, contactDetails);
        if (this.disableDisplayDetails) {
            sourceContact.setDisplayDetails(GuiActivator.getResources().getI18NString("service.gui.CALL_VIA") + " " + this.protocolProvider.getAccountID().getDisplayName());
        }
        return sourceContact;
    }

    public int getIndex() {
        return 0;
    }

    private class StringQuery
    extends AbstractContactQuery<ContactSourceService> {
        private String queryString;
        private final List<SourceContact> results;

        public StringQuery(String queryString) {
            super((ContactSourceService)StringContactSourceServiceImpl.this);
            this.queryString = queryString;
            this.results = new ArrayList<SourceContact>();
        }

        public String getQueryString() {
            return this.queryString;
        }

        public List<SourceContact> getQueryResults() {
            return this.results;
        }

        public void start() {
            SourceContact contact = StringContactSourceServiceImpl.this.createSourceContact(this.queryString);
            this.results.add(contact);
            this.fireContactReceived(contact);
            if (this.getStatus() != 1) {
                this.setStatus(0);
            }
        }
    }
}

