/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.gui.utils;

import java.awt.image.BufferedImage;
import java.net.URL;
import java.util.Hashtable;
import java.util.Map;
import javax.imageio.ImageIO;
import net.java.sip.communicator.impl.gui.GuiActivator;
import net.java.sip.communicator.plugin.desktoputil.ImageUtils;
import net.java.sip.communicator.service.gui.ImageLoaderService;
import net.java.sip.communicator.service.resources.ImageID;
import net.java.sip.communicator.util.Logger;

public class ImageLoaderServiceImpl
implements ImageLoaderService<BufferedImage> {
    private static final Logger logger = Logger.getLogger(ImageLoaderServiceImpl.class);
    private static final Map<ImageID, BufferedImage> loadedImages = new Hashtable<ImageID, BufferedImage>();

    public BufferedImage getImage(ImageID imageID) {
        BufferedImage image = null;
        if (loadedImages.containsKey(imageID)) {
            image = loadedImages.get(imageID);
        } else {
            URL path = GuiActivator.getResources().getImageURL(imageID.getId());
            if (path != null) {
                try {
                    image = ImageIO.read(path);
                    loadedImages.put(imageID, image);
                }
                catch (Exception ex) {
                    logger.error((Object)("Failed to load image: " + path), (Throwable)ex);
                }
            }
        }
        return image;
    }

    public byte[] getImageBytes(ImageID imageID) {
        BufferedImage image = this.getImage(imageID);
        if (image != null) {
            return ImageUtils.toByteArray((BufferedImage)image);
        }
        return null;
    }

    public void clearCache() {
        loadedImages.clear();
    }
}

