/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.certificate;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Formatter;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.KeyStoreBuilderParameters;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import net.java.sip.communicator.impl.certificate.CertificateVerificationActivator;
import net.java.sip.communicator.service.certificate.CertificateConfigEntry;
import net.java.sip.communicator.service.certificate.CertificateMatcher;
import net.java.sip.communicator.service.certificate.CertificateService;
import net.java.sip.communicator.service.certificate.KeyStoreType;
import net.java.sip.communicator.service.certificate.VerifyCertificateDialogService;
import net.java.sip.communicator.service.credentialsstorage.CredentialsStorageService;
import net.java.sip.communicator.service.gui.AuthenticationWindowService;
import net.java.sip.communicator.service.httputil.HttpUtils;
import net.java.sip.communicator.util.Logger;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.bouncycastle.asn1.DERIA5String;
import org.bouncycastle.asn1.x509.AccessDescription;
import org.bouncycastle.asn1.x509.AuthorityInformationAccess;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.x509.extension.X509ExtensionUtil;
import org.jitsi.service.configuration.ConfigurationService;
import org.jitsi.service.resources.ResourceManagementService;
import org.jitsi.util.OSUtils;

public class CertificateServiceImpl
implements CertificateService,
PropertyChangeListener {
    private final List<KeyStoreType> supportedTypes = new LinkedList<KeyStoreType>(){
        private static final long serialVersionUID = 0L;
        {
            if (!OSUtils.IS_WINDOWS64) {
                this.add(new KeyStoreType("PKCS11", new String[]{".dll", ".so"}, false));
            }
            this.add(new KeyStoreType("PKCS12", new String[]{".p12", ".pfx"}, true));
            this.add(new KeyStoreType(KeyStore.getDefaultType(), new String[]{".ks", ".jks"}, true));
        }
    };
    private static final Logger logger = Logger.getLogger(CertificateServiceImpl.class);
    private final ResourceManagementService R = CertificateVerificationActivator.getResources();
    private final ConfigurationService config = CertificateVerificationActivator.getConfigurationService();
    private final CredentialsStorageService credService = CertificateVerificationActivator.getCredService();
    private static final String PNAME_CERT_TRUST_PREFIX = "net.java.sip.communicator.impl.certservice";
    private static final String THUMBPRINT_HASH_ALGORITHM = "SHA1";
    private Map<String, List<String>> sessionAllowedCertificates = new HashMap<String, List<String>>();
    private Map<URI, AiaCacheEntry> aiaCache = new HashMap<URI, AiaCacheEntry>();

    private List<String> getSessionCertEntry(String propName) {
        List<String> entry = this.sessionAllowedCertificates.get(propName);
        if (entry == null) {
            entry = new LinkedList<String>();
            this.sessionAllowedCertificates.put(propName, entry);
        }
        return entry;
    }

    public CertificateServiceImpl() {
        this.setTrustStore();
        this.config.addPropertyChangeListener("net.java.sip.communicator.service.cert.truststore.type", (PropertyChangeListener)this);
        System.setProperty("com.sun.security.enableCRLDP", this.config.getString("net.java.sip.communicator.service.cert.revocation.enabled", "false"));
        System.setProperty("com.sun.net.ssl.checkRevocation", this.config.getString("net.java.sip.communicator.service.cert.revocation.enabled", "false"));
        Security.setProperty("ocsp.enable", this.config.getString("net.java.sip.communicator.service.cert.ocsp.enabled", "false"));
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.setTrustStore();
    }

    private void setTrustStore() {
        String tsType = (String)this.config.getProperty("net.java.sip.communicator.service.cert.truststore.type");
        String tsFile = (String)this.config.getProperty("net.java.sip.communicator.service.cert.truststore.file");
        String tsPassword = this.credService.loadPassword("net.java.sip.communicator.service.cert.truststore.password");
        if (tsType == null && !"meta:default".equals(tsType) && OSUtils.IS_WINDOWS) {
            tsType = "Windows-ROOT";
            this.config.setProperty("net.java.sip.communicator.service.cert.truststore.type", (Object)tsType);
        }
        if (tsType != null && !"meta:default".equals(tsType)) {
            System.setProperty("javax.net.ssl.trustStoreType", tsType);
        } else {
            System.getProperties().remove("javax.net.ssl.trustStoreType");
        }
        if (tsFile != null) {
            System.setProperty("javax.net.ssl.trustStore", tsFile);
        } else {
            System.getProperties().remove("javax.net.ssl.trustStore");
        }
        if (tsPassword != null) {
            System.setProperty("javax.net.ssl.trustStorePassword", tsPassword);
        } else {
            System.getProperties().remove("javax.net.ssl.trustStorePassword");
        }
    }

    @Override
    public List<KeyStoreType> getSupportedKeyStoreTypes() {
        return this.supportedTypes;
    }

    @Override
    public List<CertificateConfigEntry> getClientAuthCertificateConfigs() {
        LinkedList<CertificateConfigEntry> map = new LinkedList<CertificateConfigEntry>();
        for (String propName : this.config.getPropertyNamesByPrefix("net.java.sip.communicator.service.cert.clientauth", false)) {
            String propValue = this.config.getString(propName);
            if (propValue == null || !propName.endsWith(propValue)) continue;
            String pnBase = "net.java.sip.communicator.service.cert.clientauth." + propValue;
            CertificateConfigEntry e = new CertificateConfigEntry();
            e.setId(propValue);
            e.setAlias(this.config.getString(pnBase + ".alias"));
            e.setDisplayName(this.config.getString(pnBase + ".displayName"));
            e.setKeyStore(this.config.getString(pnBase + ".keyStore"));
            e.setSavePassword(this.config.getBoolean(pnBase + ".savePassword", false));
            if (e.isSavePassword()) {
                e.setKeyStorePassword(this.credService.loadPassword(pnBase));
            }
            String type = this.config.getString(pnBase + ".keyStoreType");
            for (KeyStoreType kt : this.getSupportedKeyStoreTypes()) {
                if (!kt.getName().equals(type)) continue;
                e.setKeyStoreType(kt);
                break;
            }
            map.add(e);
        }
        return map;
    }

    @Override
    public void setClientAuthCertificateConfig(CertificateConfigEntry e) {
        if (e.getId() == null) {
            e.setId("conf" + Math.abs(new Random().nextInt()));
        }
        String pn = "net.java.sip.communicator.service.cert.clientauth." + e.getId();
        this.config.setProperty(pn, (Object)e.getId());
        this.config.setProperty(pn + ".alias", (Object)e.getAlias());
        this.config.setProperty(pn + ".displayName", (Object)e.getDisplayName());
        this.config.setProperty(pn + ".keyStore", (Object)e.getKeyStore());
        this.config.setProperty(pn + ".savePassword", (Object)e.isSavePassword());
        if (e.isSavePassword()) {
            this.credService.storePassword(pn, e.getKeyStorePassword());
        } else {
            this.credService.removePassword(pn);
        }
        this.config.setProperty(pn + ".keyStoreType", (Object)e.getKeyStoreType());
    }

    @Override
    public void removeClientAuthCertificateConfig(String id) {
        for (String p : this.config.getPropertyNamesByPrefix("net.java.sip.communicator.service.cert.clientauth." + id, true)) {
            this.config.removeProperty(p);
        }
        this.config.removeProperty("net.java.sip.communicator.service.cert.clientauth." + id);
    }

    @Override
    public void addCertificateToTrust(Certificate cert, String trustFor, int trustMode) throws CertificateException {
        String propName = "net.java.sip.communicator.impl.certservice.param." + trustFor;
        String thumbprint = CertificateServiceImpl.getThumbprint(cert, THUMBPRINT_HASH_ALGORITHM);
        switch (trustMode) {
            case 0: {
                throw new IllegalArgumentException("Cannot add a certificate to trust when no trust is requested.");
            }
            case 1: {
                String current = this.config.getString(propName);
                String newValue = thumbprint;
                if (current != null) {
                    newValue = newValue + "," + thumbprint;
                }
                this.config.setProperty(propName, (Object)newValue);
                break;
            }
            case 2: {
                this.getSessionCertEntry(propName).add(thumbprint);
            }
        }
    }

    @Override
    public SSLContext getSSLContext() throws GeneralSecurityException {
        return this.getSSLContext(this.getTrustManager((Iterable<String>)null));
    }

    @Override
    public SSLContext getSSLContext(X509TrustManager trustManager) throws GeneralSecurityException {
        try {
            KeyStore ks = KeyStore.getInstance(System.getProperty("javax.net.ssl.keyStoreType", KeyStore.getDefaultType()));
            KeyManagerFactory kmFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            String keyStorePassword = System.getProperty("javax.net.ssl.keyStorePassword");
            if (System.getProperty("javax.net.ssl.keyStore") != null) {
                ks.load(new FileInputStream(System.getProperty("javax.net.ssl.keyStore")), null);
            } else {
                ks.load(null, null);
            }
            kmFactory.init(ks, keyStorePassword == null ? null : keyStorePassword.toCharArray());
            return this.getSSLContext(kmFactory.getKeyManagers(), trustManager);
        }
        catch (Exception e) {
            throw new GeneralSecurityException("Cannot init SSLContext", e);
        }
    }

    private KeyStore.Builder loadKeyStore(final CertificateConfigEntry entry) throws KeyStoreException {
        final File f = new File(entry.getKeyStore());
        final KeyStoreType kt = entry.getKeyStoreType();
        if ("PKCS11".equals(kt.getName())) {
            String config = "name=" + f.getName() + "\nlibrary=" + f.getAbsoluteFile();
            try {
                Class<?> pkcs11c = Class.forName("sun.security.pkcs11.SunPKCS11");
                Constructor<?> c = pkcs11c.getConstructor(InputStream.class);
                Provider p = (Provider)c.newInstance(new ByteArrayInputStream(config.getBytes()));
                Security.insertProviderAt(p, 0);
            }
            catch (Exception e) {
                logger.error((Object)"Tried to access the PKCS11 provider on an unsupported platform or the load failed", (Throwable)e);
            }
        }
        KeyStore.Builder ksBuilder = KeyStore.Builder.newInstance(kt.getName(), null, f, new KeyStore.CallbackHandlerProtection(new CallbackHandler(){

            @Override
            public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
                for (Callback cb : callbacks) {
                    if (!(cb instanceof PasswordCallback)) {
                        throw new UnsupportedCallbackException(cb);
                    }
                    PasswordCallback pwcb = (PasswordCallback)cb;
                    if (entry.isSavePassword()) {
                        pwcb.setPassword(entry.getKeyStorePassword().toCharArray());
                        return;
                    }
                    AuthenticationWindowService authenticationWindowService = CertificateVerificationActivator.getAuthenticationWindowService();
                    if (authenticationWindowService == null) {
                        logger.error((Object)"No AuthenticationWindowService implementation");
                        throw new IOException("User cancel");
                    }
                    AuthenticationWindowService.AuthenticationWindow aw = authenticationWindowService.create(f.getName(), null, kt.getName(), false, false, null, null, null, null, null, null, null);
                    aw.setAllowSavePassword(false);
                    aw.setVisible(true);
                    if (aw.isCanceled()) {
                        throw new IOException("User cancel");
                    }
                    pwcb.setPassword(aw.getPassword());
                }
            }
        }));
        return ksBuilder;
    }

    @Override
    public SSLContext getSSLContext(String clientCertConfig, X509TrustManager trustManager) throws GeneralSecurityException {
        try {
            if (clientCertConfig == null) {
                return this.getSSLContext(trustManager);
            }
            CertificateConfigEntry entry = null;
            for (CertificateConfigEntry e : this.getClientAuthCertificateConfigs()) {
                if (!e.getId().equals(clientCertConfig)) continue;
                entry = e;
                break;
            }
            if (entry == null) {
                throw new GeneralSecurityException("Client certificate config with id <" + clientCertConfig + "> not found.");
            }
            KeyManagerFactory kmf = KeyManagerFactory.getInstance("NewSunX509");
            kmf.init(new KeyStoreBuilderParameters(this.loadKeyStore(entry)));
            return this.getSSLContext(kmf.getKeyManagers(), trustManager);
        }
        catch (Exception e) {
            throw new GeneralSecurityException("Cannot init SSLContext", e);
        }
    }

    @Override
    public SSLContext getSSLContext(KeyManager[] keyManagers, X509TrustManager trustManager) throws GeneralSecurityException {
        try {
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(keyManagers, new TrustManager[]{trustManager}, null);
            return sslContext;
        }
        catch (Exception e) {
            throw new GeneralSecurityException("Cannot init SSLContext", e);
        }
    }

    @Override
    public X509TrustManager getTrustManager(Iterable<String> identitiesToTest) throws GeneralSecurityException {
        return this.getTrustManager(identitiesToTest, (CertificateMatcher)new EMailAddressMatcher(), (CertificateMatcher)new BrowserLikeHostnameMatcher());
    }

    @Override
    public X509TrustManager getTrustManager(String identityToTest) throws GeneralSecurityException {
        return this.getTrustManager(Arrays.asList(identityToTest), (CertificateMatcher)new EMailAddressMatcher(), (CertificateMatcher)new BrowserLikeHostnameMatcher());
    }

    @Override
    public X509TrustManager getTrustManager(String identityToTest, CertificateMatcher clientVerifier, CertificateMatcher serverVerifier) throws GeneralSecurityException {
        return this.getTrustManager(Arrays.asList(identityToTest), clientVerifier, serverVerifier);
    }

    @Override
    public X509TrustManager getTrustManager(final Iterable<String> identitiesToTest, final CertificateMatcher clientVerifier, final CertificateMatcher serverVerifier) throws GeneralSecurityException {
        X509TrustManager defaultTm = null;
        TrustManagerFactory tmFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        KeyStore ks = null;
        String tsType = System.getProperty("javax.net.ssl.trustStoreType", null);
        if ("Windows-ROOT".equals(tsType)) {
            try {
                ks = KeyStore.getInstance(tsType);
                ks.load(null, null);
            }
            catch (Exception e) {
                logger.error((Object)"Could not rename Windows-ROOT aliases", (Throwable)e);
            }
        }
        tmFactory.init(ks);
        for (TrustManager m : tmFactory.getTrustManagers()) {
            if (!(m instanceof X509TrustManager)) continue;
            defaultTm = (X509TrustManager)m;
            break;
        }
        if (defaultTm == null) {
            throw new GeneralSecurityException("No default X509 trust manager found");
        }
        final X509TrustManager tm = defaultTm;
        return new X509TrustManager(){
            private boolean serverCheck;

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return tm.getAcceptedIssuers();
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                this.serverCheck = true;
                this.checkCertTrusted(chain, authType);
            }

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                this.serverCheck = false;
                this.checkCertTrusted(chain, authType);
            }

            private void checkCertTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                block26: {
                    String defaultAlwaysTrustMode = CertificateVerificationActivator.getResources().getSettingsString("net.java.sip.communicator.service.gui.ALWAYS_TRUST_MODE_ENABLED");
                    if (CertificateServiceImpl.this.config.getBoolean("net.java.sip.communicator.service.gui.ALWAYS_TRUST_MODE_ENABLED", Boolean.parseBoolean(defaultAlwaysTrustMode))) {
                        return;
                    }
                    try {
                        try {
                            chain = this.tryBuildChain(chain);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (this.serverCheck) {
                            tm.checkServerTrusted(chain, authType);
                        } else {
                            tm.checkClientTrusted(chain, authType);
                        }
                        if (identitiesToTest == null || !identitiesToTest.iterator().hasNext()) {
                            return;
                        }
                        if (this.serverCheck) {
                            serverVerifier.verify(identitiesToTest, chain[0]);
                        } else {
                            clientVerifier.verify(identitiesToTest, chain[0]);
                        }
                    }
                    catch (CertificateException e) {
                        String thumbprint = CertificateServiceImpl.getThumbprint(chain[0], CertificateServiceImpl.THUMBPRINT_HASH_ALGORITHM);
                        String message = null;
                        LinkedList<String> propNames = new LinkedList<String>();
                        LinkedList<String> storedCerts = new LinkedList<String>();
                        String appName = CertificateServiceImpl.this.R.getSettingsString("service.gui.APPLICATION_NAME");
                        if (identitiesToTest == null || !identitiesToTest.iterator().hasNext()) {
                            List sessionCerts;
                            String propName = "net.java.sip.communicator.impl.certservice.server." + thumbprint;
                            propNames.add(propName);
                            message = CertificateServiceImpl.this.R.getI18NString("service.gui.CERT_DIALOG_DESCRIPTION_TXT_NOHOST", new String[]{appName});
                            String hashes = CertificateServiceImpl.this.config.getString(propName);
                            if (hashes != null) {
                                for (String h : hashes.split(",")) {
                                    storedCerts.add(h);
                                }
                            }
                            if ((sessionCerts = (List)CertificateServiceImpl.this.sessionAllowedCertificates.get(propName)) != null) {
                                storedCerts.addAll(sessionCerts);
                            }
                        } else {
                            message = this.serverCheck ? CertificateServiceImpl.this.R.getI18NString("service.gui.CERT_DIALOG_DESCRIPTION_TXT", new String[]{appName, identitiesToTest.toString()}) : CertificateServiceImpl.this.R.getI18NString("service.gui.CERT_DIALOG_PEER_DESCRIPTION_TXT", new String[]{appName, identitiesToTest.toString()});
                            for (String identity : identitiesToTest) {
                                List sessionCerts;
                                String propName = "net.java.sip.communicator.impl.certservice.param." + identity;
                                propNames.add(propName);
                                String hashes = CertificateServiceImpl.this.config.getString(propName);
                                if (hashes != null) {
                                    for (String h : hashes.split(",")) {
                                        storedCerts.add(h);
                                    }
                                }
                                if ((sessionCerts = (List)CertificateServiceImpl.this.sessionAllowedCertificates.get(propName)) == null) continue;
                                storedCerts.addAll(sessionCerts);
                            }
                        }
                        if (storedCerts.contains(thumbprint)) break block26;
                        switch (CertificateServiceImpl.this.verify(chain, message)) {
                            case 0: {
                                logger.info((Object)"Untrusted certificate", (Throwable)e);
                                throw new CertificateException("The peer provided certificate with Subject <" + chain[0].getSubjectDN() + "> is not trusted", e);
                            }
                            case 1: {
                                for (String propName : propNames) {
                                    String current = CertificateServiceImpl.this.config.getString(propName);
                                    String newValue = thumbprint;
                                    if (current != null) {
                                        newValue = newValue + "," + current;
                                    }
                                    CertificateServiceImpl.this.config.setProperty(propName, (Object)newValue);
                                }
                                break;
                            }
                            case 2: {
                                for (String propName : propNames) {
                                    CertificateServiceImpl.this.getSessionCertEntry(propName).add(thumbprint);
                                }
                                break;
                            }
                        }
                    }
                }
            }

            private X509Certificate[] tryBuildChain(X509Certificate[] chain) throws IOException, URISyntaxException, CertificateException {
                boolean foundParent;
                if (chain.length != 1) {
                    return chain;
                }
                if (chain[0].getIssuerDN().equals(chain[0].getSubjectDN())) {
                    return chain;
                }
                ArrayList<X509Certificate> newChain = new ArrayList<X509Certificate>(chain.length + 4);
                for (X509Certificate cert : chain) {
                    newChain.add(cert);
                }
                CertificateFactory certFactory = CertificateFactory.getInstance("X.509");
                X509Certificate current = chain[chain.length - 1];
                int chainLookupCount = 0;
                block3: do {
                    foundParent = false;
                    byte[] aiaBytes = current.getExtensionValue(Extension.authorityInfoAccess.getId());
                    if (aiaBytes == null) break;
                    AuthorityInformationAccess aia = AuthorityInformationAccess.getInstance((Object)X509ExtensionUtil.fromExtensionValue((byte[])aiaBytes));
                    for (AccessDescription ad : aia.getAccessDescriptions()) {
                        URI uri;
                        GeneralName gn;
                        if (!ad.getAccessMethod().equals((Object)AccessDescription.id_ad_caIssuers) || (gn = ad.getAccessLocation()).getTagNo() != 6 || !(gn.getName() instanceof DERIA5String) || !(uri = new URI(((DERIA5String)gn.getName()).getString())).getScheme().equalsIgnoreCase("http") && !uri.getScheme().equals("https")) continue;
                        X509Certificate cert = null;
                        AiaCacheEntry cache = (AiaCacheEntry)CertificateServiceImpl.this.aiaCache.get(uri);
                        if (cache != null && cache.cacheDate.after(new Date())) {
                            cert = cache.cert;
                        } else {
                            if (logger.isDebugEnabled()) {
                                logger.debug((Object)("Downloading parent certificate for <" + current.getSubjectDN() + "> from <" + uri + ">"));
                            }
                            try {
                                InputStream is = HttpUtils.openURLConnection((String)uri.toString()).getContent();
                                cert = (X509Certificate)certFactory.generateCertificate(is);
                            }
                            catch (Exception e) {
                                logger.debug((Object)("Could not download from <" + uri + ">"));
                            }
                            CertificateServiceImpl.this.aiaCache.put(uri, new AiaCacheEntry(new Date(new Date().getTime() + 600000L), cert));
                        }
                        if (cert == null) continue;
                        if (!cert.getIssuerDN().equals(cert.getSubjectDN())) {
                            newChain.add(cert);
                            foundParent = true;
                            current = cert;
                            continue block3;
                        }
                        logger.debug((Object)"Parent is self-signed, ignoring");
                    }
                } while (foundParent && ++chainLookupCount < 10);
                chain = newChain.toArray(chain);
                return chain;
            }
        };
    }

    protected int verify(X509Certificate[] chain, String message) {
        if (this.config.getBoolean("net.java.sip.communicator.service.tls.NO_USER_INTERACTION", false)) {
            return 0;
        }
        if (CertificateVerificationActivator.getCertificateDialogService() == null) {
            logger.error((Object)"Missing CertificateDialogService by default will not trust!");
            return 0;
        }
        VerifyCertificateDialogService.VerifyCertificateDialog dialog = CertificateVerificationActivator.getCertificateDialogService().createDialog(chain, null, message);
        dialog.setVisible(true);
        if (!dialog.isTrusted()) {
            return 0;
        }
        if (dialog.isAlwaysTrustSelected()) {
            return 1;
        }
        return 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getThumbprint(Certificate cert, String algorithm) throws CertificateException {
        MessageDigest digest;
        try {
            digest = MessageDigest.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new CertificateException(e);
        }
        byte[] encodedCert = cert.getEncoded();
        StringBuilder sb = new StringBuilder(encodedCert.length * 2);
        try (Formatter f = new Formatter(sb);){
            for (byte b : digest.digest(encodedCert)) {
                f.format("%02x", b);
            }
        }
        return sb.toString();
    }

    private static Iterable<String> getSubjectAltNames(X509Certificate cert, int altNameType) {
        Collection<List<?>> altNames = null;
        try {
            altNames = cert.getSubjectAlternativeNames();
        }
        catch (CertificateParsingException e) {
            return Collections.emptyList();
        }
        LinkedList<String> matchedAltNames = new LinkedList<String>();
        for (List<?> item : altNames) {
            Integer type;
            if (!item.contains(altNameType) || (type = (Integer)item.get(0)) != altNameType) continue;
            matchedAltNames.add((String)item.get(1));
        }
        return matchedAltNames;
    }

    protected class EMailAddressMatcher
    implements CertificateMatcher {
        protected EMailAddressMatcher() {
        }

        @Override
        public void verify(Iterable<String> identitiesToTest, X509Certificate cert) throws CertificateException {
            boolean oneMatched = false;
            Iterable emails = CertificateServiceImpl.getSubjectAltNames(cert, 6);
            block0: for (String identity : identitiesToTest) {
                for (String email : emails) {
                    if (!identity.equalsIgnoreCase(email)) continue;
                    oneMatched = true;
                    continue block0;
                }
            }
            if (!oneMatched) {
                throw new CertificateException("The peer provided certificate with Subject <" + cert.getSubjectDN() + "> contains no SAN for <" + identitiesToTest + ">");
            }
        }
    }

    protected class BrowserLikeHostnameMatcher
    implements CertificateMatcher {
        protected BrowserLikeHostnameMatcher() {
        }

        @Override
        public void verify(Iterable<String> identitiesToTest, X509Certificate cert) throws CertificateException {
            boolean oneMatched = false;
            for (String identity : identitiesToTest) {
                try {
                    SSLSocketFactory.BROWSER_COMPATIBLE_HOSTNAME_VERIFIER.verify(identity, cert);
                    oneMatched = true;
                    break;
                }
                catch (SSLException sSLException) {
                }
            }
            if (!oneMatched) {
                throw new CertificateException("None of <" + identitiesToTest + "> matched the cert with CN=" + cert.getSubjectDN());
            }
        }
    }

    private static class AiaCacheEntry {
        Date cacheDate;
        X509Certificate cert;

        AiaCacheEntry(Date cacheDate, X509Certificate cert) {
            this.cacheDate = cacheDate;
            this.cert = cert;
        }
    }
}

