/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.desktoputil;

import java.awt.AWTEvent;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.awt.event.InvocationEvent;

public class LowPriorityEventQueue {
    public static Runnable createRepetitiveInvokeLater(final Runnable runnable) {
        return new Runnable(){
            private AWTEvent event;
            private EventQueue eventQueue;
            private boolean posted = false;

            @Override
            public synchronized void run() {
                if (this.posted) {
                    return;
                }
                if (this.event == null) {
                    Toolkit defaultToolkit = Toolkit.getDefaultToolkit();
                    this.eventQueue = defaultToolkit.getSystemEventQueue();
                    this.event = new LowPriorityInvocationEvent((Object)defaultToolkit, new Runnable(){

                        @Override
                        public void run() {
                            this.runInEvent();
                        }
                    });
                }
                this.eventQueue.postEvent(this.event);
                this.posted = true;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void runInEvent() {
                1 var1_1 = this;
                synchronized (var1_1) {
                    this.posted = false;
                }
                runnable.run();
            }
        };
    }

    public static void invokeLater(Runnable runnable) {
        Toolkit defaultToolkit = Toolkit.getDefaultToolkit();
        defaultToolkit.getSystemEventQueue().postEvent(new LowPriorityInvocationEvent((Object)defaultToolkit, runnable));
    }

    private static class LowPriorityInvocationEvent
    extends InvocationEvent {
        private static final long serialVersionUID = 0L;

        public LowPriorityInvocationEvent(Object source, Runnable runnable) {
            super(source, 801, runnable, null, false);
        }
    }
}

