/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.desktoputil;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.UndeclaredThrowableException;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import net.java.sip.communicator.plugin.desktoputil.DesktopUtilActivator;
import net.java.sip.communicator.plugin.desktoputil.SIPCommCheckBox;
import net.java.sip.communicator.plugin.desktoputil.SIPCommDialog;
import net.java.sip.communicator.plugin.desktoputil.StyledHTMLEditorPane;
import net.java.sip.communicator.plugin.desktoputil.TransparentPanel;
import net.java.sip.communicator.util.skin.Skinnable;

public class MessageDialog
extends SIPCommDialog
implements ActionListener,
Skinnable {
    private static final long serialVersionUID = 1L;
    private JButton cancelButton = new JButton(DesktopUtilActivator.getResources().getI18NString("service.gui.CANCEL"));
    protected JButton okButton = new JButton(DesktopUtilActivator.getResources().getI18NString("service.gui.OK"));
    protected JCheckBox doNotAskAgain = new SIPCommCheckBox(DesktopUtilActivator.getResources().getI18NString("service.gui.DO_NOT_ASK_AGAIN"));
    private JLabel iconLabel = new JLabel(new ImageIcon(DesktopUtilActivator.getImage("service.gui.icons.WARNING_ICON")));
    private StyledHTMLEditorPane messageArea = new StyledHTMLEditorPane();
    private TransparentPanel buttonsPanel = new TransparentPanel(new FlowLayout(1));
    protected TransparentPanel checkBoxPanel = new TransparentPanel(new FlowLayout(3));
    private TransparentPanel mainPanel = new TransparentPanel(new BorderLayout(5, 5));
    private boolean isConfirmationEnabled = true;
    protected int returnCode;
    public static final int OK_RETURN_CODE = 0;
    public static final int CANCEL_RETURN_CODE = 1;
    public static final int OK_DONT_ASK_CODE = 2;
    private static final int MAX_MSG_PANE_WIDTH = 600;
    private static final int MAX_MSG_PANE_HEIGHT = 800;

    public MessageDialog(Frame owner, String title, String message, String okButtonName, boolean isConfirmationEnabled) {
        super(owner, false);
        this.isConfirmationEnabled = isConfirmationEnabled;
        this.getContentPane().setLayout(new BorderLayout(5, 5));
        this.messageArea.setOpaque(false);
        this.messageArea.setEditable(false);
        this.messageArea.setContentType("text/html");
        this.messageArea.setBorder(BorderFactory.createEmptyBorder(10, 10, 0, 10));
        this.checkBoxPanel.setBorder(BorderFactory.createEmptyBorder(0, 10, 10, 10));
        this.init();
        this.setTitle(title);
        this.setMessage(message);
        if (okButtonName != null) {
            this.okButton.setText(okButtonName);
            this.okButton.setMnemonic(okButtonName.charAt(0));
        }
    }

    public MessageDialog(Frame owner, String title, String message, String okButtonName) {
        this(owner, title, message, okButtonName, true);
    }

    public MessageDialog(Frame owner, String title, String message, boolean isCancelButtonEnabled) {
        this(owner, title, message, null, true);
        if (!isCancelButtonEnabled) {
            this.doNotAskAgain.setText(DesktopUtilActivator.getResources().getI18NString("service.gui.DO_NOT_SHOW_AGAIN"));
            this.buttonsPanel.remove(this.cancelButton);
        }
    }

    private void init() {
        this.getRootPane().setDefaultButton(this.okButton);
        if (this.isConfirmationEnabled) {
            this.checkBoxPanel.add(this.doNotAskAgain);
        }
        this.buttonsPanel.add(this.okButton);
        this.buttonsPanel.add(this.cancelButton);
        this.okButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        this.cancelButton.setMnemonic(this.cancelButton.getText().charAt(0));
        this.mainPanel.add(this.messageArea, "North");
        this.mainPanel.add((Component)((Object)this.checkBoxPanel), "Center");
        TransparentPanel iconPanel = new TransparentPanel(new BorderLayout());
        iconPanel.setBorder(BorderFactory.createEmptyBorder(15, 15, 15, 0));
        iconPanel.add(this.iconLabel, "North");
        this.getContentPane().add((Component)((Object)iconPanel), "West");
        this.getContentPane().add((Component)((Object)this.mainPanel), "Center");
        this.getContentPane().add((Component)((Object)this.buttonsPanel), "South");
    }

    public void replaceCheckBoxPanel(Component comp) {
        this.mainPanel.add(comp, "Center");
    }

    public void setMessage(String message) {
        this.messageArea.setText(message);
        this.setMaxWidth(600);
    }

    public void setMaxWidth(int maxWidth) {
        this.messageArea.setSize(new Dimension(600, 800));
        int height = this.messageArea.getPreferredSize().height;
        this.messageArea.setPreferredSize(new Dimension(maxWidth, height));
    }

    public int showDialog() {
        if (!SwingUtilities.isEventDispatchThread()) {
            final int[] returnCodes = new int[1];
            Exception exception = null;
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        returnCodes[0] = MessageDialog.this.showDialog();
                    }
                });
            }
            catch (InterruptedException ex) {
                exception = ex;
            }
            catch (InvocationTargetException ex) {
                exception = ex;
            }
            if (exception != null) {
                throw new UndeclaredThrowableException(exception);
            }
            return returnCodes[0];
        }
        this.pack();
        this.setModal(true);
        this.setVisible(true);
        return this.returnCode;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JButton button = (JButton)e.getSource();
        this.returnCode = button.equals(this.okButton) ? (this.doNotAskAgain.isSelected() ? 2 : 0) : 1;
        this.dispose();
    }

    @Override
    protected void close(boolean isEscaped) {
        this.cancelButton.doClick();
    }

    public void loadSkin() {
        this.iconLabel.setIcon(new ImageIcon(DesktopUtilActivator.getImage("service.gui.icons.WARNING_ICON")));
    }

    public void setIcon(Image image) {
        this.iconLabel.setIcon(new ImageIcon(image));
    }

    public void setIcon(ImageIcon image) {
        this.iconLabel.setIcon(image);
    }
}

