/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.datasink;

import java.util.Vector;
import javax.media.DataSink;
import javax.media.datasink.DataSinkErrorEvent;
import javax.media.datasink.DataSinkEvent;
import javax.media.datasink.DataSinkListener;
import javax.media.datasink.EndOfStreamEvent;

public abstract class BasicDataSink
implements DataSink {
    protected final Vector<DataSinkListener> listeners = new Vector(1);

    @Override
    public void addDataSinkListener(DataSinkListener dsl) {
        if (dsl != null && !this.listeners.contains(dsl)) {
            this.listeners.addElement(dsl);
        }
    }

    protected void removeAllListeners() {
        this.listeners.removeAllElements();
    }

    @Override
    public void removeDataSinkListener(DataSinkListener dsl) {
        if (dsl != null) {
            this.listeners.removeElement(dsl);
        }
    }

    protected final void sendDataSinkErrorEvent(String reason) {
        this.sendEvent(new DataSinkErrorEvent(this, reason));
    }

    protected final void sendEndofStreamEvent() {
        this.sendEvent(new EndOfStreamEvent(this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendEvent(DataSinkEvent event) {
        if (!this.listeners.isEmpty()) {
            Vector<DataSinkListener> vector = this.listeners;
            synchronized (vector) {
                for (DataSinkListener listener : this.listeners) {
                    listener.dataSinkUpdate(event);
                }
            }
        }
    }
}

