/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.filehistory;

import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeSet;
import net.java.sip.communicator.service.contactlist.MetaContact;
import net.java.sip.communicator.service.filehistory.FileHistoryService;
import net.java.sip.communicator.service.filehistory.FileRecord;
import net.java.sip.communicator.service.history.History;
import net.java.sip.communicator.service.history.HistoryID;
import net.java.sip.communicator.service.history.HistoryReader;
import net.java.sip.communicator.service.history.HistoryService;
import net.java.sip.communicator.service.history.HistoryWriter;
import net.java.sip.communicator.service.history.QueryResultSet;
import net.java.sip.communicator.service.history.records.HistoryRecord;
import net.java.sip.communicator.service.history.records.HistoryRecordStructure;
import net.java.sip.communicator.service.protocol.Contact;
import net.java.sip.communicator.service.protocol.FileTransfer;
import net.java.sip.communicator.service.protocol.IncomingFileTransferRequest;
import net.java.sip.communicator.service.protocol.OperationSetFileTransfer;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import net.java.sip.communicator.service.protocol.event.FileTransferCreatedEvent;
import net.java.sip.communicator.service.protocol.event.FileTransferListener;
import net.java.sip.communicator.service.protocol.event.FileTransferRequestEvent;
import net.java.sip.communicator.service.protocol.event.FileTransferStatusChangeEvent;
import net.java.sip.communicator.service.protocol.event.FileTransferStatusListener;
import net.java.sip.communicator.util.Logger;
import net.java.sip.communicator.util.ServiceUtils;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;

public class FileHistoryServiceImpl
implements FileHistoryService,
ServiceListener,
FileTransferStatusListener,
FileTransferListener {
    private static final Logger logger = Logger.getLogger(FileHistoryServiceImpl.class);
    private static String[] STRUCTURE_NAMES = new String[]{"file", "dir", "date", "status", "id"};
    private static final String FILE_TRANSFER_ACTIVE = "active";
    private static HistoryRecordStructure recordStructure = new HistoryRecordStructure(STRUCTURE_NAMES);
    private static final String SEARCH_FIELD = "file";
    private BundleContext bundleContext = null;
    private HistoryService historyService = null;

    public void start(BundleContext bc) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Starting the file history implementation.");
        }
        this.bundleContext = bc;
        bc.addServiceListener((ServiceListener)this);
        Collection ppsRefs = ServiceUtils.getServiceReferences((BundleContext)bc, ProtocolProviderService.class);
        if (!ppsRefs.isEmpty()) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Found " + ppsRefs.size() + " already installed providers."));
            }
            for (ServiceReference ppsRef : ppsRefs) {
                ProtocolProviderService pps = (ProtocolProviderService)bc.getService(ppsRef);
                this.handleProviderAdded(pps);
            }
        }
    }

    public void stop(BundleContext bc) {
        bc.removeServiceListener((ServiceListener)this);
        Collection ppsRefs = ServiceUtils.getServiceReferences((BundleContext)bc, ProtocolProviderService.class);
        if (!ppsRefs.isEmpty()) {
            for (ServiceReference ppsRef : ppsRefs) {
                ProtocolProviderService pps = (ProtocolProviderService)bc.getService(ppsRef);
                this.handleProviderRemoved(pps);
            }
        }
    }

    private void handleProviderAdded(ProtocolProviderService provider) {
        OperationSetFileTransfer opSetFileTransfer;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Adding protocol provider " + provider.getProtocolName()));
        }
        if ((opSetFileTransfer = (OperationSetFileTransfer)provider.getOperationSet(OperationSetFileTransfer.class)) != null) {
            opSetFileTransfer.addFileTransferListener((FileTransferListener)this);
        } else if (logger.isTraceEnabled()) {
            logger.trace((Object)"Service did not have a file transfer op. set.");
        }
    }

    private void handleProviderRemoved(ProtocolProviderService provider) {
        OperationSetFileTransfer opSetFileTransfer = (OperationSetFileTransfer)provider.getOperationSet(OperationSetFileTransfer.class);
        if (opSetFileTransfer != null) {
            opSetFileTransfer.addFileTransferListener((FileTransferListener)this);
        }
    }

    public void setHistoryService(HistoryService historyService) {
        this.historyService = historyService;
    }

    private Map<Contact, HistoryReader> getHistoryReaders(MetaContact contact) {
        Hashtable<Contact, HistoryReader> readers = new Hashtable<Contact, HistoryReader>();
        Iterator iter = contact.getContacts();
        while (iter.hasNext()) {
            Contact item = (Contact)iter.next();
            try {
                History history = this.getHistory(null, item);
                readers.put(item, history.getReader());
            }
            catch (IOException e) {
                logger.error((Object)"Could not read history", (Throwable)e);
            }
        }
        return readers;
    }

    private FileRecord createFileRecordFromHistoryRecord(HistoryRecord hr, Contact contact) {
        String file = null;
        String dir = null;
        Date date = new Date(0L);
        String status = null;
        String id = null;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
        for (int i = 0; i < hr.getPropertyNames().length; ++i) {
            String propName = hr.getPropertyNames()[i];
            if (propName.equals(STRUCTURE_NAMES[0])) {
                file = hr.getPropertyValues()[i];
                continue;
            }
            if (propName.equals(STRUCTURE_NAMES[1])) {
                dir = hr.getPropertyValues()[i];
                continue;
            }
            if (propName.equals(STRUCTURE_NAMES[2])) {
                try {
                    date = sdf.parse(hr.getPropertyValues()[i]);
                }
                catch (ParseException e) {
                    date = new Date(Long.valueOf(hr.getPropertyValues()[i]));
                }
                continue;
            }
            if (propName.equals(STRUCTURE_NAMES[3])) {
                status = hr.getPropertyValues()[i];
                continue;
            }
            if (!propName.equals(STRUCTURE_NAMES[4])) continue;
            id = hr.getPropertyValues()[i];
        }
        return new FileRecord(id, contact, dir, date, new File(file), status);
    }

    @Override
    public Collection<FileRecord> findByStartDate(MetaContact contact, Date startDate) throws RuntimeException {
        TreeSet<FileRecord> result = new TreeSet<FileRecord>(new FileRecordComparator());
        Map<Contact, HistoryReader> readers = this.getHistoryReaders(contact);
        for (Map.Entry<Contact, HistoryReader> readerEntry : readers.entrySet()) {
            Contact c = readerEntry.getKey();
            HistoryReader reader = readerEntry.getValue();
            QueryResultSet recs = reader.findByStartDate(startDate);
            while (recs.hasNext()) {
                result.add(this.createFileRecordFromHistoryRecord((HistoryRecord)recs.next(), c));
            }
        }
        return result;
    }

    @Override
    public Collection<FileRecord> findByEndDate(MetaContact contact, Date endDate) throws RuntimeException {
        TreeSet<FileRecord> result = new TreeSet<FileRecord>(new FileRecordComparator());
        Map<Contact, HistoryReader> readers = this.getHistoryReaders(contact);
        for (Map.Entry<Contact, HistoryReader> readerEntry : readers.entrySet()) {
            Contact c = readerEntry.getKey();
            HistoryReader reader = readerEntry.getValue();
            QueryResultSet recs = reader.findByEndDate(endDate);
            while (recs.hasNext()) {
                result.add(this.createFileRecordFromHistoryRecord((HistoryRecord)recs.next(), c));
            }
        }
        return result;
    }

    @Override
    public Collection<FileRecord> findByPeriod(MetaContact contact, Date startDate, Date endDate, String[] keywords) throws RuntimeException {
        return this.findByPeriod(contact, startDate, endDate, keywords, false);
    }

    @Override
    public Collection<FileRecord> findByPeriod(MetaContact contact, Date startDate, Date endDate, String[] keywords, boolean caseSensitive) throws RuntimeException {
        TreeSet<FileRecord> result = new TreeSet<FileRecord>(new FileRecordComparator());
        Map<Contact, HistoryReader> readers = this.getHistoryReaders(contact);
        for (Map.Entry<Contact, HistoryReader> readerEntry : readers.entrySet()) {
            Contact c = readerEntry.getKey();
            HistoryReader reader = readerEntry.getValue();
            QueryResultSet recs = reader.findByPeriod(startDate, endDate, keywords, SEARCH_FIELD, caseSensitive);
            while (recs.hasNext()) {
                result.add(this.createFileRecordFromHistoryRecord((HistoryRecord)recs.next(), c));
            }
        }
        return result;
    }

    @Override
    public Collection<FileRecord> findByPeriod(MetaContact contact, Date startDate, Date endDate) throws RuntimeException {
        TreeSet<FileRecord> result = new TreeSet<FileRecord>(new FileRecordComparator());
        Map<Contact, HistoryReader> readers = this.getHistoryReaders(contact);
        for (Map.Entry<Contact, HistoryReader> readerEntry : readers.entrySet()) {
            Contact c = readerEntry.getKey();
            HistoryReader reader = readerEntry.getValue();
            QueryResultSet recs = reader.findByPeriod(startDate, endDate);
            while (recs.hasNext()) {
                result.add(this.createFileRecordFromHistoryRecord((HistoryRecord)recs.next(), c));
            }
        }
        return result;
    }

    @Override
    public Collection<FileRecord> findLast(MetaContact contact, int count) throws RuntimeException {
        TreeSet<FileRecord> result = new TreeSet<FileRecord>(new FileRecordComparator());
        Map<Contact, HistoryReader> readers = this.getHistoryReaders(contact);
        for (Map.Entry<Contact, HistoryReader> readerEntry : readers.entrySet()) {
            Contact c = readerEntry.getKey();
            HistoryReader reader = readerEntry.getValue();
            QueryResultSet recs = reader.findLast(count);
            while (recs.hasNext()) {
                result.add(this.createFileRecordFromHistoryRecord((HistoryRecord)recs.next(), c));
            }
        }
        return result;
    }

    @Override
    public Collection<FileRecord> findByKeyword(MetaContact contact, String keyword) throws RuntimeException {
        return this.findByKeyword(contact, keyword, false);
    }

    @Override
    public Collection<FileRecord> findByKeyword(MetaContact contact, String keyword, boolean caseSensitive) throws RuntimeException {
        return this.findByKeywords(contact, new String[]{keyword}, caseSensitive);
    }

    @Override
    public Collection<FileRecord> findByKeywords(MetaContact contact, String[] keywords) throws RuntimeException {
        return this.findByKeywords(contact, keywords, false);
    }

    @Override
    public Collection<FileRecord> findByKeywords(MetaContact contact, String[] keywords, boolean caseSensitive) throws RuntimeException {
        TreeSet<FileRecord> result = new TreeSet<FileRecord>(new FileRecordComparator());
        Map<Contact, HistoryReader> readers = this.getHistoryReaders(contact);
        for (Map.Entry<Contact, HistoryReader> readerEntry : readers.entrySet()) {
            Contact c = readerEntry.getKey();
            HistoryReader reader = readerEntry.getValue();
            QueryResultSet recs = reader.findByKeywords(keywords, SEARCH_FIELD, caseSensitive);
            while (recs.hasNext()) {
                result.add(this.createFileRecordFromHistoryRecord((HistoryRecord)recs.next(), c));
            }
        }
        return result;
    }

    @Override
    public Collection<FileRecord> findFirstRecordsAfter(MetaContact contact, Date date, int count) throws RuntimeException {
        TreeSet<FileRecord> result = new TreeSet<FileRecord>(new FileRecordComparator());
        Map<Contact, HistoryReader> readers = this.getHistoryReaders(contact);
        for (Map.Entry<Contact, HistoryReader> readerEntry : readers.entrySet()) {
            Contact c = readerEntry.getKey();
            HistoryReader reader = readerEntry.getValue();
            QueryResultSet recs = reader.findFirstRecordsAfter(date, count);
            while (recs.hasNext()) {
                result.add(this.createFileRecordFromHistoryRecord((HistoryRecord)recs.next(), c));
            }
        }
        int toIndex = count;
        LinkedList<FileRecord> resultAsList = new LinkedList<FileRecord>(result);
        if (toIndex > resultAsList.size()) {
            toIndex = resultAsList.size();
        }
        return resultAsList.subList(0, toIndex);
    }

    @Override
    public Collection<FileRecord> findLastRecordsBefore(MetaContact contact, Date date, int count) throws RuntimeException {
        TreeSet<FileRecord> result = new TreeSet<FileRecord>(new FileRecordComparator());
        Map<Contact, HistoryReader> readers = this.getHistoryReaders(contact);
        for (Map.Entry<Contact, HistoryReader> readerEntry : readers.entrySet()) {
            Contact c = readerEntry.getKey();
            HistoryReader reader = readerEntry.getValue();
            QueryResultSet recs = reader.findLastRecordsBefore(date, count);
            while (recs.hasNext()) {
                result.add(this.createFileRecordFromHistoryRecord((HistoryRecord)recs.next(), c));
            }
        }
        LinkedList<FileRecord> resultAsList = new LinkedList<FileRecord>(result);
        int startIndex = resultAsList.size() - count;
        if (startIndex < 0) {
            startIndex = 0;
        }
        return resultAsList.subList(startIndex, resultAsList.size());
    }

    public void serviceChanged(ServiceEvent serviceEvent) {
        Object sService = this.bundleContext.getService(serviceEvent.getServiceReference());
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Received a service event for: " + sService.getClass().getName()));
        }
        if (!(sService instanceof ProtocolProviderService)) {
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Service is a protocol provider.");
        }
        if (serviceEvent.getType() == 1) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Handling registration of a new Protocol Provider.");
            }
            this.handleProviderAdded((ProtocolProviderService)sService);
        } else if (serviceEvent.getType() == 4) {
            this.handleProviderRemoved((ProtocolProviderService)sService);
        }
    }

    private History getHistory(Contact localContact, Contact remoteContact) throws IOException {
        String localId = localContact == null ? "default" : localContact.getAddress();
        String remoteId = remoteContact == null ? "default" : remoteContact.getAddress();
        String account = "unkown";
        if (remoteContact != null) {
            account = remoteContact.getProtocolProvider().getAccountID().getAccountUniqueID();
        }
        HistoryID historyId = HistoryID.createFromRawID((String[])new String[]{"filehistory", localId, account, remoteId});
        return this.historyService.createHistory(historyId, recordStructure);
    }

    public void statusChanged(FileTransferStatusChangeEvent event) {
        try {
            FileTransfer ft = event.getFileTransfer();
            String status = FileHistoryServiceImpl.getStatus(ft.getStatus());
            if (status == null) {
                return;
            }
            History history = this.getHistory(null, ft.getContact());
            HistoryWriter historyWriter = history.getWriter();
            historyWriter.updateRecord(STRUCTURE_NAMES[4], ft.getID(), STRUCTURE_NAMES[3], status);
        }
        catch (IOException e) {
            logger.error((Object)"Could not update file transfer log to history", (Throwable)e);
        }
    }

    private static String getDirection(int direction) {
        switch (direction) {
            case 1: {
                return "in";
            }
            case 2: {
                return "out";
            }
        }
        return null;
    }

    private static String getStatus(int status) {
        switch (status) {
            case 1: {
                return "canceled";
            }
            case 0: {
                return "completed";
            }
            case 2: {
                return "failed";
            }
            case 3: {
                return "refused";
            }
        }
        return null;
    }

    public void fileTransferRequestReceived(FileTransferRequestEvent event) {
        try {
            IncomingFileTransferRequest req = event.getRequest();
            History history = this.getHistory(null, req.getSender());
            HistoryWriter historyWriter = history.getWriter();
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
            historyWriter.addRecord(new String[]{req.getFileName(), FileHistoryServiceImpl.getDirection(1), sdf.format(event.getTimestamp()), FILE_TRANSFER_ACTIVE, req.getID()});
        }
        catch (IOException e) {
            logger.error((Object)"Could not add file transfer log to history", (Throwable)e);
        }
    }

    public void fileTransferCreated(FileTransferCreatedEvent event) {
        FileTransfer fileTransfer = event.getFileTransfer();
        fileTransfer.addStatusListener((FileTransferStatusListener)this);
        try {
            History history = this.getHistory(null, fileTransfer.getContact());
            HistoryWriter historyWriter = history.getWriter();
            if (fileTransfer.getDirection() == 1) {
                historyWriter.updateRecord(STRUCTURE_NAMES[4], fileTransfer.getID(), STRUCTURE_NAMES[0], fileTransfer.getLocalFile().getCanonicalPath());
            } else if (fileTransfer.getDirection() == 2) {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
                historyWriter.addRecord(new String[]{fileTransfer.getLocalFile().getCanonicalPath(), FileHistoryServiceImpl.getDirection(2), sdf.format(event.getTimestamp()), FILE_TRANSFER_ACTIVE, fileTransfer.getID()});
            }
        }
        catch (IOException e) {
            logger.error((Object)"Could not add file transfer log to history", (Throwable)e);
        }
    }

    public void fileTransferRequestRejected(FileTransferRequestEvent event) {
        try {
            IncomingFileTransferRequest req = event.getRequest();
            History history = this.getHistory(null, req.getSender());
            HistoryWriter historyWriter = history.getWriter();
            historyWriter.updateRecord(STRUCTURE_NAMES[4], req.getID(), STRUCTURE_NAMES[3], "refused");
        }
        catch (IOException e) {
            logger.error((Object)"Could not add file transfer log to history", (Throwable)e);
        }
    }

    public void fileTransferRequestCanceled(FileTransferRequestEvent event) {
        try {
            IncomingFileTransferRequest req = event.getRequest();
            History history = this.getHistory(null, req.getSender());
            HistoryWriter historyWriter = history.getWriter();
            historyWriter.updateRecord(STRUCTURE_NAMES[4], req.getID(), STRUCTURE_NAMES[3], "canceled");
        }
        catch (IOException e) {
            logger.error((Object)"Could not add file transfer log to history", (Throwable)e);
        }
    }

    @Override
    public void eraseLocallyStoredHistory() throws IOException {
        HistoryID historyId = HistoryID.createFromRawID((String[])new String[]{"filehistory"});
        this.historyService.purgeLocallyStoredHistory(historyId);
    }

    @Override
    public void eraseLocallyStoredHistory(MetaContact contact) throws IOException {
        Iterator iter = contact.getContacts();
        while (iter.hasNext()) {
            Contact item = (Contact)iter.next();
            History history = this.getHistory(null, item);
            this.historyService.purgeLocallyStoredHistory(history.getID());
        }
    }

    private static class FileRecordComparator
    implements Comparator<FileRecord> {
        private FileRecordComparator() {
        }

        @Override
        public int compare(FileRecord o1, FileRecord o2) {
            Date date1 = o1.getDate();
            Date date2 = o2.getDate();
            return date1.compareTo(date2);
        }
    }
}

