/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.codec.audio.silk;

import org.jitsi.impl.neomedia.codec.audio.silk.Macros;
import org.jitsi.impl.neomedia.codec.audio.silk.SKP_Silk_range_coder_state;

public class RangeCoder {
    static void SKP_Silk_range_encoder(SKP_Silk_range_coder_state psRC, int data, int[] prob, int prob_offset) {
        long base_Q32 = psRC.base_Q32;
        long range_Q16 = psRC.range_Q16;
        int bufferIx = psRC.bufferIx;
        byte[] buffer = psRC.buffer;
        if (psRC.error != 0) {
            return;
        }
        long low_Q16 = prob[prob_offset + data];
        long high_Q16 = prob[prob_offset + data + 1];
        long base_tmp = base_Q32;
        base_Q32 += range_Q16 * low_Q16 & 0xFFFFFFFFL;
        long range_Q32 = range_Q16 * (high_Q16 - low_Q16) & 0xFFFFFFFFL;
        if ((base_Q32 &= 0xFFFFFFFFL) < base_tmp) {
            int n;
            int bufferIx_tmp = bufferIx;
            do {
                n = --bufferIx_tmp;
            } while ((buffer[n] = (byte)(buffer[n] + 1)) == 0);
        }
        if ((range_Q32 & 0xFF000000L) != 0L) {
            range_Q16 = range_Q32 >>> 16;
        } else {
            if ((range_Q32 & 0xFFFF0000L) != 0L) {
                range_Q16 = range_Q32 >>> 8;
            } else {
                range_Q16 = range_Q32;
                if (bufferIx >= psRC.bufferLength) {
                    psRC.error = -1;
                    return;
                }
                buffer[bufferIx++] = (byte)(base_Q32 >>> 24);
                base_Q32 = base_Q32 << 8 & 0xFFFFFFFFL;
            }
            if (bufferIx >= psRC.bufferLength) {
                psRC.error = -1;
                return;
            }
            buffer[bufferIx++] = (byte)(base_Q32 >>> 24);
            base_Q32 = base_Q32 << 8 & 0xFFFFFFFFL;
        }
        psRC.base_Q32 = base_Q32;
        psRC.range_Q16 = range_Q16;
        psRC.bufferIx = bufferIx;
    }

    static void SKP_Silk_range_encoder_multi(SKP_Silk_range_coder_state psRC, int[] data, int[][] prob, int nSymbols) {
        for (int k = 0; k < nSymbols; ++k) {
            RangeCoder.SKP_Silk_range_encoder(psRC, data[k], prob[k], 0);
        }
    }

    static void SKP_Silk_range_decoder(int[] data, int data_offset, SKP_Silk_range_coder_state psRC, int[] prob, int prob_offset, int probIx) {
        long low_Q16;
        long high_Q16;
        int buffer_offset;
        byte[] buffer;
        int bufferIx;
        long range_Q16;
        long base_Q32;
        block14: {
            base_Q32 = psRC.base_Q32;
            range_Q16 = psRC.range_Q16;
            bufferIx = psRC.bufferIx;
            buffer = psRC.buffer;
            buffer_offset = 4;
            if (psRC.error != 0) {
                data[data_offset + 0] = 0;
                return;
            }
            high_Q16 = prob[prob_offset + probIx];
            long base_tmp = range_Q16 * high_Q16 & 0xFFFFFFFFL;
            if (base_tmp > base_Q32) {
                while ((base_tmp = range_Q16 * (low_Q16 = (long)prob[--probIx + prob_offset]) & 0xFFFFFFFFL) > base_Q32) {
                    high_Q16 = low_Q16;
                    if (high_Q16 != 0L) continue;
                    psRC.error = -2;
                    data[data_offset + 0] = 0;
                    return;
                }
            } else {
                do {
                    low_Q16 = high_Q16;
                    if ((base_tmp = range_Q16 * (high_Q16 = (long)prob[++probIx + prob_offset]) & 0xFFFFFFFFL) > base_Q32) break block14;
                } while (high_Q16 != 65535L);
                psRC.error = -2;
                data[data_offset + 0] = 0;
                return;
            }
        }
        data[data_offset + 0] = --probIx;
        base_Q32 -= range_Q16 * low_Q16 & 0xFFFFFFFFL;
        base_Q32 &= 0xFFFFFFFFL;
        long range_Q32 = range_Q16 * (high_Q16 - low_Q16) & 0xFFFFFFFFL;
        if (((range_Q32 &= 0xFFFFFFFFL) & 0xFF000000L) != 0L) {
            range_Q16 = range_Q32 >>> 16;
        } else {
            if ((range_Q32 & 0xFFFF0000L) != 0L) {
                range_Q16 = range_Q32 >>> 8;
                if (base_Q32 >>> 24 != 0L) {
                    psRC.error = -3;
                    data[data_offset + 0] = 0;
                    return;
                }
            } else {
                range_Q16 = range_Q32;
                if (base_Q32 >>> 16 != 0L) {
                    psRC.error = -3;
                    data[data_offset + 0] = 0;
                    return;
                }
                base_Q32 <<= 8;
                base_Q32 &= 0xFFFFFFFFL;
                if (bufferIx < psRC.bufferLength) {
                    base_Q32 |= (long)(buffer[buffer_offset + bufferIx++] & 0xFF);
                }
            }
            base_Q32 <<= 8;
            base_Q32 &= 0xFFFFFFFFL;
            if (bufferIx < psRC.bufferLength) {
                base_Q32 |= (long)(buffer[buffer_offset + bufferIx++] & 0xFF);
            }
        }
        if (range_Q16 == 0L) {
            psRC.error = -4;
            data[data_offset + 0] = 0;
            return;
        }
        psRC.base_Q32 = base_Q32;
        psRC.range_Q16 = range_Q16;
        psRC.bufferIx = bufferIx;
    }

    static void SKP_Silk_range_decoder_multi(int[] data, SKP_Silk_range_coder_state psRC, int[][] prob, int[] probStartIx, int nSymbols) {
        for (int k = 0; k < nSymbols; ++k) {
            RangeCoder.SKP_Silk_range_decoder(data, k, psRC, prob[k], 0, probStartIx[k]);
        }
    }

    static void SKP_Silk_range_enc_init(SKP_Silk_range_coder_state psRC) {
        psRC.bufferLength = 1024;
        psRC.range_Q16 = 65535L;
        psRC.bufferIx = 0;
        psRC.base_Q32 = 0L;
        psRC.error = 0;
    }

    static void SKP_Silk_range_dec_init(SKP_Silk_range_coder_state psRC, byte[] buffer, int buffer_offset, int bufferLength) {
        if (bufferLength > 1024) {
            psRC.error = -8;
            return;
        }
        System.arraycopy(buffer, buffer_offset, psRC.buffer, 0, bufferLength);
        psRC.bufferLength = bufferLength;
        psRC.bufferIx = 0;
        psRC.base_Q32 = (long)((buffer[buffer_offset + 0] & 0xFF) << 24 | (buffer[buffer_offset + 1] & 0xFF) << 16 | (buffer[buffer_offset + 2] & 0xFF) << 8 | buffer[buffer_offset + 3] & 0xFF) & 0xFFFFFFFFL;
        psRC.range_Q16 = 65535L;
        psRC.error = 0;
    }

    static int SKP_Silk_range_coder_get_length(SKP_Silk_range_coder_state psRC, int[] nBytes) {
        int nBits = (psRC.bufferIx << 3) + Macros.SKP_Silk_CLZ32((int)(psRC.range_Q16 - 1L)) - 14;
        nBytes[0] = nBits + 7 >> 3;
        return nBits;
    }

    static void SKP_Silk_range_enc_wrap_up(SKP_Silk_range_coder_state psRC) {
        long base_Q24 = psRC.base_Q32 >>> 8;
        int[] nBytes_ptr = new int[1];
        int bits_in_stream = RangeCoder.SKP_Silk_range_coder_get_length(psRC, nBytes_ptr);
        int nBytes = nBytes_ptr[0];
        int bits_to_store = bits_in_stream - (psRC.bufferIx << 3);
        base_Q24 += (long)(0x800000 >>> bits_to_store - 1);
        base_Q24 &= 0xFFFFFFFFL;
        if (((base_Q24 &= (long)(-1 << 24 - bits_to_store)) & 0x1000000L) != 0L) {
            int n;
            int bufferIx_tmp = psRC.bufferIx;
            do {
                n = --bufferIx_tmp;
            } while ((psRC.buffer[n] = (byte)(psRC.buffer[n] + 1)) == 0);
        }
        if (psRC.bufferIx < psRC.bufferLength) {
            psRC.buffer[psRC.bufferIx++] = (byte)(base_Q24 >>> 16);
            if (bits_to_store > 8 && psRC.bufferIx < psRC.bufferLength) {
                psRC.buffer[psRC.bufferIx++] = (byte)(base_Q24 >>> 8);
            }
        }
        if ((bits_in_stream & 7) != 0) {
            int mask = 255 >> (bits_in_stream & 7);
            if (nBytes - 1 < psRC.bufferLength) {
                int n = nBytes - 1;
                psRC.buffer[n] = (byte)(psRC.buffer[n] | mask);
            }
        }
    }

    static void SKP_Silk_range_coder_check_after_decoding(SKP_Silk_range_coder_state psRC) {
        int mask;
        int[] nBytes_ptr = new int[1];
        int bits_in_stream = RangeCoder.SKP_Silk_range_coder_get_length(psRC, nBytes_ptr);
        int nBytes = nBytes_ptr[0];
        if (nBytes - 1 >= psRC.bufferLength) {
            psRC.error = -5;
            return;
        }
        if ((bits_in_stream & 7) != 0 && (psRC.buffer[nBytes - 1] & (mask = 255 >> (bits_in_stream & 7))) != mask) {
            psRC.error = -5;
            return;
        }
    }
}

