/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.service.neomedia;

import org.jitsi.service.neomedia.MediaStream;
import org.jitsi.service.neomedia.RTPTranslator;

public abstract class AbstractRTPTranslator
implements RTPTranslator {
    private static final RTPTranslator.WriteFilter[] NO_WRITE_FILTERS = new RTPTranslator.WriteFilter[0];
    private RTPTranslator.WriteFilter[] writeFilters = NO_WRITE_FILTERS;
    private final Object writeFiltersSyncRoot = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addWriteFilter(RTPTranslator.WriteFilter writeFilter) {
        if (writeFilter == null) {
            throw new NullPointerException("writeFilter");
        }
        Object object = this.writeFiltersSyncRoot;
        synchronized (object) {
            for (RTPTranslator.WriteFilter wf : this.writeFilters) {
                if (!wf.equals(writeFilter)) continue;
                return;
            }
            RTPTranslator.WriteFilter[] newWriteFilters = new RTPTranslator.WriteFilter[this.writeFilters.length + 1];
            if (this.writeFilters.length != 0) {
                System.arraycopy(this.writeFilters, 0, newWriteFilters, 0, this.writeFilters.length);
            }
            newWriteFilters[this.writeFilters.length] = writeFilter;
            this.writeFilters = newWriteFilters;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected RTPTranslator.WriteFilter[] getWriteFilters() {
        Object object = this.writeFiltersSyncRoot;
        synchronized (object) {
            return this.writeFilters.length == 0 ? NO_WRITE_FILTERS : (RTPTranslator.WriteFilter[])this.writeFilters.clone();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeWriteFilter(RTPTranslator.WriteFilter writeFilter) {
        if (writeFilter != null) {
            Object object = this.writeFiltersSyncRoot;
            synchronized (object) {
                for (int i = 0; i < this.writeFilters.length; ++i) {
                    RTPTranslator.WriteFilter[] newWriteFilters;
                    if (!this.writeFilters[i].equals(writeFilter)) continue;
                    if (this.writeFilters.length == 1) {
                        newWriteFilters = NO_WRITE_FILTERS;
                    } else {
                        int newWriteFiltersLength = this.writeFilters.length - 1;
                        newWriteFilters = new RTPTranslator.WriteFilter[newWriteFiltersLength];
                        if (i != 0) {
                            System.arraycopy(this.writeFilters, 0, newWriteFilters, 0, i);
                        }
                        if (i != newWriteFiltersLength) {
                            System.arraycopy(this.writeFilters, i + 1, newWriteFilters, i, newWriteFiltersLength - i);
                        }
                    }
                    this.writeFilters = newWriteFilters;
                    break;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean willWrite(MediaStream source, byte[] buffer, int offset, int length, MediaStream destination, boolean data) {
        RTPTranslator.WriteFilter writeFilter = null;
        RTPTranslator.WriteFilter[] writeFilters = null;
        boolean accept = true;
        Object object = this.writeFiltersSyncRoot;
        synchronized (object) {
            if (this.writeFilters.length != 0) {
                if (this.writeFilters.length == 1) {
                    writeFilter = this.writeFilters[0];
                } else {
                    writeFilters = (RTPTranslator.WriteFilter[])this.writeFilters.clone();
                }
            }
        }
        if (writeFilter != null) {
            accept = this.willWrite(writeFilter, source, buffer, offset, length, destination, data);
        } else if (writeFilters != null) {
            Object wf;
            object = writeFilters;
            int n = ((Object)object).length;
            for (int i = 0; i < n && (accept = this.willWrite((RTPTranslator.WriteFilter)(wf = object[i]), source, buffer, offset, length, destination, data)); ++i) {
            }
        }
        return accept;
    }

    protected boolean willWrite(RTPTranslator.WriteFilter writeFilter, MediaStream source, byte[] buffer, int offset, int length, MediaStream destination, boolean data) {
        boolean accept;
        block3: {
            try {
                accept = writeFilter.accept(source, buffer, offset, length, destination, data);
            }
            catch (Throwable t) {
                accept = true;
                if (t instanceof InterruptedException) {
                    Thread.currentThread().interrupt();
                }
                if (!(t instanceof ThreadDeath)) break block3;
                throw (ThreadDeath)t;
            }
        }
        return accept;
    }
}

