/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.netaddr;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.java.sip.communicator.service.netaddr.event.ChangeEvent;
import net.java.sip.communicator.service.netaddr.event.NetworkConfigurationChangeListener;
import net.java.sip.communicator.util.Logger;

public class NetworkEventDispatcher
implements Runnable {
    private static Logger logger = Logger.getLogger(NetworkEventDispatcher.class);
    private final List<NetworkConfigurationChangeListener> listeners = new ArrayList<NetworkConfigurationChangeListener>();
    private Map<ChangeEvent, Integer> eventsToDispatch = new LinkedHashMap<ChangeEvent, Integer>();
    private boolean stopped = true;
    private Thread dispatcherThread = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addNetworkConfigurationChangeListener(NetworkConfigurationChangeListener listener) {
        List<NetworkConfigurationChangeListener> list = this.listeners;
        synchronized (list) {
            if (!this.listeners.contains(listener)) {
                this.listeners.add(listener);
                if (this.dispatcherThread == null) {
                    this.dispatcherThread = new Thread(this);
                    this.dispatcherThread.start();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeNetworkConfigurationChangeListener(NetworkConfigurationChangeListener listener) {
        List<NetworkConfigurationChangeListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(listener);
        }
    }

    protected void fireChangeEvent(ChangeEvent evt) {
        this.fireChangeEvent(evt, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireChangeEvent(ChangeEvent evt, int wait) {
        Map<ChangeEvent, Integer> map = this.eventsToDispatch;
        synchronized (map) {
            this.eventsToDispatch.put(evt, wait);
            this.eventsToDispatch.notifyAll();
            if (this.dispatcherThread == null && this.listeners.size() > 0) {
                this.dispatcherThread = new Thread(this);
                this.dispatcherThread.start();
            }
        }
    }

    static void fireChangeEvent(ChangeEvent evt, NetworkConfigurationChangeListener listener) {
        try {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("firing event to " + listener + " evt=" + evt));
            }
            listener.configurationChanged(evt);
        }
        catch (Throwable e) {
            logger.warn((Object)("Error delivering event:" + evt + ", to:" + listener), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this.stopped = false;
            while (!this.stopped) {
                ArrayList<NetworkConfigurationChangeListener> listenersCopy;
                Map.Entry<ChangeEvent, Integer> eventToProcess = null;
                Object object = this.eventsToDispatch;
                synchronized (object) {
                    if (this.eventsToDispatch.size() == 0) {
                        try {
                            this.eventsToDispatch.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    if (this.listeners.size() == 0) {
                        continue;
                    }
                    listenersCopy = new ArrayList<NetworkConfigurationChangeListener>(this.listeners);
                    Iterator<Map.Entry<ChangeEvent, Integer>> iter = this.eventsToDispatch.entrySet().iterator();
                    if (iter.hasNext()) {
                        eventToProcess = iter.next();
                        iter.remove();
                    }
                }
                if (eventToProcess != null && listenersCopy != null) {
                    if (eventToProcess.getValue() > 0) {
                        object = this;
                        synchronized (object) {
                            try {
                                this.wait(eventToProcess.getValue().intValue());
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                        }
                    }
                    for (int i = 0; i < listenersCopy.size(); ++i) {
                        NetworkEventDispatcher.fireChangeEvent(eventToProcess.getKey(), (NetworkConfigurationChangeListener)listenersCopy.get(i));
                    }
                }
                eventToProcess = null;
                Object var2_3 = null;
            }
        }
        catch (Throwable t) {
            logger.error((Object)"Error dispatching thread ended unexpectedly", t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Map<ChangeEvent, Integer> map = this.eventsToDispatch;
        synchronized (map) {
            this.stopped = true;
            this.eventsToDispatch.notifyAll();
            this.dispatcherThread = null;
        }
    }

    public boolean isRunning() {
        return !this.stopped;
    }
}

