/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.gui.main.chatroomslist;

import java.util.Collection;
import java.util.List;
import java.util.Vector;
import net.java.sip.communicator.impl.gui.GuiActivator;
import net.java.sip.communicator.impl.gui.main.chat.conference.AdHocChatRoomProviderWrapper;
import net.java.sip.communicator.impl.gui.main.chat.conference.AdHocChatRoomWrapper;
import net.java.sip.communicator.service.protocol.AdHocChatRoom;
import net.java.sip.communicator.service.protocol.OperationSet;
import net.java.sip.communicator.service.protocol.OperationSetAdHocMultiUserChat;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import net.java.sip.communicator.util.ServiceUtils;
import org.jitsi.service.configuration.ConfigurationService;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class AdHocChatRoomList {
    private final List<AdHocChatRoomProviderWrapper> providersList = new Vector<AdHocChatRoomProviderWrapper>();

    public void loadList() {
        Collection serRefs = ServiceUtils.getServiceReferences((BundleContext)GuiActivator.bundleContext, ProtocolProviderService.class);
        if (serRefs != null && !serRefs.isEmpty()) {
            for (ServiceReference serRef : serRefs) {
                ProtocolProviderService protocolProvider = (ProtocolProviderService)GuiActivator.bundleContext.getService(serRef);
                OperationSet adHocMultiUserChatOpSet = protocolProvider.getOperationSet(OperationSetAdHocMultiUserChat.class);
                if (adHocMultiUserChatOpSet == null) continue;
                this.addChatProvider(protocolProvider);
            }
        }
    }

    public void addChatProvider(ProtocolProviderService pps) {
        AdHocChatRoomProviderWrapper chatRoomProvider = new AdHocChatRoomProviderWrapper(pps);
        this.providersList.add(chatRoomProvider);
        ConfigurationService configService = GuiActivator.getConfigurationService();
        String prefix = "net.java.sip.communicator.impl.gui.accounts";
        List accounts = configService.getPropertyNamesByPrefix(prefix, true);
        for (String accountRootPropName : accounts) {
            String accountUID = configService.getString(accountRootPropName);
            if (!accountUID.equals(pps.getAccountID().getAccountUniqueID())) continue;
            List chatRooms = configService.getPropertyNamesByPrefix(accountRootPropName + ".chatRooms", true);
            for (String chatRoomPropName : chatRooms) {
                String chatRoomID = configService.getString(chatRoomPropName);
                String chatRoomName = configService.getString(chatRoomPropName + ".chatRoomName");
                AdHocChatRoomWrapper chatRoomWrapper = new AdHocChatRoomWrapper(chatRoomProvider, chatRoomID, chatRoomName);
                chatRoomProvider.addAdHocChatRoom(chatRoomWrapper);
            }
        }
    }

    public void removeChatProvider(ProtocolProviderService pps) {
        AdHocChatRoomProviderWrapper wrapper = this.findServerWrapperFromProvider(pps);
        if (wrapper != null) {
            this.removeChatProvider(wrapper);
        }
    }

    private void removeChatProvider(AdHocChatRoomProviderWrapper adHocChatRoomProvider) {
        this.providersList.remove(adHocChatRoomProvider);
        ConfigurationService configService = GuiActivator.getConfigurationService();
        String prefix = "net.java.sip.communicator.impl.gui.accounts";
        String providerAccountUID = adHocChatRoomProvider.getProtocolProvider().getAccountID().getAccountUniqueID();
        for (String accountRootPropName : configService.getPropertyNamesByPrefix(prefix, true)) {
            String accountUID = configService.getString(accountRootPropName);
            if (!accountUID.equals(providerAccountUID)) continue;
            List chatRooms = configService.getPropertyNamesByPrefix(accountRootPropName + ".chatRooms", true);
            for (String chatRoomPropName : chatRooms) {
                configService.setProperty(chatRoomPropName + ".chatRoomName", null);
            }
            configService.setProperty(accountRootPropName, null);
        }
    }

    public void addAdHocChatRoom(AdHocChatRoomWrapper adHocChatRoomWrapper) {
        AdHocChatRoomProviderWrapper adHocChatRoomProvider = adHocChatRoomWrapper.getParentProvider();
        if (!adHocChatRoomProvider.containsAdHocChatRoom(adHocChatRoomWrapper)) {
            adHocChatRoomProvider.addAdHocChatRoom(adHocChatRoomWrapper);
        }
    }

    public void removeChatRoom(AdHocChatRoomWrapper adHocChatRoomWrapper) {
        AdHocChatRoomProviderWrapper adHocChatRoomProvider = adHocChatRoomWrapper.getParentProvider();
        if (this.providersList.contains(adHocChatRoomProvider)) {
            adHocChatRoomProvider.removeChatRoom(adHocChatRoomWrapper);
        }
    }

    public AdHocChatRoomWrapper findChatRoomWrapperFromAdHocChatRoom(AdHocChatRoom adHocChatRoom) {
        for (AdHocChatRoomProviderWrapper provider : this.providersList) {
            AdHocChatRoomWrapper chatRoomWrapper = provider.findChatRoomWrapperForAdHocChatRoom(adHocChatRoom);
            if (chatRoomWrapper == null) continue;
            if (chatRoomWrapper.getAdHocChatRoom() == null) {
                chatRoomWrapper.setAdHocChatRoom(adHocChatRoom);
            }
            return chatRoomWrapper;
        }
        return null;
    }

    public AdHocChatRoomProviderWrapper findServerWrapperFromProvider(ProtocolProviderService protocolProvider) {
        for (AdHocChatRoomProviderWrapper chatRoomProvider : this.providersList) {
            if (!chatRoomProvider.getProtocolProvider().equals(protocolProvider)) continue;
            return chatRoomProvider;
        }
        return null;
    }
}

